package com.bizvane.rights.vo.hotel.order;

import com.bizvane.rights.consts.BusinessConst;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class RightsHotelOrderRefundRequestVO implements Serializable {
    @ApiModelProperty("支付系统退款订单编号code")
    private String paymentRefundOrderCode;

    @ApiModelProperty("支付系统订单编号code")
    private String paymentPayOrderCode;

    @ApiModelProperty("商户支付配置系统编号code")
    private String paymentMerchantConfigCode;

    @ApiModelProperty("外部支付交易号")
    private String outTradeNo;

    @ApiModelProperty("外部退款交易号")
    private String outRefundNo;

    @ApiModelProperty("平台系统生成的退单号")
    private String channelRefundNo;

    @ApiModelProperty("平台系统生成的退款流水ID")
    private String channelRefundTransactionId;

    @ApiModelProperty("退款状态：0待退款 1退款成功 2退款失败")
    private Integer refundStatus;

    @ApiModelProperty("退款时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime refundTime;

    @ApiModelProperty("订单退款金额 单位元")
    private BigDecimal refundAmount;

}
