package com.bizvane.rights.feign.mobile;

import com.bizvane.rights.vo.service.*;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(value = "${feign.client.rights.name}", path = "${feign.client.rights.path}/serviceRecordMobile")
public interface ServiceRecordMobileFeign {

    @ApiModelProperty("查询服务记录列表")
    @PostMapping("/pageList")
    ResponseData<PageInfo<RightsServiceRecordDetailResponseVO>> pageList(@RequestBody RightsServiceRecordDetailRequestVO requestVO);

    @ApiModelProperty("无障碍车位预约详情")
    @PostMapping("/barrierFreeParkingDetail")
    ResponseData<RightsBarrierFreeParkingDetailResponseVO> barrierFreeParkingDetail(@RequestBody RightsServiceDetailRequestVO requestVO);

    @ApiModelProperty("特殊旅客详情")
    @PostMapping("/specialPassengerDetail")
    ResponseData<RightsSpecialPassengerDetailResponseVO> specialPassengerDetail(@RequestBody RightsServiceDetailRequestVO requestVO);

    @ApiModelProperty("行李门到门详情")
    @PostMapping("/luggageDoorToDoorDetail")
    ResponseData<RightsLuggageDoorToDoorDetailResponseVO> luggageDoorToDoorDetail(@RequestBody RightsServiceDetailRequestVO requestVO);

    @ApiModelProperty("更新主表评价状态")
    @PostMapping("/updateReviewStatus")
    ResponseData<Boolean> updateReviewStatus(@RequestBody RightsServiceRecordUpdateReviewsStatusVO vo);
}
