package com.bizvane.rights.feign;

import com.bizvane.rights.vo.hotel.roomsituation.RightsHotelRoomSituationBatchUpdateRequestVO;
import com.bizvane.rights.vo.hotel.roomsituation.RightsHotelRoomSituationDaysConditionRequestVO;
import com.bizvane.rights.vo.hotel.roomsituation.RightsHotelRoomSituationDaysConditionResponseVO;
import com.bizvane.rights.vo.hotel.roomsituation.RightsHotelRoomSituationDaysRequestVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 酒店房态feign
 *
 * @author liuying
 */
@Api(value = "酒店房态", tags = "酒店房态")
@FeignClient(value = "${feign.client.rights.name}", path = "${feign.client.rights.path}/hotelRoomSituation")
public interface HotelRoomSituationFeign {

    /**
     * 1.条件查询酒店房型房态列表,不分页
     * 2.房型条件查询酒店房型房态明细
     * 3.批量维护房型房态
     */
    @ApiOperation(value = "条件查询酒店房型房态列表,不分页", notes = "条件查询酒店房型房态列表,不分页", httpMethod = "POST")
    @PostMapping("listRoomSituationByDaysCondition")
    ResponseData<RightsHotelRoomSituationDaysConditionResponseVO> listRoomSituationByDaysCondition(@RequestBody RightsHotelRoomSituationDaysConditionRequestVO requestVO);

    @ApiOperation(value = "查询某天酒店房型房态明细", notes = "条件查询酒店房型房态列表,不分页", httpMethod = "POST")
    @PostMapping("detailRoomSituationByDays")
    ResponseData<RightsHotelRoomSituationDaysConditionResponseVO> detailRoomSituationByDays(@RequestBody RightsHotelRoomSituationDaysRequestVO requestVO);

    @ApiOperation(value = "批量维护房型房态", notes = "批量维护房型房态", httpMethod = "POST")
    @PostMapping("batchUpdateRoomSituation")
    ResponseData batchUpdateRoomSituation(@RequestBody RightsHotelRoomSituationBatchUpdateRequestVO requestVO);
}
