/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.service.listener;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import com.alibaba.fastjson.JSON;
import com.bizvane.rights.api.service.component.OrderComponent;
import com.bizvane.rights.mq.ParkingOrderMq;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RocketMQMessageListener(topic="SYNC_ORDER_AND_SERVICE", tags={"ORDER_PARKING"})
public class ParkingOrderListener
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(ParkingOrderListener.class);
    private final OrderComponent orderComponent;

    public void onMessage(ConsumerMessage<String> message) {
        log.info("ParkingOrderListener.start:{}", message.getMessage());
        ParkingOrderMq parkingOrderMq = (ParkingOrderMq)JSON.parseObject((String)((String)message.getMessage()), ParkingOrderMq.class);
        try {
            ResponseData booleanResponseData = this.orderComponent.syncParkingOrderSync(parkingOrderMq.getParkingRecordNo());
            log.info("ParkingOrderListener:{}", (Object)JacksonUtil.bean2Json((Object)booleanResponseData));
        }
        catch (Exception e) {
            log.error("\u505c\u8f66\u8ba2\u5355\u540c\u6b65\u5f02\u5e38:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
        log.info("ParkingOrderListener.end");
    }

    public ParkingOrderListener(OrderComponent orderComponent) {
        this.orderComponent = orderComponent;
    }
}

