/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.service.impl;

import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.basic.feign.feign.TBaseGoodsSkuFeign;
import com.bizvane.basic.feign.model.req.GoodsReq;
import com.bizvane.rights.api.util.UID;
import com.bizvane.rights.domain.model.entity.StewardServiceDescriptionPO;
import com.bizvane.rights.domain.model.entity.StewardServicePO;
import com.bizvane.rights.domain.service.IStewardServiceDescriptionService;
import com.bizvane.rights.domain.service.IStewardServiceService;
import com.bizvane.rights.domain.util.ResponseUtil;
import com.bizvane.rights.vo.steward.StatusReqVO;
import com.bizvane.rights.vo.steward.StewardQueryReqVO;
import com.bizvane.rights.vo.steward.StewardServiceDescriptionReqRespVO;
import com.bizvane.rights.vo.steward.StewardServiceReqRespVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StewardService {
    private static final Logger log = LoggerFactory.getLogger(StewardService.class);
    @Autowired
    private final IStewardServiceService stewardServiceService;
    @Autowired
    private TBaseGoodsSkuFeign baseGoodsSkuFeign;
    @Autowired
    private RocketMQTemplate rocketMQTemplate;
    @Autowired
    private final IStewardServiceDescriptionService stewardServiceDescriptionService;

    public ResponseData<Boolean> addOrUpdate(StewardServiceReqRespVO requestVO) {
        StewardServicePO stewardServicePO;
        StewardServicePO one = (StewardServicePO)this.stewardServiceService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(StewardServicePO::getValid, (Object)true)).eq(StewardServicePO::getAirportCode, (Object)requestVO.getServiceNo())).eq(StewardServicePO::getServiceNo, (Object)requestVO.getServiceNo())).last("LIMIT 1"));
        if (null != one) {
            ResponseUtil.fail((String)"\u670d\u52a1\u4ee3\u7801\u91cd\u590d");
        }
        if (null == (stewardServicePO = this.detailByStewardServiceCode(requestVO.getStewardServiceCode()))) {
            StewardServicePO po = new StewardServicePO();
            BeanUtil.copyProperties((Object)requestVO, (Object)po, (CopyOptions)CopyOptions.create().ignoreNullValue());
            po.setAirportCode(requestVO.getAirportCode());
            po.setCreateUserCode(requestVO.getOptUserCode());
            po.setCreateUserName(requestVO.getOptUserName());
            po.setStewardServiceType(Integer.valueOf(0));
            return this.addStewardService(po);
        }
        BeanUtil.copyProperties((Object)requestVO, (Object)stewardServicePO, (CopyOptions)CopyOptions.create().ignoreNullValue());
        stewardServicePO.setAirportCode(requestVO.getAirportCode());
        stewardServicePO.setModifiedUserName(requestVO.getOptUserName());
        stewardServicePO.setModifiedUserCode(requestVO.getOptUserCode());
        stewardServicePO.setModifiedDate(LocalDateTime.now());
        return this.updateStewardService(stewardServicePO);
    }

    public ResponseData<Boolean> saveDescription(StewardServiceDescriptionReqRespVO requestVO) {
        String telePhone = requestVO.getTelePhone();
        if (20 < telePhone.length()) {
            return ResponseUtil.fail((String)"\u670d\u52a1\u53f7\u7801\u592a\u957f");
        }
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().last("limit 1");
        StewardServiceDescriptionPO one = (StewardServiceDescriptionPO)this.stewardServiceDescriptionService.getOne((Wrapper)queryWrapper);
        if (null == one) {
            StewardServiceDescriptionPO po = new StewardServiceDescriptionPO();
            BeanUtil.copyProperties((Object)requestVO, (Object)po, (CopyOptions)CopyOptions.create().ignoreNullValue());
            return this.saveDescription(po);
        }
        BeanUtil.copyProperties((Object)requestVO, (Object)one, (CopyOptions)CopyOptions.create().ignoreNullValue());
        one.setModifiedDate(LocalDateTime.now());
        boolean update = this.stewardServiceDescriptionService.updateById((Object)one);
        return ResponseUtil.success((Object)update);
    }

    public ResponseData<StewardServiceDescriptionReqRespVO> detailDescription() {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().last("limit 1");
        StewardServiceDescriptionPO one = (StewardServiceDescriptionPO)this.stewardServiceDescriptionService.getOne((Wrapper)queryWrapper);
        StewardServiceDescriptionReqRespVO vo = new StewardServiceDescriptionReqRespVO();
        if (one != null) {
            BeanUtil.copyProperties((Object)one, (Object)vo, (CopyOptions)CopyOptions.create().ignoreNullValue());
        }
        return ResponseUtil.success((Object)vo);
    }

    public ResponseData<StewardServiceReqRespVO> detailService(StatusReqVO serviceVo) {
        StewardServicePO stewardServicePO = this.detailByStewardServiceCode(serviceVo.getStewardServiceCode());
        StewardServiceReqRespVO vo = new StewardServiceReqRespVO();
        BeanUtil.copyProperties((Object)stewardServicePO, (Object)vo, (CopyOptions)CopyOptions.create().ignoreNullValue());
        return ResponseUtil.success((Object)vo);
    }

    public ResponseData<PageInfo<StewardServiceReqRespVO>> pageList(StewardQueryReqVO stewardServiceVO) {
        Page page = this.stewardServiceService.pageList(stewardServiceVO);
        PageInfo pageInfo = new PageInfo((int)page.getCurrent(), (int)page.getSize(), page.getTotal(), page.getRecords());
        return ResponseUtil.success((Object)pageInfo);
    }

    public ResponseData<Boolean> saveDescription(StewardServiceDescriptionPO po) {
        po.setStewardServiceDescriptionCode(UID.getUid());
        po.setCreateDate(LocalDateTime.now());
        po.setModifiedDate(LocalDateTime.now());
        boolean update = this.stewardServiceDescriptionService.save((Object)po);
        return ResponseUtil.success((Object)update);
    }

    public ResponseData<Boolean> changeStatus(StatusReqVO requestVO) {
        StewardServicePO stewardServicePO = this.detailByStewardServiceCode(requestVO.getStewardServiceCode());
        stewardServicePO.setStatus(requestVO.getStatus());
        stewardServicePO.setModifiedDate(LocalDateTime.now());
        stewardServicePO.setModifiedUserCode(requestVO.getModifiedUserCode());
        stewardServicePO.setModifiedUserName(requestVO.getModifiedUserName());
        ResponseData responseData = this.updateStewardService(stewardServicePO);
        return responseData;
    }

    private StewardServicePO detailByStewardServiceCode(String serviceCode) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(StewardServicePO::getStewardServiceCode, (Object)serviceCode)).last("limit 1");
        StewardServicePO one = (StewardServicePO)this.stewardServiceService.getOne((Wrapper)queryWrapper);
        return one;
    }

    private ResponseData addStewardService(StewardServicePO requestPO) {
        requestPO.setStewardServiceCode(UID.getUid());
        requestPO.setCreateDate(LocalDateTime.now());
        boolean save = this.stewardServiceService.save((Object)requestPO);
        if (save) {
            this.syncGoods(requestPO);
        }
        return ResponseUtil.success((Object)save);
    }

    private void syncGoods(StewardServicePO requestPO) {
        GoodsReq goodsReq = new GoodsReq();
        goodsReq.setGoodsName(requestPO.getName());
        goodsReq.setGoodsNo(requestPO.getServiceNo());
        goodsReq.setGoodsStatus(requestPO.getStatus());
        goodsReq.setAirportCode(requestPO.getAirportCode());
        goodsReq.setMerchantCode("AIRPORT_BUTLER_ONLY_NO");
        goodsReq.setSkuName(requestPO.getName());
        goodsReq.setImg(requestPO.getMainImageUrl());
        goodsReq.setSkuNo(requestPO.getServiceNo());
        goodsReq.setSkuPrice(requestPO.getOriginalPrice());
        goodsReq.setCreateUserCode(requestPO.getCreateUserCode());
        goodsReq.setCreateUserName(requestPO.getCreateUserName());
        goodsReq.setSourceCode("10");
        goodsReq.setChannelCode("10");
        try {
            this.baseGoodsSkuFeign.save(goodsReq);
            log.info("\u540c\u6b65\u7ba1\u5bb6\u670d\u52a1\u5230\u5546\u54c1\u6210\u529f:{}", (Object)goodsReq);
        }
        catch (Exception e) {
            log.error("\u540c\u6b65\u7ba1\u5bb6\u670d\u52a1\u5230\u5546\u54c1\u5931\u8d25\uff1a{}", (Throwable)e);
        }
    }

    private ResponseData updateStewardService(StewardServicePO requestPO) {
        boolean save = this.stewardServiceService.updateById((Object)requestPO);
        if (save) {
            this.syncGoods(requestPO);
        }
        return ResponseUtil.success((Object)save);
    }

    public StewardService(IStewardServiceService stewardServiceService, IStewardServiceDescriptionService stewardServiceDescriptionService) {
        this.stewardServiceService = stewardServiceService;
        this.stewardServiceDescriptionService = stewardServiceDescriptionService;
    }
}

