/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.bizvane.rights.api.service.EvaluateLabelService;
import com.bizvane.rights.domain.model.entity.RightEvaluateLabelPO;
import com.bizvane.rights.domain.service.IRightsEvaluateLabelService;
import com.bizvane.rights.domain.util.ResponseUtil;
import com.bizvane.rights.enums.EvaluateLabelTypeEnum;
import com.bizvane.rights.vo.evaluate.EvaluateLabelAddRequestVO;
import com.bizvane.rights.vo.evaluate.EvaluateLabelGroupResponseVO;
import com.bizvane.rights.vo.evaluate.EvaluateLabelRequestVO;
import com.bizvane.rights.vo.evaluate.EvaluateLabelResponseVO;
import com.bizvane.rights.vo.evaluate.RightEvaluateLabelResponseVO;
import com.bizvane.utils.enumutils.ValidEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class EvaluateLabelServiceImpl
implements EvaluateLabelService {
    private static final Logger log = LoggerFactory.getLogger(EvaluateLabelServiceImpl.class);
    private final IRightsEvaluateLabelService rightsEvaluateService;

    public List<EvaluateLabelGroupResponseVO> listAll() {
        HashMap<Integer, EvaluateLabelGroupResponseVO> groupMap = new HashMap<Integer, EvaluateLabelGroupResponseVO>();
        for (EvaluateLabelTypeEnum labelType : EvaluateLabelTypeEnum.values()) {
            EvaluateLabelGroupResponseVO evaluateLabelGroupResponseVO = new EvaluateLabelGroupResponseVO();
            evaluateLabelGroupResponseVO.setLabelType(labelType.getCode());
            evaluateLabelGroupResponseVO.setLabelTypeDesc(labelType.getDesc());
            evaluateLabelGroupResponseVO.setList(new ArrayList());
            groupMap.put(labelType.getCode(), evaluateLabelGroupResponseVO);
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(RightEvaluateLabelPO::getValid, (Object)ValidEnum.VALID.getCode());
        List list = this.rightsEvaluateService.list((Wrapper)queryWrapper);
        for (RightEvaluateLabelPO item : list) {
            EvaluateLabelResponseVO evaluateLabelResponseVO = new EvaluateLabelResponseVO();
            BeanUtils.copyProperties((Object)item, (Object)evaluateLabelResponseVO);
            Integer labelType = item.getLabelType();
            EvaluateLabelGroupResponseVO evaluateLabelGroupResponseVO = (EvaluateLabelGroupResponseVO)groupMap.get(labelType);
            if (evaluateLabelGroupResponseVO == null) continue;
            evaluateLabelGroupResponseVO.getList().add(evaluateLabelResponseVO);
        }
        return new ArrayList<EvaluateLabelGroupResponseVO>(groupMap.values());
    }

    public RightEvaluateLabelResponseVO updateVaild(EvaluateLabelRequestVO requestVO) {
        LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.set(RightEvaluateLabelPO::getValid, (Object)ValidEnum.UN_VALID.getCode())).set(RightEvaluateLabelPO::getModifiedUserCode, (Object)requestVO.getOptUserCode())).set(RightEvaluateLabelPO::getModifiedUserName, (Object)requestVO.getOptUserName())).set(RightEvaluateLabelPO::getModifiedDate, (Object)LocalDateTime.now())).eq(RightEvaluateLabelPO::getRightsEvaluateLabelCode, (Object)requestVO.getRightsEvaluateLabelCode());
        boolean update = this.rightsEvaluateService.update((Wrapper)updateWrapper);
        RightEvaluateLabelResponseVO responseVO = new RightEvaluateLabelResponseVO();
        responseVO.setOptStatus(update);
        return responseVO;
    }

    public ResponseData<RightEvaluateLabelResponseVO> add(EvaluateLabelAddRequestVO requestVO) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(RightEvaluateLabelPO::getLabelName, (Object)requestVO.getLabelName())).eq(RightEvaluateLabelPO::getLabelType, (Object)requestVO.getLabelType())).eq(RightEvaluateLabelPO::getValid, (Object)ValidEnum.VALID.getCode());
        boolean exists = this.rightsEvaluateService.exists((Wrapper)queryWrapper);
        if (exists) {
            return ResponseUtil.fail((String)"\u5b58\u5728\u540c\u6837\u6807\u7b7e");
        }
        RightEvaluateLabelPO rightEvaluateLabelPO = new RightEvaluateLabelPO();
        rightEvaluateLabelPO.setCreateDate(LocalDateTime.now());
        rightEvaluateLabelPO.setCreateUserCode(requestVO.getOptUserCode());
        rightEvaluateLabelPO.setLabelType(requestVO.getLabelType());
        rightEvaluateLabelPO.setLabelName(requestVO.getLabelName());
        boolean save = this.rightsEvaluateService.save((Object)rightEvaluateLabelPO);
        if (save) {
            rightEvaluateLabelPO.setRightsEvaluateLabelCode(rightEvaluateLabelPO.getId().toString());
            this.rightsEvaluateService.updateById((Object)rightEvaluateLabelPO);
        }
        RightEvaluateLabelResponseVO responseVO = new RightEvaluateLabelResponseVO();
        responseVO.setOptStatus(save);
        return ResponseUtil.success((Object)responseVO);
    }

    public EvaluateLabelResponseVO detailByCode(String rightsEvaluateLabelCode) {
        RightEvaluateLabelPO po = (RightEvaluateLabelPO)this.rightsEvaluateService.getOne((Wrapper)Wrappers.lambdaQuery().eq(RightEvaluateLabelPO::getRightsEvaluateLabelCode, (Object)rightsEvaluateLabelCode));
        EvaluateLabelResponseVO evaluateLabelResponseVO = new EvaluateLabelResponseVO();
        if (po != null) {
            BeanUtils.copyProperties((Object)po, (Object)evaluateLabelResponseVO);
            return evaluateLabelResponseVO;
        }
        return null;
    }

    public List<EvaluateLabelResponseVO> detailByLabelType(Integer labelType) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(RightEvaluateLabelPO::getLabelType, (Object)labelType)).eq(RightEvaluateLabelPO::getValid, (Object)ValidEnum.VALID.getCode());
        List list = this.rightsEvaluateService.list((Wrapper)queryWrapper);
        ArrayList<EvaluateLabelResponseVO> labelResponseVOS = new ArrayList<EvaluateLabelResponseVO>();
        for (RightEvaluateLabelPO item : list) {
            EvaluateLabelResponseVO evaluateLabelResponseVO = new EvaluateLabelResponseVO();
            BeanUtils.copyProperties((Object)item, (Object)evaluateLabelResponseVO);
            labelResponseVOS.add(evaluateLabelResponseVO);
        }
        return labelResponseVOS;
    }

    public EvaluateLabelServiceImpl(IRightsEvaluateLabelService rightsEvaluateService) {
        this.rightsEvaluateService = rightsEvaluateService;
    }
}

