/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.service.listener;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import com.alibaba.fastjson.JSON;
import com.bizvane.rights.api.service.component.OrderComponent;
import com.bizvane.rights.mq.HotelOrderMq;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RocketMQMessageListener(topic="")
public class StewardOrderListener
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(StewardOrderListener.class);
    private final OrderComponent orderComponent;

    public void onMessage(ConsumerMessage<String> message) {
        log.info("StewardOrderListener.start:{}", message.getMessage());
        HotelOrderMq hotelOrderMq = (HotelOrderMq)JSON.parseObject((String)((String)message.getMessage()), HotelOrderMq.class);
        try {
            ResponseData booleanResponseData = this.orderComponent.syncStewardOrders(hotelOrderMq.getRightsHotelOrderCode());
            log.info("syncStewardOrders:{}", (Object)JacksonUtil.bean2Json((Object)booleanResponseData));
        }
        catch (Exception e) {
            log.error("\u7ba1\u5bb6\u8ba2\u5355\u540c\u6b65\u5f02\u5e38:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
        log.info("StewardOrderListener.end");
    }

    public StewardOrderListener(OrderComponent orderComponent) {
        this.orderComponent = orderComponent;
    }
}

