/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.service.listener;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import com.alibaba.fastjson.JSON;
import com.bizvane.rights.api.service.component.ProductComponent;
import com.bizvane.rights.mq.HotelProductMq;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RocketMQMessageListener(topic="SYNC_ORDER_AND_SERVICE", tags={"PRODUCT_HOTEL"})
public class HotelProductListener
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(HotelProductListener.class);
    private final ProductComponent productComponent;

    public void onMessage(ConsumerMessage<String> message) {
        log.info("HotelProductListener.start:{}", message.getMessage());
        HotelProductMq hotelProductMq = (HotelProductMq)JSON.parseObject((String)((String)message.getMessage()), HotelProductMq.class);
        try {
            ResponseData booleanResponseData = this.productComponent.syncHotelProductSync(hotelProductMq.getRoomTypeCode());
            log.info("syncHotelProductSync:{}", (Object)JacksonUtil.bean2Json((Object)booleanResponseData));
        }
        catch (Exception e) {
            log.error("\u9152\u5e97\u623f\u578b\u5546\u54c1\u540c\u6b65\u5f02\u5e38:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
        log.info("HotelProductListener.end");
    }

    public HotelProductListener(ProductComponent productComponent) {
        this.productComponent = productComponent;
    }
}

