/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.basic.feign.enums.ApproveTaskStatusEnum;
import com.bizvane.rights.api.service.MobileStaffBenefitService;
import com.bizvane.rights.consts.BusinessConst;
import com.bizvane.rights.domain.model.entity.TMktStaffBenefit;
import com.bizvane.rights.domain.model.entity.TMktStaffBenefitType;
import com.bizvane.rights.domain.service.ITMktStaffBenefitService;
import com.bizvane.rights.domain.service.ITMktStaffBenefitTypeService;
import com.bizvane.rights.domain.util.ResponseUtil;
import com.bizvane.rights.vo.staffbenefit.QueryStaffBenefitDetailRespVO;
import com.bizvane.rights.vo.staffbenefit.QueryStaffBenefitTypeRespVO;
import com.bizvane.rights.vo.staffbenefit.mobile.MobileStaffBenefitPageReqVO;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MobileStaffBenefitServiceImpl
implements MobileStaffBenefitService {
    private static final Logger log = LoggerFactory.getLogger(MobileStaffBenefitServiceImpl.class);
    @Autowired
    private ITMktStaffBenefitService itMktStaffBenefitService;
    @Autowired
    private ITMktStaffBenefitTypeService itMktStaffBenefitTypeService;

    public ResponseData<List<QueryStaffBenefitTypeRespVO>> getStaffBenefitTypeList() {
        List tMktStaffBenefitTypeList = this.itMktStaffBenefitTypeService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktStaffBenefitType.class).eq(TMktStaffBenefitType::getValid, (Object)BusinessConst.EFFECTIVE)).orderByAsc(TMktStaffBenefitType::getSort));
        List respVOList = null;
        if (CollUtil.isNotEmpty((Collection)tMktStaffBenefitTypeList)) {
            respVOList = tMktStaffBenefitTypeList.stream().map(item -> (QueryStaffBenefitTypeRespVO)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)item), QueryStaffBenefitTypeRespVO.class)).collect(Collectors.toList());
        }
        return ResponseUtil.success(respVOList);
    }

    public ResponseData<PageInfo<QueryStaffBenefitDetailRespVO>> pageList(MobileStaffBenefitPageReqVO reqVO) {
        IPage page = ((Page)this.itMktStaffBenefitService.page((IPage)new Page((long)reqVO.getPageNum().intValue(), (long)reqVO.getPageSize().intValue()), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktStaffBenefit.class).eq(StrUtil.isNotBlank((CharSequence)reqVO.getMktStaffBenefitTypeCode()), TMktStaffBenefit::getMktStaffBenefitTypeCode, (Object)reqVO.getMktStaffBenefitTypeCode())).eq(TMktStaffBenefit::getValid, (Object)BusinessConst.EFFECTIVE)).eq(TMktStaffBenefit::getUpState, (Object)1)).eq(TMktStaffBenefit::getEnableStatus, (Object)1)).lt(TMktStaffBenefit::getOpenStartTime, (Object)LocalDateTime.now())).gt(TMktStaffBenefit::getOpenEndTime, (Object)LocalDateTime.now())).eq(TMktStaffBenefit::getCheckStatus, (Object)ApproveTaskStatusEnum.APPROVE_PASS.getCode())).like(StrUtil.isNotBlank((CharSequence)reqVO.getBenefitName()), TMktStaffBenefit::getBenefitName, (Object)reqVO.getBenefitName())).last("order by ifnull(sort, 2147483647) asc, create_date desc "))).convert(item -> {
            QueryStaffBenefitDetailRespVO respVO = (QueryStaffBenefitDetailRespVO)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)item), QueryStaffBenefitDetailRespVO.class);
            LocalDateTime openEndTime = item.getOpenEndTime();
            LocalDateTime openStartTime = item.getOpenStartTime();
            Integer upState = item.getUpState();
            if (openStartTime.isAfter(LocalDateTime.now())) {
                respVO.setState(Integer.valueOf(0));
            } else if (openStartTime.isBefore(LocalDateTime.now()) && openEndTime.isAfter(LocalDateTime.now()) && ObjUtil.notEqual((Object)upState, (Object)2)) {
                respVO.setState(Integer.valueOf(1));
            } else if (openStartTime.isBefore(LocalDateTime.now()) && openEndTime.isAfter(LocalDateTime.now()) && ObjUtil.equal((Object)upState, (Object)2)) {
                respVO.setState(Integer.valueOf(2));
            } else if (openEndTime.isBefore(LocalDateTime.now())) {
                respVO.setState(Integer.valueOf(3));
            }
            return respVO;
        });
        PageInfo pageInfo = new PageInfo((int)page.getCurrent(), (int)page.getSize(), page.getTotal(), page.getRecords());
        return ResponseUtil.success((Object)pageInfo);
    }

    public ResponseData<QueryStaffBenefitDetailRespVO> getDetail(String mktStaffBenefitCode) {
        TMktStaffBenefit tMktStaffBenefit = (TMktStaffBenefit)this.itMktStaffBenefitService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktStaffBenefit.class).eq(TMktStaffBenefit::getMktStaffBenefitCode, (Object)mktStaffBenefitCode)).eq(TMktStaffBenefit::getValid, (Object)BusinessConst.EFFECTIVE));
        QueryStaffBenefitDetailRespVO respVO = (QueryStaffBenefitDetailRespVO)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)tMktStaffBenefit), QueryStaffBenefitDetailRespVO.class);
        return ResponseUtil.success((Object)respVO);
    }
}

