/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.service.component;

import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import com.alibaba.fastjson.JSON;
import com.bizvane.rights.api.service.ServiceRecordService;
import com.bizvane.rights.domain.enums.ServiceTypeEnum;
import com.bizvane.rights.domain.model.entity.RightsBarrierFreeParkingRecordPO;
import com.bizvane.rights.domain.model.entity.RightsLuggageDoorToDoorPO;
import com.bizvane.rights.domain.model.entity.RightsSpecialPassengerFlightPO;
import com.bizvane.rights.domain.model.entity.RightsSpecialPassengerRecordPO;
import com.bizvane.rights.domain.service.IRightsBarrierFreeParkingRecordService;
import com.bizvane.rights.domain.service.IRightsLuggageDoorToDoorService;
import com.bizvane.rights.domain.service.IRightsSpecialPassengerFlightService;
import com.bizvane.rights.domain.service.IRightsSpecialPassengerRecordService;
import com.bizvane.rights.domain.util.ResponseUtil;
import com.bizvane.rights.mq.SeviceChangeMq;
import com.bizvane.rights.vo.service.RightsServiceRecordAddRequestVO;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ServiceComponent {
    private static final Logger log = LoggerFactory.getLogger(ServiceComponent.class);
    private final RocketMQTemplate rocketMQTemplate;
    private final ServiceRecordService serviceRecordService;
    private final IRightsSpecialPassengerRecordService rightsSpecialPassengerRecordService;
    private final IRightsSpecialPassengerFlightService rightsSpecialPassengerFlightService;
    private final IRightsLuggageDoorToDoorService rightsLuggageDoorToDoorService;
    private final IRightsBarrierFreeParkingRecordService rightsBarrierFreeParkingRecordService;

    public void syncBarrierFreeParkingAsync(String rightsBarrierFreeParkingRecordCode) {
        SeviceChangeMq seviceChangeMq = SeviceChangeMq.builder().serviceType(ServiceTypeEnum.TWO.getServiceType()).serviceCode(rightsBarrierFreeParkingRecordCode).build();
        log.info("\u65e0\u969c\u788d\u8f66\u4f4d\u9884\u7ea6\u540c\u6b65:{}", (Object)JacksonUtil.bean2Json((Object)seviceChangeMq));
        try {
            this.rocketMQTemplate.send(Destination.builder().topic("SYNC_ORDER_AND_SERVICE").tag("SERVICE_BARRIER_FREE_PARKING").build(), (Object)JSON.toJSONString((Object)seviceChangeMq));
        }
        catch (Exception e) {
            log.error("\u65e0\u969c\u788d\u8f66\u4f4d\u9884\u7ea6\u540c\u6b65\u5f02\u5e38:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public void syncLuggageDoorToDoorAsync(String rightsLuggageDoorToDoorCode) {
        SeviceChangeMq seviceChangeMq = SeviceChangeMq.builder().serviceType(ServiceTypeEnum.TWO.getServiceType()).serviceCode(rightsLuggageDoorToDoorCode).build();
        log.info("\u884c\u674e\u95e8\u5230\u95e8\u540c\u6b65:{}", (Object)JacksonUtil.bean2Json((Object)seviceChangeMq));
        try {
            this.rocketMQTemplate.send(Destination.builder().topic("SYNC_ORDER_AND_SERVICE").tag("SERVICE_LUGGAGE_DOOR_TO_DOOR").build(), (Object)JSON.toJSONString((Object)seviceChangeMq));
        }
        catch (Exception e) {
            log.error("\u884c\u674e\u95e8\u5230\u95e8\u540c\u6b65\u5f02\u5e38:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public void syncSpecialPassengerAsync(String rightsSpecialPassengerRecordCode) {
        SeviceChangeMq seviceChangeMq = SeviceChangeMq.builder().serviceType(ServiceTypeEnum.TWO.getServiceType()).serviceCode(rightsSpecialPassengerRecordCode).build();
        log.info("\u7279\u6b8a\u65c5\u5ba2\u8bb0\u5f55\u540c\u6b65:{}", (Object)JacksonUtil.bean2Json((Object)seviceChangeMq));
        try {
            this.rocketMQTemplate.send(Destination.builder().topic("SYNC_ORDER_AND_SERVICE").tag("SERVICE_SPECIAL_PASSENGER").build(), (Object)JSON.toJSONString((Object)seviceChangeMq));
        }
        catch (Exception e) {
            log.error("\u7279\u6b8a\u65c5\u5ba2\u8bb0\u5f55\u540c\u6b65\u5f02\u5e38:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public ResponseData<Boolean> syncBarrierFreeParkingSync(SeviceChangeMq seviceChangeMq) {
        RightsBarrierFreeParkingRecordPO barrierFreeParkingRecordPO = this.rightsBarrierFreeParkingRecordService.detailByCode(seviceChangeMq.getServiceCode());
        if (barrierFreeParkingRecordPO == null) {
            return ResponseUtil.fail((String)"\u65e0\u969c\u788d\u8f66\u4f4d\u9884\u7ea6\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        RightsServiceRecordAddRequestVO requestVO = new RightsServiceRecordAddRequestVO();
        requestVO.setMbrMembersCode(barrierFreeParkingRecordPO.getMbrMembersCode());
        requestVO.setMerchantNo(barrierFreeParkingRecordPO.getMerchantNo());
        requestVO.setServiceType(seviceChangeMq.getServiceType());
        requestVO.setServiceCode(seviceChangeMq.getServiceCode());
        requestVO.setReservationRecordNo(barrierFreeParkingRecordPO.getReservationRecordNo());
        requestVO.setAppointmentStatus(barrierFreeParkingRecordPO.getAppointmentStatus());
        requestVO.setAppointmentLocation(barrierFreeParkingRecordPO.getParkingLot());
        requestVO.setAppointmentTime(barrierFreeParkingRecordPO.getAppointmentTime());
        requestVO.setOptUserCode((String)ObjectUtils.defaultIfNull((Object)barrierFreeParkingRecordPO.getModifiedUserCode(), (Object)barrierFreeParkingRecordPO.getCreateUserCode()));
        requestVO.setOptUserName((String)ObjectUtils.defaultIfNull((Object)barrierFreeParkingRecordPO.getModifiedUserName(), (Object)barrierFreeParkingRecordPO.getCreateUserName()));
        return this.serviceRecordService.addOrUpdate(requestVO);
    }

    public ResponseData<Boolean> syncLuggageDoorToDoorSync(SeviceChangeMq seviceChangeMq) {
        RightsLuggageDoorToDoorPO rightsLuggageDoorToDoorPO = this.rightsLuggageDoorToDoorService.detailByCode(seviceChangeMq.getServiceCode());
        if (rightsLuggageDoorToDoorPO == null) {
            return ResponseUtil.fail((String)"\u884c\u674e\u95e8\u5230\u95e8\u9884\u7ea6\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        RightsServiceRecordAddRequestVO requestVO = new RightsServiceRecordAddRequestVO();
        requestVO.setMbrMembersCode(rightsLuggageDoorToDoorPO.getMbrMembersCode());
        requestVO.setMerchantNo(rightsLuggageDoorToDoorPO.getMerchantNo());
        requestVO.setServiceType(seviceChangeMq.getServiceType());
        requestVO.setServiceCode(seviceChangeMq.getServiceCode());
        requestVO.setReservationRecordNo(rightsLuggageDoorToDoorPO.getReservationRecordNo());
        requestVO.setAppointmentStatus(rightsLuggageDoorToDoorPO.getAppointmentStatus());
        requestVO.setAppointmentLocation(rightsLuggageDoorToDoorPO.getAppointmentLocation());
        requestVO.setAppointmentTime(rightsLuggageDoorToDoorPO.getAppointmentTime());
        requestVO.setOptUserCode((String)ObjectUtils.defaultIfNull((Object)rightsLuggageDoorToDoorPO.getModifiedUserCode(), (Object)rightsLuggageDoorToDoorPO.getCreateUserCode()));
        requestVO.setOptUserName((String)ObjectUtils.defaultIfNull((Object)rightsLuggageDoorToDoorPO.getModifiedUserName(), (Object)rightsLuggageDoorToDoorPO.getCreateUserName()));
        return this.serviceRecordService.addOrUpdate(requestVO);
    }

    public ResponseData<Boolean> syncSpecialPassengerSync(SeviceChangeMq seviceChangeMq) {
        RightsSpecialPassengerRecordPO specialPassengerRecordPO = this.rightsSpecialPassengerRecordService.detailByCode(seviceChangeMq.getServiceCode());
        if (specialPassengerRecordPO == null) {
            return ResponseUtil.fail((String)"\u7279\u6b8a\u65c5\u5ba2\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        RightsSpecialPassengerFlightPO rightsSpecialPassengerFlightPO = this.rightsSpecialPassengerFlightService.queryByRightsSpecialPassengerRecordCode(specialPassengerRecordPO.getRightsSpecialPassengerRecordCode());
        RightsServiceRecordAddRequestVO requestVO = new RightsServiceRecordAddRequestVO();
        requestVO.setMbrMembersCode(specialPassengerRecordPO.getMbrMembersCode());
        requestVO.setMerchantNo(specialPassengerRecordPO.getMerchantNo());
        requestVO.setServiceType(seviceChangeMq.getServiceType());
        requestVO.setServiceCode(seviceChangeMq.getServiceCode());
        requestVO.setReservationRecordNo(specialPassengerRecordPO.getAppointmentRecordNo());
        requestVO.setAppointmentStatus(specialPassengerRecordPO.getAppointmentStatus());
        requestVO.setAppointmentLocation(rightsSpecialPassengerFlightPO.getAppointmentLocation());
        requestVO.setAppointmentTime(specialPassengerRecordPO.getAppointmentTime());
        requestVO.setServiceTargetType(specialPassengerRecordPO.getServiceTargetType());
        requestVO.setOptUserCode((String)ObjectUtils.defaultIfNull((Object)specialPassengerRecordPO.getModifiedUserCode(), (Object)specialPassengerRecordPO.getCreateUserCode()));
        requestVO.setOptUserName((String)ObjectUtils.defaultIfNull((Object)specialPassengerRecordPO.getModifiedUserName(), (Object)specialPassengerRecordPO.getCreateUserName()));
        return this.serviceRecordService.addOrUpdate(requestVO);
    }

    public ServiceComponent(RocketMQTemplate rocketMQTemplate, ServiceRecordService serviceRecordService, IRightsSpecialPassengerRecordService rightsSpecialPassengerRecordService, IRightsSpecialPassengerFlightService rightsSpecialPassengerFlightService, IRightsLuggageDoorToDoorService rightsLuggageDoorToDoorService, IRightsBarrierFreeParkingRecordService rightsBarrierFreeParkingRecordService) {
        this.rocketMQTemplate = rocketMQTemplate;
        this.serviceRecordService = serviceRecordService;
        this.rightsSpecialPassengerRecordService = rightsSpecialPassengerRecordService;
        this.rightsSpecialPassengerFlightService = rightsSpecialPassengerFlightService;
        this.rightsLuggageDoorToDoorService = rightsLuggageDoorToDoorService;
        this.rightsBarrierFreeParkingRecordService = rightsBarrierFreeParkingRecordService;
    }
}

