/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.service.component;

import com.bizvane.basic.feign.feign.SerialNumberServiceFeign;
import com.bizvane.utils.exception.BizException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SerialNumberComponent {
    private static final Logger log = LoggerFactory.getLogger(SerialNumberComponent.class);
    private final SerialNumberServiceFeign serialNumberServiceFeign;

    private Long getSerialNumber(String serialNumberType, Integer retryCount) {
        Long serialNumber = null;
        for (int i = 0; i < retryCount && serialNumber == null; ++i) {
            try {
                serialNumber = (Long)this.serialNumberServiceFeign.generateIncrId(serialNumberType).getData();
                continue;
            }
            catch (Exception e) {
                log.info("\u751f\u6210\u4e1a\u52a1\u7f16\u53f7\u5931\u8d25,\u91cd\u8bd5\u6b21\u6570:{}", (Object)(i + 1));
            }
        }
        if (serialNumber == null) {
            throw new BizException("\u751f\u6210\u4e1a\u52a1\u7f16\u53f7\u5931\u8d25!");
        }
        return serialNumber;
    }

    private Long generateId(Integer retryCount) {
        Long serialNumber = null;
        for (int i = 0; i < retryCount && serialNumber == null; ++i) {
            try {
                serialNumber = (Long)this.serialNumberServiceFeign.generateId().getData();
                continue;
            }
            catch (Exception e) {
                log.info("\u751f\u6210\u4e1a\u52a1\u7f16\u53f7\u5931\u8d25,\u91cd\u8bd5\u6b21\u6570:{}", (Object)(i + 1));
            }
        }
        if (serialNumber == null) {
            throw new BizException("\u751f\u6210\u4e1a\u52a1\u7f16\u53f7\u5931\u8d25!");
        }
        return serialNumber;
    }

    private String getSerialNumberWithPrefixAndMaxLength(String serialNumberType, Integer retryCount, String prefix, Integer maxLength) {
        Long serialNumber = this.getSerialNumber(serialNumberType, retryCount);
        return prefix.concat(String.format("%0".concat(String.valueOf(maxLength)).concat("d"), serialNumber));
    }

    private String getSerialNumberWithPrefix(String serialNumberType, String prefix, Integer maxLength) {
        return this.getSerialNumberWithPrefixAndMaxLength(serialNumberType, Integer.valueOf(1), prefix, maxLength);
    }

    public Long generateId() {
        return this.generateId(Integer.valueOf(1));
    }

    public String getHotelNo() {
        LocalDateTime localDateTime = LocalDateTime.now();
        String format = localDateTime.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String prefix = "H";
        String serialNumberType = "HotelOrder".concat(prefix).concat(format);
        return this.getSerialNumberWithPrefix(serialNumberType, prefix.concat(format), Integer.valueOf(6));
    }

    public SerialNumberComponent(SerialNumberServiceFeign serialNumberServiceFeign) {
        this.serialNumberServiceFeign = serialNumberServiceFeign;
    }
}

