/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.controller.mobile;

import com.bizvane.rights.api.service.HotelMobileService;
import com.bizvane.rights.domain.util.AssertUtil;
import com.bizvane.rights.feign.HotelMobileFeign;
import com.bizvane.rights.vo.hotel.order.mobile.RightsHotelDetailRequestVO;
import com.bizvane.rights.vo.hotel.order.mobile.RightsHotelDetailResponseVO;
import com.bizvane.rights.vo.hotel.order.mobile.RightsHotelRoomTypeDetailRequestVO;
import com.bizvane.rights.vo.hotel.order.mobile.RightsHotelRoomTypeDetailResponseVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import java.util.List;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"hotelMobile"})
@Api(value="\u9152\u5e97mobile", tags={"\u9152\u5e97mobile"})
public class HotelMobileController
implements HotelMobileFeign {
    private final HotelMobileService hotelMobileService;

    public ResponseData<RightsHotelDetailResponseVO> detail(@RequestBody RightsHotelDetailRequestVO requestVO) {
        AssertUtil.notNull((String)requestVO.getRightsHotelCode(), (String)"rightsHotelCode\u4e0d\u80fd\u4e3a\u7a7a");
        return this.hotelMobileService.detail(requestVO);
    }

    public ResponseData<List<RightsHotelRoomTypeDetailResponseVO>> listRoomType(@RequestBody RightsHotelRoomTypeDetailRequestVO requestVO) {
        AssertUtil.notNull((String)requestVO.getRightsHotelCode(), (String)"rightsHotelCode\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((Object)requestVO.getStartDate(), (String)"startDate\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((Object)requestVO.getEndDate(), (String)"endDate\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.judge((Boolean)requestVO.getStartDate().isBefore(requestVO.getEndDate()), (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7b49\u4e8e\u7ed3\u675f\u65f6\u95f4");
        return this.hotelMobileService.listRoomType(requestVO);
    }

    public ResponseData<RightsHotelDetailResponseVO> detailWithRoomType(@RequestBody RightsHotelRoomTypeDetailRequestVO requestVO) {
        AssertUtil.notNull((String)requestVO.getRightsHotelCode(), (String)"rightsHotelCode\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((Object)requestVO.getStartDate(), (String)"startDate\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((Object)requestVO.getEndDate(), (String)"endDate\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.judge((Boolean)requestVO.getStartDate().isBefore(requestVO.getEndDate()), (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7b49\u4e8e\u7ed3\u675f\u65f6\u95f4");
        return this.hotelMobileService.detailWithRoomType(requestVO);
    }

    public HotelMobileController(HotelMobileService hotelMobileService) {
        this.hotelMobileService = hotelMobileService;
    }
}

