/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bizvane.rights.api.service.TransitBenefitsRecordService;
import com.bizvane.rights.api.service.impl.TransitBenefitsRecordServiceImpl;
import com.bizvane.rights.api.util.LocalDateUtils;
import com.bizvane.rights.domain.model.entity.RightsTransitBenefitsRecordPO;
import com.bizvane.rights.domain.service.IRightsTransitBenefitsRecordService;
import com.bizvane.rights.enums.TransitBenefitsLimitTypeEnum;
import com.bizvane.rights.vo.transit.benefits.TransitBenefitsDetailResponseVO;
import java.time.LocalDateTime;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TransitBenefitsRecordServiceImpl
implements TransitBenefitsRecordService {
    private static final Logger log = LoggerFactory.getLogger(TransitBenefitsRecordServiceImpl.class);
    private final IRightsTransitBenefitsRecordService rightsTransitBenefitsRecordService;

    public RightsTransitBenefitsRecordPO detailByFlightRecordCode(String mbrFlightRecordCode) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RightsTransitBenefitsRecordPO::getMbrFlightRecordCode, (Object)mbrFlightRecordCode)).last("limit 1");
        return (RightsTransitBenefitsRecordPO)this.rightsTransitBenefitsRecordService.getOne((Wrapper)queryWrapper);
    }

    public long countByFlightRecordCode(String mbrFlightRecordCode) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RightsTransitBenefitsRecordPO::getMbrFlightRecordCode, (Object)mbrFlightRecordCode)).last("limit 1");
        return this.rightsTransitBenefitsRecordService.count((Wrapper)queryWrapper);
    }

    public boolean canReceiveByMemberCodeAndCondition(String memberCode, TransitBenefitsDetailResponseVO transitBenefitsDetailResponseVO) {
        boolean canReceive;
        if (transitBenefitsDetailResponseVO == null || transitBenefitsDetailResponseVO.getRightsTransitBenefitsCode() == null) {
            log.info("\u672a\u914d\u7f6e\u4e2d\u8f6c\u6743\u76ca\u4fe1\u606f!");
            return false;
        }
        if (transitBenefitsDetailResponseVO.getClaimMethod() != 1) {
            log.info("\u6743\u76ca\u9886\u53d6\u65b9\u5f0f \u4e0d\u4e3a\u6743\u76ca\u9886\u53d6");
            return false;
        }
        if (BooleanUtils.isNotTrue((Boolean)transitBenefitsDetailResponseVO.getStatus())) {
            log.info("\u4e2d\u8f6c\u6743\u76ca\u672a\u5f00\u542f");
            return false;
        }
        TransitBenefitsLimitTypeEnum limitTypeEnum = TransitBenefitsLimitTypeEnum.getByType((Integer)transitBenefitsDetailResponseVO.getLimitType());
        if (limitTypeEnum == null) {
            log.info("\u83b7\u53d6\u89c4\u5219\u9650\u5236\u7c7b\u578b\u5931\u8d25");
            return false;
        }
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RightsTransitBenefitsRecordPO::getMemberCode, (Object)memberCode)).eq(RightsTransitBenefitsRecordPO::getRightsTransitBenefitsCode, (Object)transitBenefitsDetailResponseVO.getRightsTransitBenefitsCode());
        LocalDateTime start = this.getLocalDateTime(limitTypeEnum);
        if (start == null) {
            log.info("\u83b7\u53d6\u89c4\u5219\u9650\u5236\u5f00\u59cb\u65f6\u95f4\u5931\u8d25");
            return false;
        }
        queryWrapper.gt(RightsTransitBenefitsRecordPO::getCreateDate, (Object)start);
        long count = this.rightsTransitBenefitsRecordService.count((Wrapper)queryWrapper);
        boolean bl = canReceive = count < (long)((Integer)ObjectUtils.defaultIfNull((Object)transitBenefitsDetailResponseVO.getLimitCount(), (Object)0)).intValue();
        if (!canReceive) {
            log.info("\u4e2d\u8f6c\u6743\u76ca\u9886\u53d6\u6b21\u6570\u5df2\u8fbe\u4e0a\u9650");
        }
        return canReceive;
    }

    private LocalDateTime getLocalDateTime(TransitBenefitsLimitTypeEnum limitTypeEnum) {
        LocalDateTime now = LocalDateTime.now();
        switch (1.$SwitchMap$com$bizvane$rights$enums$TransitBenefitsLimitTypeEnum[limitTypeEnum.ordinal()]) {
            case 1: {
                return LocalDateUtils.startOfDay((LocalDateTime)now);
            }
            case 2: {
                return LocalDateUtils.startOfWeek((LocalDateTime)now);
            }
            case 3: {
                return LocalDateUtils.startOfMonth((LocalDateTime)now);
            }
            case 4: {
                return LocalDateUtils.startOfYear((LocalDateTime)now);
            }
        }
        return null;
    }

    public TransitBenefitsRecordServiceImpl(IRightsTransitBenefitsRecordService rightsTransitBenefitsRecordService) {
        this.rightsTransitBenefitsRecordService = rightsTransitBenefitsRecordService;
    }
}

