/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.service.impl;

import com.alibaba.fastjson.JSON;
import com.bizvane.members.feign.model.bo.CouponEntityAddRequestParam;
import com.bizvane.members.feign.model.bo.MbrFlightRecordFocusReq;
import com.bizvane.members.feign.model.vo.CouponDefinitionVO;
import com.bizvane.members.feign.model.vo.FlightRecordVO;
import com.bizvane.members.feign.service.CouponFeign;
import com.bizvane.members.feign.service.FlightRecordFeign;
import com.bizvane.rights.api.service.TransitBenefitsMobileService;
import com.bizvane.rights.api.service.TransitBenefitsRecordService;
import com.bizvane.rights.api.service.TransitBenefitsService;
import com.bizvane.rights.api.util.UID;
import com.bizvane.rights.domain.model.entity.RightsTransitBenefitsRecordPO;
import com.bizvane.rights.domain.service.IRightsTransitBenefitsRecordService;
import com.bizvane.rights.domain.util.ResponseUtil;
import com.bizvane.rights.enums.TransitBenefitsClaimStatusEnum;
import com.bizvane.rights.enums.TransitBenefitsRightsTypeEnum;
import com.bizvane.rights.enums.TransitTypeEnum;
import com.bizvane.rights.vo.transit.benefits.TransitBenefitsDetailResponseVO;
import com.bizvane.rights.vo.transit.benefits.mobile.TransitBenefitsMobileQueryRequestVO;
import com.bizvane.rights.vo.transit.benefits.mobile.TransitBenefitsMobileQueryResponseVO;
import com.bizvane.utils.enumutils.CouponSendTypeEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TransitBenefitsMobileServiceImpl
implements TransitBenefitsMobileService {
    private static final Logger log = LoggerFactory.getLogger(TransitBenefitsMobileServiceImpl.class);
    private final TransitBenefitsService transitBenefitsService;
    private final FlightRecordFeign flightRecordFeign;
    private final TransitBenefitsRecordService transitBenefitsRecordService;
    private final CouponFeign couponFeign;
    private final IRightsTransitBenefitsRecordService rightsTransitBenefitsRecordService;

    public ResponseData<String> matchArriveFlights(TransitBenefitsMobileQueryRequestVO requestVO) {
        MbrFlightRecordFocusReq mbrFlightRecordFocusReq = new MbrFlightRecordFocusReq();
        mbrFlightRecordFocusReq.setBasicFlightCode(requestVO.getFirstBasicFlightCode());
        mbrFlightRecordFocusReq.setIsTransit(requestVO.getTransitType().toString());
        mbrFlightRecordFocusReq.setTransitBasicFlightCode(requestVO.getSecondBasicFlightCode());
        mbrFlightRecordFocusReq.setMbrMembersCode(requestVO.getMemberCode());
        return this.flightRecordFeign.saveApplet(mbrFlightRecordFocusReq);
    }

    public ResponseData<TransitBenefitsMobileQueryResponseVO> getTransferBenefits(TransitBenefitsMobileQueryRequestVO requestVO) {
        long count;
        ResponseData flightRecordVOResponseData = this.flightRecordFeign.detail(requestVO.getMbrFlightRecordCode());
        if (ResponseUtil.isFail((ResponseData)flightRecordVOResponseData)) {
            return ResponseUtil.copy((ResponseData)flightRecordVOResponseData);
        }
        FlightRecordVO flightRecordVO = (FlightRecordVO)flightRecordVOResponseData.getData();
        if (flightRecordVO == null) {
            return ResponseUtil.fail((String)"\u884c\u7a0b\u4e0d\u5b58\u5728");
        }
        log.info("flightRecordVO:{}", (Object)JSON.toJSONString((Object)flightRecordVO));
        TransitBenefitsRightsTypeEnum transitBenefitsRightsTypeEnum = TransitBenefitsRightsTypeEnum.typeOfMbrTransitType((Integer)flightRecordVO.getTransitType());
        TransitBenefitsMobileQueryResponseVO responseVO = new TransitBenefitsMobileQueryResponseVO();
        responseVO.setFlightRecordVO(flightRecordVO);
        TransitBenefitsDetailResponseVO transitBenefitsDetailResponseVO = this.transitBenefitsService.detailByRightsType(transitBenefitsRightsTypeEnum.getType());
        boolean canReceive = this.transitBenefitsRecordService.canReceiveByMemberCodeAndCondition(requestVO.getMemberCode(), transitBenefitsDetailResponseVO);
        if (canReceive) {
            responseVO.setTransitBenefitsDetail(transitBenefitsDetailResponseVO);
        }
        String baggageReclaims = flightRecordVO.getBaggageReclaims();
        ArrayList<String> baggageReclaimList = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)baggageReclaims)) {
            baggageReclaimList.addAll(Arrays.asList(baggageReclaims.split(",")));
        }
        responseVO.setBaggageReclaimList(baggageReclaimList);
        if (transitBenefitsRightsTypeEnum.getTransitTypeEnum() == TransitTypeEnum.TRANSFER) {
            responseVO.setTransitGuideVO(this.transitBenefitsService.queryTransitGuide());
        }
        responseVO.setReceived(Boolean.valueOf((count = this.transitBenefitsRecordService.countByFlightRecordCode(requestVO.getMbrFlightRecordCode())) > 0L));
        return ResponseUtil.success((Object)responseVO);
    }

    public ResponseData<Boolean> benefitsClaim(TransitBenefitsMobileQueryRequestVO requestVO) {
        ResponseData flightRecordVOResponseData = this.flightRecordFeign.detail(requestVO.getMbrFlightRecordCode());
        if (ResponseUtil.isFail((ResponseData)flightRecordVOResponseData)) {
            return ResponseUtil.copy((ResponseData)flightRecordVOResponseData);
        }
        FlightRecordVO flightRecordVO = (FlightRecordVO)flightRecordVOResponseData.getData();
        if (flightRecordVO == null) {
            return ResponseUtil.fail((String)"\u884c\u7a0b\u4e0d\u5b58\u5728");
        }
        log.info("flightRecordVO:{}", (Object)JSON.toJSONString((Object)flightRecordVO));
        if (ObjectUtils.notEqual((Object)flightRecordVO.getMbrMembersCode(), (Object)requestVO.getMemberCode())) {
            return ResponseUtil.fail((String)"\u975e\u672c\u4eba\u884c\u7a0b");
        }
        long count = this.transitBenefitsRecordService.countByFlightRecordCode(requestVO.getMbrFlightRecordCode());
        if (count > 0L) {
            return ResponseUtil.fail((String)"\u6743\u76ca\u5df2\u9886\u53d6");
        }
        TransitBenefitsRightsTypeEnum transitBenefitsRightsTypeEnum = TransitBenefitsRightsTypeEnum.typeOfMbrTransitType((Integer)flightRecordVO.getTransitType());
        TransitBenefitsDetailResponseVO transitBenefitsDetailResponseVO = this.transitBenefitsService.detailByRightsType(transitBenefitsRightsTypeEnum.getType());
        if (!BooleanUtils.isTrue((Boolean)transitBenefitsDetailResponseVO.getStatus())) {
            return ResponseUtil.fail((String)"\u6743\u76ca\u4e0d\u5b58\u5728\u6216\u6743\u76ca\u5df2\u5173\u95ed");
        }
        List couponDefinitionVOList = transitBenefitsDetailResponseVO.getCouponDefinitionVOList();
        if (CollectionUtils.isEmpty((Collection)couponDefinitionVOList)) {
            return ResponseUtil.fail((String)"\u5f53\u524d\u6743\u76ca\u5217\u8868\u4e3a\u7a7a");
        }
        RightsTransitBenefitsRecordPO rightsTransitBenefitsRecordPOAdd = new RightsTransitBenefitsRecordPO();
        rightsTransitBenefitsRecordPOAdd.setRightsTransitBenefitsRecordCode(UID.getUid());
        rightsTransitBenefitsRecordPOAdd.setMbrFlightRecordCode(flightRecordVO.getMbrFlightRecordCode());
        rightsTransitBenefitsRecordPOAdd.setRightsTransitBenefitsCode(transitBenefitsDetailResponseVO.getRightsTransitBenefitsCode());
        rightsTransitBenefitsRecordPOAdd.setMemberCode(requestVO.getMemberCode());
        rightsTransitBenefitsRecordPOAdd.setClaimStatus(TransitBenefitsClaimStatusEnum.CLAIMING.getType());
        ArrayList<CouponEntityAddRequestParam.CouponEntityAddDetailRequestParam> couponEntityAddDetailRequestParamList = new ArrayList<CouponEntityAddRequestParam.CouponEntityAddDetailRequestParam>();
        for (int i = 0; i < couponDefinitionVOList.size(); ++i) {
            CouponDefinitionVO couponDefinitionVO = (CouponDefinitionVO)couponDefinitionVOList.get(i);
            CouponEntityAddRequestParam.CouponEntityAddDetailRequestParam couponEntityAddDetailRequestParam = new CouponEntityAddRequestParam.CouponEntityAddDetailRequestParam();
            couponEntityAddDetailRequestParam.setCouponDefinitionCode(couponDefinitionVO.getCouponDefinitionCode());
            couponEntityAddDetailRequestParam.setSendBusinessName(transitBenefitsRightsTypeEnum.getDesc());
            couponEntityAddDetailRequestParam.setSendBusinessCode(flightRecordVO.getMbrFlightRecordCode());
            couponEntityAddDetailRequestParam.setSendBusinessCode2(transitBenefitsRightsTypeEnum.getTransitTypeEnum().getType().toString());
            couponEntityAddDetailRequestParam.setSendBusinessCode3(String.valueOf(i));
            couponEntityAddDetailRequestParamList.add(couponEntityAddDetailRequestParam);
        }
        CouponEntityAddRequestParam couponEntityAddRequestParam = CouponEntityAddRequestParam.builder().couponDefinitionList(couponEntityAddDetailRequestParamList).mbrMembersCode(requestVO.getMemberCode()).sendType(CouponSendTypeEnum.TRANSFER_BENEFITS.getType()).build();
        ResponseData couponSendResponseData = this.couponFeign.send(couponEntityAddRequestParam);
        if (ResponseUtil.isSuccess((ResponseData)couponSendResponseData)) {
            rightsTransitBenefitsRecordPOAdd.setClaimStatus(TransitBenefitsClaimStatusEnum.CLAIMED.getType());
        } else {
            rightsTransitBenefitsRecordPOAdd.setClaimStatus(TransitBenefitsClaimStatusEnum.CLAIM_FAILED.getType());
        }
        boolean save = this.rightsTransitBenefitsRecordService.save((Object)rightsTransitBenefitsRecordPOAdd);
        return ResponseUtil.success((Object)save);
    }

    public TransitBenefitsMobileServiceImpl(TransitBenefitsService transitBenefitsService, FlightRecordFeign flightRecordFeign, TransitBenefitsRecordService transitBenefitsRecordService, CouponFeign couponFeign, IRightsTransitBenefitsRecordService rightsTransitBenefitsRecordService) {
        this.transitBenefitsService = transitBenefitsService;
        this.flightRecordFeign = flightRecordFeign;
        this.transitBenefitsRecordService = transitBenefitsRecordService;
        this.couponFeign = couponFeign;
        this.rightsTransitBenefitsRecordService = rightsTransitBenefitsRecordService;
    }
}

