/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.content.feign.api.FileUploadFeign;
import com.bizvane.content.feign.api.TraceFeign;
import com.bizvane.content.feign.enums.trace.TraceTypeEnum;
import com.bizvane.content.feign.vo.fileupload.FIleUploadResponseVO;
import com.bizvane.content.feign.vo.fileupload.FileUploadRequestVO;
import com.bizvane.content.feign.vo.trace.TraceAddWithQRCodeRequestVO;
import com.bizvane.content.feign.vo.trace.TraceAddWithQRCodeResponseVO;
import com.bizvane.members.feign.model.bo.BasicFlightQueryReq;
import com.bizvane.members.feign.model.bo.CouponEntityAvailableListReq;
import com.bizvane.members.feign.model.vo.BasicFlightQueryRsp;
import com.bizvane.members.feign.model.vo.CouponEntityListResponseParam;
import com.bizvane.members.feign.model.vo.MbrAddressVO;
import com.bizvane.members.feign.service.BasicFlightFeign;
import com.bizvane.members.feign.service.FlightRecordFeign;
import com.bizvane.members.feign.service.MbrAddressFeign;
import com.bizvane.payment.feign.api.ApiWechatPayFeign;
import com.bizvane.payment.feign.vo.req.PrepareOrderReqVO;
import com.bizvane.payment.feign.vo.req.RefundOrderReqVO;
import com.bizvane.payment.feign.vo.resp.PrepayOrderRespVO;
import com.bizvane.rights.api.service.component.CouponComponent;
import com.bizvane.rights.api.service.component.PaymentComponent;
import com.bizvane.rights.api.util.UID;
import com.bizvane.rights.domain.consts.StewardOrderConst;
import com.bizvane.rights.domain.enums.StewardAdditionalServerEnum;
import com.bizvane.rights.domain.enums.StewardOrderStatusEnum;
import com.bizvane.rights.domain.model.entity.StewardOrderPO;
import com.bizvane.rights.domain.model.entity.StewardOrderServicePO;
import com.bizvane.rights.domain.model.entity.StewardServiceDescriptionPO;
import com.bizvane.rights.domain.model.entity.StewardServicePO;
import com.bizvane.rights.domain.service.impl.StewardOrderServiceImpl;
import com.bizvane.rights.domain.service.impl.StewardOrderServiceServiceImpl;
import com.bizvane.rights.domain.service.impl.StewardServiceDescriptionServiceImpl;
import com.bizvane.rights.domain.service.impl.StewardServiceServiceImpl;
import com.bizvane.rights.domain.util.AssertUtil;
import com.bizvane.rights.domain.util.ResponseUtil;
import com.bizvane.rights.vo.steward.StewardOrderCancelReq;
import com.bizvane.rights.vo.steward.StewardOrderConfirmAdditionalCostMobileReqVo;
import com.bizvane.rights.vo.steward.StewardOrderDetailMobileReqVo;
import com.bizvane.rights.vo.steward.StewardOrderMobileRespVO;
import com.bizvane.rights.vo.steward.StewardOrderPayReqVo;
import com.bizvane.rights.vo.steward.StewardOrderQueryMobileReqVo;
import com.bizvane.rights.vo.steward.StewardOrderReqRespVO;
import com.bizvane.rights.vo.steward.StewardPayForOrderMobileReqVO;
import com.bizvane.rights.vo.steward.StewardPaymentRespVO;
import com.bizvane.rights.vo.steward.StewardServiceDescriptionMobileRespVo;
import com.bizvane.rights.vo.steward.StewardServiceMobileCouponRequestVO;
import com.bizvane.rights.vo.steward.StewardServiceMobileReqVO;
import com.bizvane.rights.vo.steward.StewardServiceMobileRespVO;
import com.bizvane.rights.vo.steward.StewardServiceOrderDetailMobileRespVO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StewardMobileService {
    private final StewardOrderServiceImpl stewardOrderService;
    private final StewardServiceDescriptionServiceImpl stewardServiceDescriptionService;
    private final StewardServiceServiceImpl stewardServiceService;
    private final FlightRecordFeign flightRecordfeign;
    private final FileUploadFeign fileUploadFeign;
    private final BasicFlightFeign basicFlightFeign;
    private final MbrAddressFeign mbrAddressFeign;
    @Value(value="${wechat.merchantId}")
    private String paymentMerchantId;
    private final PaymentComponent paymentComponent;
    private final TraceFeign traceFeign;
    private final StewardOrderServiceServiceImpl stewardOrderServiceRel;
    ApiWechatPayFeign apiWechatPayFeign;
    private final CouponComponent couponComponent;
    private final StewardOrderConst stewardOrderConst;

    public ResponseData<StewardPaymentRespVO> payForOrder(StewardPayForOrderMobileReqVO stewardOrderMobileReqVO) {
        String[] serviceCodes;
        StewardOrderPO stewardOrderPO = new StewardOrderPO();
        BasicFlightQueryReq basicFlightQueryReq = new BasicFlightQueryReq();
        basicFlightQueryReq.setFlightIdentity(stewardOrderMobileReqVO.getFlightIdentity());
        basicFlightQueryReq.setFlightDate(stewardOrderMobileReqVO.getFlightScheduledDate());
        ResponseData list = this.basicFlightFeign.list(basicFlightQueryReq);
        BeanUtil.copyProperties((Object)stewardOrderMobileReqVO, (Object)stewardOrderPO, (CopyOptions)CopyOptions.create().ignoreNullValue());
        ResponseData detail = this.mbrAddressFeign.detail(stewardOrderMobileReqVO.getAddressCode());
        MbrAddressVO data = (MbrAddressVO)detail.getData();
        stewardOrderPO.setStewardOrderCode(IdUtil.fastSimpleUUID());
        stewardOrderPO.setCreateDate(LocalDateTime.now());
        stewardOrderPO.setStatus(Integer.valueOf(0));
        stewardOrderPO.setBasicFlightCode(((BasicFlightQueryRsp)((List)list.getData()).get(0)).getBasicFlightCode());
        stewardOrderPO.setCouponCode(stewardOrderMobileReqVO.getCouponCode());
        stewardOrderPO.setAddressCode(stewardOrderMobileReqVO.getAddressCode());
        stewardOrderPO.setOrderAddress(data.getAddress());
        stewardOrderPO.setOrderDistrict(data.getCounty());
        stewardOrderPO.setOrderCity(data.getCity());
        stewardOrderPO.setOrderProvince(data.getProvince());
        stewardOrderPO.setOrderMobileEncrypt(data.getPhoneEncrypt());
        stewardOrderPO.setOrderMobile(data.getPhone());
        stewardOrderPO.setOrderName(data.getName());
        Boolean result = this.stewardOrderService.save((Object)stewardOrderPO);
        for (String serviceCode : serviceCodes = stewardOrderMobileReqVO.getStewardServiceCode().split(",")) {
            LambdaQueryWrapper stewardServicePOLambdaQueryWrapper = new LambdaQueryWrapper();
            stewardServicePOLambdaQueryWrapper.eq(StewardServicePO::getStewardServiceCode, (Object)serviceCode);
            StewardServicePO servicePO = (StewardServicePO)this.stewardServiceService.getOne((Wrapper)stewardServicePOLambdaQueryWrapper, false);
            if (servicePO == null) {
                return ResponseUtil.fail((String)"\u670d\u52a1\u4e0d\u5b58\u5728");
            }
            StewardOrderServicePO stewardOrderServicePO = new StewardOrderServicePO();
            stewardOrderServicePO.setStewardOrderCode(stewardOrderPO.getStewardOrderCode());
            stewardOrderServicePO.setStewardServiceCode(serviceCode);
            stewardOrderServicePO.setCreateDate(LocalDateTime.now());
            stewardOrderServicePO.setStewardOrderServiceCode(IdUtil.fastSimpleUUID());
            stewardOrderServicePO.setName(servicePO.getName());
            stewardOrderServicePO.setMainImageUrl(servicePO.getMainImageUrl());
            stewardOrderServicePO.setOriginalPrice(servicePO.getOriginalPrice());
            stewardOrderServicePO.setPreferentialPrice(servicePO.getPreferentialPrice());
            stewardOrderServicePO.setContent(servicePO.getContent());
            stewardOrderServicePO.setServiceType(servicePO.getServiceType());
            stewardOrderServicePO.setServiceNo(servicePO.getServiceNo());
            stewardOrderServicePO.setAirportCode(servicePO.getAirportCode());
            stewardOrderServicePO.setValid(Boolean.valueOf(true));
            this.stewardOrderServiceRel.save((Object)stewardOrderServicePO);
        }
        StewardPaymentRespVO stewardPaymentRespVO = new StewardPaymentRespVO();
        PrepareOrderReqVO prepareOrderReqVO = new PrepareOrderReqVO();
        prepareOrderReqVO.setPaymentMerchantConfigCode(this.paymentMerchantId);
        prepareOrderReqVO.setOutTradeNo(stewardOrderPO.getStewardOrderCode());
        prepareOrderReqVO.setAmount(stewardOrderPO.getReallyPrice());
        prepareOrderReqVO.setOpenid(stewardOrderMobileReqVO.getMbrOpenid());
        prepareOrderReqVO.setDescription("\u7ba1\u5bb6\u670d\u52a1\u8ba2\u5355\u652f\u4ed8");
        ResponseData responseData = this.apiWechatPayFeign.prepareOrder(prepareOrderReqVO);
        stewardPaymentRespVO.setStewardOrderCode(stewardOrderPO.getStewardOrderCode());
        stewardPaymentRespVO.setAppId(((PrepayOrderRespVO)responseData.getData()).getAppId());
        stewardPaymentRespVO.setTimestamp(((PrepayOrderRespVO)responseData.getData()).getTimeStamp());
        stewardPaymentRespVO.setNonceStr(((PrepayOrderRespVO)responseData.getData()).getNonceStr());
        stewardPaymentRespVO.setPackageVal(((PrepayOrderRespVO)responseData.getData()).getPackageVal());
        stewardPaymentRespVO.setSignType(((PrepayOrderRespVO)responseData.getData()).getSignType());
        stewardPaymentRespVO.setPaySign(((PrepayOrderRespVO)responseData.getData()).getPaySign());
        stewardPaymentRespVO.setPayableAmount(stewardOrderPO.getReallyPrice());
        return ResponseUtil.success((Object)stewardPaymentRespVO);
    }

    public ResponseData<StewardOrderMobileRespVO> findOrderDetailByOrderCode(StewardOrderDetailMobileReqVo stewardOrderMobileReqVO) {
        List list = this.stewardOrderServiceRel.list((Wrapper)new LambdaQueryWrapper().eq(StewardOrderServicePO::getStewardOrderCode, (Object)stewardOrderMobileReqVO.getStewardOrderCode()));
        ArrayList services = new ArrayList();
        list.forEach(item -> {
            StewardServiceOrderDetailMobileRespVO stewardServiceReqRespVO = new StewardServiceOrderDetailMobileRespVO();
            BeanUtil.copyProperties((Object)item, (Object)stewardServiceReqRespVO, (CopyOptions)CopyOptions.create().ignoreNullValue());
            services.add(stewardServiceReqRespVO);
        });
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(StewardOrderPO::getStewardOrderCode, (Object)stewardOrderMobileReqVO.getStewardOrderCode())).eq(StewardOrderPO::getMbrMembersCode, (Object)stewardOrderMobileReqVO.getMbrMembersCode())).last("limit 1");
        StewardOrderPO one = (StewardOrderPO)this.stewardOrderService.getOne((Wrapper)queryWrapper);
        StewardOrderMobileRespVO stewardOrderMobileRespVO = new StewardOrderMobileRespVO();
        BeanUtil.copyProperties((Object)one, (Object)stewardOrderMobileRespVO, (CopyOptions)CopyOptions.create().ignoreNullValue());
        stewardOrderMobileRespVO.setServices(services);
        stewardOrderMobileRespVO.setOrderQRCode(this.generateQRCode(stewardOrderMobileReqVO.getStewardOrderCode()));
        return ResponseUtil.success((Object)stewardOrderMobileRespVO);
    }

    public String generateQRCode(String stewardOrderCode) {
        JSONObject json = new JSONObject();
        json.put("stewardOrderCode", (Object)stewardOrderCode);
        String fileName = "qrcode.png";
        int width = 300;
        int height = 300;
        String charset = "UTF-8";
        HashMap<EncodeHintType, ErrorCorrectionLevel> hints = new HashMap<EncodeHintType, ErrorCorrectionLevel>();
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.L);
        String fileUrl = "";
        try {
            BitMatrix matrix = new QRCodeWriter().encode(json.toJSONString(), BarcodeFormat.QR_CODE, width, height, hints);
            Path outputPath = FileSystems.getDefault().getPath(fileName, new String[0]);
            MatrixToImageWriter.writeToPath((BitMatrix)matrix, (String)"PNG", (Path)outputPath);
            FileUploadRequestVO fileUploadRequestVO = new FileUploadRequestVO();
            byte[] fileContent = Files.readAllBytes(outputPath);
            fileUploadRequestVO.setBytes(fileContent);
            fileUploadRequestVO.setFileName(fileName);
            fileUploadRequestVO.setFileType(Integer.valueOf(1));
            ResponseData responseData = this.fileUploadFeign.simplePost(fileUploadRequestVO);
            fileUrl = ((FIleUploadResponseVO)responseData.getData()).getFileUrl();
        }
        catch (WriterException | IOException e) {
            System.err.println("Error generating QR Code: " + e.getMessage());
        }
        return fileUrl;
    }

    public ResponseData<StewardServiceDescriptionMobileRespVo> findStewardServiceDescription() {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.last("limit 1");
        StewardServiceDescriptionPO one = (StewardServiceDescriptionPO)this.stewardServiceDescriptionService.getOne((Wrapper)wrapper);
        StewardServiceDescriptionMobileRespVo stewardServiceDescriptionMobileRespVo = this.buildStewardServiceDescriptionMobileRespVo(one);
        return ResponseUtil.success((Object)stewardServiceDescriptionMobileRespVo);
    }

    private StewardServiceDescriptionMobileRespVo buildStewardServiceDescriptionMobileRespVo(StewardServiceDescriptionPO po) {
        StewardServiceDescriptionMobileRespVo respVo = new StewardServiceDescriptionMobileRespVo();
        BeanUtil.copyProperties((Object)po, (Object)respVo, (String[])new String[0]);
        return respVo;
    }

    public ResponseData<List<StewardServiceMobileRespVO>> findServiceByFlightIdentityAndDate(StewardServiceMobileReqVO reqVO) {
        BasicFlightQueryReq basicFlightQueryReq = new BasicFlightQueryReq();
        basicFlightQueryReq.setFlightIdentity(reqVO.getFlightIdentity());
        basicFlightQueryReq.setFlightDate(reqVO.getFlightScheduledDate());
        ResponseData list = this.basicFlightFeign.list(basicFlightQueryReq);
        List data = Optional.ofNullable(list.getData()).orElse(Collections.emptyList());
        if (data.isEmpty()) {
            return new ResponseData(Collections.emptyList());
        }
        String iataOriginAirport = ((BasicFlightQueryRsp)data.get(0)).getIataOriginAirport();
        String destinationAirport = ((BasicFlightQueryRsp)data.get(0)).getDestinationAirport();
        String flightDirection = ((BasicFlightQueryRsp)data.get(0)).getFlightDirection();
        String airportCode = null;
        Integer serviceTypeFilter = null;
        switch (flightDirection) {
            case "A": {
                airportCode = destinationAirport;
                serviceTypeFilter = 1;
                break;
            }
            case "D": {
                airportCode = iataOriginAirport;
                serviceTypeFilter = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid flight direction: " + flightDirection);
            }
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(StewardServicePO::getAirportCode, (Object)airportCode)).eq(StewardServicePO::getServiceType, (Object)serviceTypeFilter);
        List stewardServicePOList = this.stewardServiceService.list((Wrapper)wrapper);
        List collect = stewardServicePOList.stream().map(po -> this.buildStewardServiceMobileRespVO(po)).collect(Collectors.toList());
        return new ResponseData(collect);
    }

    private StewardServiceMobileRespVO buildStewardServiceMobileRespVO(StewardServicePO po) {
        StewardServiceMobileRespVO respVo = new StewardServiceMobileRespVO();
        BeanUtil.copyProperties((Object)po, (Object)respVo, (String[])new String[0]);
        return respVo;
    }

    public ResponseData<PageInfo<StewardOrderReqRespVO>> findOrderList(StewardOrderQueryMobileReqVo stewardOrderVO) {
        Page page = new Page((long)stewardOrderVO.getPageNum().intValue(), (long)stewardOrderVO.getPageSize().intValue());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (stewardOrderVO.getStatus() != null) {
            wrapper.eq(StewardOrderPO::getStatus, (Object)stewardOrderVO.getStatus());
        }
        wrapper.eq(StewardOrderPO::getValid, (Object)Boolean.TRUE);
        Page stewardOrderPOPage = (Page)this.stewardOrderService.page((IPage)page, (Wrapper)wrapper);
        List stewardOrderReqRespVOList = stewardOrderPOPage.getRecords().stream().map(po -> {
            StewardOrderReqRespVO stewardOrderReqRespVO = this.buildStewardOrderReqRespVO(po);
            return stewardOrderReqRespVO;
        }).collect(Collectors.toList());
        PageInfo pageInfo = new PageInfo(Long.valueOf(stewardOrderPOPage.getCurrent()).intValue(), Long.valueOf(stewardOrderPOPage.getSize()).intValue(), stewardOrderPOPage.getTotal(), stewardOrderReqRespVOList);
        return ResponseUtil.success((Object)pageInfo);
    }

    private StewardOrderReqRespVO buildStewardOrderReqRespVO(StewardOrderPO po) {
        StewardOrderReqRespVO respVo = new StewardOrderReqRespVO();
        BeanUtil.copyProperties((Object)po, (Object)respVo, (String[])new String[0]);
        return respVo;
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<Boolean> cancel(StewardOrderCancelReq reqVO) {
        StewardOrderPO stewardOrderPO = this.stewardOrderService.stewardOrderByCode(reqVO.getStewardOrderCode());
        if (stewardOrderPO == null) {
            return ResponseUtil.of((SysResponseEnum)SysResponseEnum.RIGHTS_STEWARD_ORDER_NOT_EXISTS);
        }
        if (ObjectUtils.notEqual((Object)stewardOrderPO.getMbrMembersCode(), (Object)reqVO.getMbrMembersCode())) {
            return ResponseUtil.of((SysResponseEnum)SysResponseEnum.RIGHTS_HOTEL_ORDER_MEMBER_NOT_MATCH);
        }
        if (!Arrays.asList(StewardOrderStatusEnum.TO_BE_CONFIRMED.getOrderStatus(), StewardOrderStatusEnum.CONFIRMED.getOrderStatus()).contains(stewardOrderPO.getStatus())) {
            return ResponseUtil.of((SysResponseEnum)SysResponseEnum.RIGHTS_HOTEL_ORDER_STATUS_NO_MATCH);
        }
        return this.wechatCancel(stewardOrderPO);
    }

    private ResponseData<Boolean> wechatCancel(StewardOrderPO stewardOrderPO) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(StewardOrderPO::getStatus, (Object)StewardOrderStatusEnum.CANCELLED.getOrderStatus())).set(StewardOrderPO::getCancelType, (Object)2)).set(StewardOrderPO::getCancellationTime, (Object)LocalDateTime.now())).eq(StewardOrderPO::getStewardOrderCode, (Object)stewardOrderPO.getStewardOrderCode())).in(StewardOrderPO::getStatus, Arrays.asList(StewardOrderStatusEnum.TO_BE_CONFIRMED.getOrderStatus()));
        boolean update = this.stewardOrderService.update((Wrapper)updateWrapper);
        if (update) {
            RefundOrderReqVO refundOrderReqVO = new RefundOrderReqVO();
            refundOrderReqVO.setOutTradeNo(stewardOrderPO.getOrderNo());
            refundOrderReqVO.setRefundAmount(stewardOrderPO.getReallyPrice());
            refundOrderReqVO.setOrderAmount(stewardOrderPO.getReallyPrice());
            refundOrderReqVO.setOutRefundNo(String.format("R%s", refundOrderReqVO.getOutTradeNo()));
            ResponseData responseData = this.paymentComponent.refundOrder(refundOrderReqVO);
            AssertUtil.judge((Boolean)ResponseUtil.isSuccess((ResponseData)responseData), (String)String.format("\u673a\u573a\u7ba1\u5bb6\u8ba2\u5355:%s\u53d1\u8d77\u9000\u6b3e\u5931\u8d25", stewardOrderPO.getOrderNo()));
        }
        return ResponseUtil.success((Object)update);
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<Boolean> confirmAdditionalCost(StewardOrderConfirmAdditionalCostMobileReqVo stewardOrderMobileReqVO) {
        StewardOrderPO stewardOrderPO = this.stewardOrderService.stewardOrderByCode(stewardOrderMobileReqVO.getStewardOrderCode());
        if (null == stewardOrderPO) {
            return ResponseUtil.fail((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (stewardOrderPO.getStatus().compareTo(StewardOrderStatusEnum.AFFIRM.getOrderStatus()) != 0) {
            return ResponseUtil.fail((String)"\u8ba2\u5355\u5fc5\u987b\u662f\u5df2\u7ecf\u786e\u8ba4\u72b6\u6001");
        }
        if (stewardOrderMobileReqVO.getAdditionalCost().equals(0)) {
            this.stewardOrderService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(StewardOrderPO::getStatus, (Object)StewardOrderStatusEnum.CONFIRMED.getOrderStatus())).eq(StewardOrderPO::getStewardOrderCode, (Object)stewardOrderPO.getStewardOrderCode()));
        } else {
            StewardServicePO stewardServicePO = new StewardServicePO();
            stewardServicePO.setStewardServiceCode(UID.getUid());
            String additionalServerName = StewardAdditionalServerEnum.formCode((Integer)stewardOrderMobileReqVO.getAdditionalServiceName()).getDesc();
            stewardServicePO.setName(additionalServerName);
            stewardServicePO.setStewardServiceType(Integer.valueOf(1));
            stewardServicePO.setOriginalPrice(stewardOrderMobileReqVO.getAdditionalServicePrice());
            stewardServicePO.setCreateUserCode(stewardOrderMobileReqVO.getOptUserCode());
            stewardServicePO.setCreateUserName(stewardOrderMobileReqVO.getOptUserName());
            stewardServicePO.setCreateDate(LocalDateTime.now());
            stewardServicePO.setPreferentialPrice(stewardOrderMobileReqVO.getAdditionalServicePrice());
            this.stewardServiceService.save((Object)stewardServicePO);
            StewardOrderServicePO orderService = new StewardOrderServicePO();
            orderService.setStewardOrderServiceCode(UID.getUid());
            orderService.setStewardOrderCode(stewardOrderPO.getStewardOrderCode());
            orderService.setStewardServiceCode(stewardServicePO.getStewardServiceCode());
            orderService.setName(additionalServerName);
            orderService.setOriginalPrice(stewardOrderMobileReqVO.getOriginalPrice());
            orderService.setPreferentialPrice(stewardOrderMobileReqVO.getPreferentialPrice());
            orderService.setCreateUserCode(stewardOrderMobileReqVO.getOptUserCode());
            orderService.setCreateUserName(stewardOrderMobileReqVO.getOptUserName());
            orderService.setCreateDate(LocalDateTime.now());
            this.stewardOrderServiceRel.save((Object)orderService);
            this.stewardOrderService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(StewardOrderPO::getReservePrice, (Object)stewardOrderPO.getReservePrice().add(stewardOrderMobileReqVO.getAdditionalServicePrice()))).eq(StewardOrderPO::getStewardOrderCode, (Object)stewardOrderPO.getStewardOrderCode()));
        }
        return ResponseUtil.success((Object)true);
    }

    public ResponseData<String> paymentOrCode(StewardOrderPayReqVo stewardOrderVO) {
        TraceAddWithQRCodeRequestVO requestVO = new TraceAddWithQRCodeRequestVO();
        requestVO.setPage("");
        requestVO.setTraceType(TraceTypeEnum.AIRPORT_CONCIERGE_PAYMENT.getCode());
        HashMap<String, String> sceneMap = new HashMap<String, String>();
        sceneMap.put("stewardOrderCode", stewardOrderVO.getStewardOrderCode());
        requestVO.setTraceValue(JacksonUtil.bean2Json(sceneMap));
        ResponseData responseData = this.traceFeign.addTraceWithQRCode(requestVO);
        return ResponseUtil.success((Object)((TraceAddWithQRCodeResponseVO)responseData.getData()).getFileUrl());
    }

    public ResponseData<PageInfo<CouponEntityListResponseParam>> listAvailable(StewardServiceMobileCouponRequestVO requestVO) {
        List<String> stewardServiceCodes = Arrays.asList(requestVO.getStewardServiceCode().split(","));
        BigDecimal totalOriginalAmount = BigDecimal.ZERO;
        BigDecimal totalDiscountedAmount = BigDecimal.ZERO;
        for (String serviceCode : stewardServiceCodes) {
            StewardServicePO servicePO = this.stewardServiceService.findServiceByCode(serviceCode);
            if (servicePO == null) {
                return ResponseUtil.of((SysResponseEnum)SysResponseEnum.RIGHTS_HOTEL_ROOM_TYPE_SHELVES);
            }
            BigDecimal originalPrice = servicePO.getOriginalPrice();
            BigDecimal discountedPrice = servicePO.getPreferentialPrice();
            totalOriginalAmount = totalOriginalAmount.add(originalPrice);
            totalDiscountedAmount = totalDiscountedAmount.add(discountedPrice);
        }
        CouponEntityAvailableListReq couponEntityAvailableListReq = new CouponEntityAvailableListReq();
        couponEntityAvailableListReq.setOrderTagPrice(totalOriginalAmount);
        couponEntityAvailableListReq.setOrderAmount(totalDiscountedAmount);
        couponEntityAvailableListReq.setPageNum(requestVO.getPageNum().intValue());
        couponEntityAvailableListReq.setPageSize(requestVO.getPageSize().intValue());
        couponEntityAvailableListReq.setMbrMembersCode(requestVO.getMemberCode());
        couponEntityAvailableListReq.setSkuNoList(stewardServiceCodes);
        couponEntityAvailableListReq.setMerchantNo("AIRPORT_BUTLER_ONLY_NO");
        return this.couponComponent.listAvailable1(couponEntityAvailableListReq);
    }

    public StewardMobileService(StewardOrderServiceImpl stewardOrderService, StewardServiceDescriptionServiceImpl stewardServiceDescriptionService, StewardServiceServiceImpl stewardServiceService, FlightRecordFeign flightRecordfeign, FileUploadFeign fileUploadFeign, BasicFlightFeign basicFlightFeign, MbrAddressFeign mbrAddressFeign, PaymentComponent paymentComponent, TraceFeign traceFeign, StewardOrderServiceServiceImpl stewardOrderServiceRel, CouponComponent couponComponent, StewardOrderConst stewardOrderConst) {
        this.stewardOrderService = stewardOrderService;
        this.stewardServiceDescriptionService = stewardServiceDescriptionService;
        this.stewardServiceService = stewardServiceService;
        this.flightRecordfeign = flightRecordfeign;
        this.fileUploadFeign = fileUploadFeign;
        this.basicFlightFeign = basicFlightFeign;
        this.mbrAddressFeign = mbrAddressFeign;
        this.paymentComponent = paymentComponent;
        this.traceFeign = traceFeign;
        this.stewardOrderServiceRel = stewardOrderServiceRel;
        this.couponComponent = couponComponent;
        this.stewardOrderConst = stewardOrderConst;
    }
}

