/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.rights.api.service.ServiceRecordMobileService;
import com.bizvane.rights.domain.model.entity.RightsBarrierFreeParkingRecordPO;
import com.bizvane.rights.domain.model.entity.RightsLuggageDoorToDoorPO;
import com.bizvane.rights.domain.model.entity.RightsServiceRecordPO;
import com.bizvane.rights.domain.model.entity.RightsSpecialPassengerFlightPO;
import com.bizvane.rights.domain.model.entity.RightsSpecialPassengerRecordPO;
import com.bizvane.rights.domain.service.IRightsBarrierFreeParkingRecordService;
import com.bizvane.rights.domain.service.IRightsLuggageDoorToDoorService;
import com.bizvane.rights.domain.service.IRightsServiceRecordService;
import com.bizvane.rights.domain.service.IRightsSpecialPassengerFlightService;
import com.bizvane.rights.domain.service.IRightsSpecialPassengerRecordService;
import com.bizvane.rights.domain.util.ConvertUtil;
import com.bizvane.rights.domain.util.ResponseUtil;
import com.bizvane.rights.vo.service.RightsBarrierFreeParkingDetailResponseVO;
import com.bizvane.rights.vo.service.RightsLuggageDoorToDoorDetailResponseVO;
import com.bizvane.rights.vo.service.RightsServiceDetailRequestVO;
import com.bizvane.rights.vo.service.RightsServiceRecordDetailRequestVO;
import com.bizvane.rights.vo.service.RightsServiceRecordDetailResponseVO;
import com.bizvane.rights.vo.service.RightsServiceRecordUpdateReviewsStatusVO;
import com.bizvane.rights.vo.service.RightsSpecialPassengerDetailResponseVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ServiceRecordMobileServiceImpl
implements ServiceRecordMobileService {
    private static final Logger log = LoggerFactory.getLogger(ServiceRecordMobileServiceImpl.class);
    private final IRightsServiceRecordService rightsServiceRecordService;
    private final IRightsBarrierFreeParkingRecordService rightsBarrierFreeParkingRecordService;
    private final IRightsSpecialPassengerRecordService rightsSpecialPassengerRecordService;
    private final IRightsSpecialPassengerFlightService rightsSpecialPassengerFlightService;
    private final IRightsLuggageDoorToDoorService rightsLuggageDoorToDoorService;

    public ResponseData<PageInfo<RightsServiceRecordDetailResponseVO>> pageList(RightsServiceRecordDetailRequestVO requestVO) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(requestVO.getServiceType() != null, RightsServiceRecordPO::getServiceType, (Object)requestVO.getServiceType())).eq(RightsServiceRecordPO::getMbrMembersCode, (Object)requestVO.getMbrMembersCode())).orderByDesc(RightsServiceRecordPO::getCreateDate);
        Page page = new Page((long)requestVO.getPageNum().intValue(), (long)requestVO.getPageSize().intValue());
        Page pageList = (Page)this.rightsServiceRecordService.page((IPage)page, (Wrapper)queryWrapper);
        List responseVOList = pageList.getRecords().stream().map(ConvertUtil::po2vo).collect(Collectors.toList());
        PageInfo pageInfo = new PageInfo(requestVO.getPageNum().intValue(), requestVO.getPageSize().intValue(), pageList.getTotal(), responseVOList);
        return ResponseUtil.success((Object)pageInfo);
    }

    public ResponseData<RightsBarrierFreeParkingDetailResponseVO> barrierFreeParkingDetail(RightsServiceDetailRequestVO requestVO) {
        RightsBarrierFreeParkingRecordPO barrierFreeParkingRecordPO = this.rightsBarrierFreeParkingRecordService.detailByCode(requestVO.getServiceCode());
        if (barrierFreeParkingRecordPO != null && ObjectUtils.notEqual((Object)barrierFreeParkingRecordPO.getMbrMembersCode(), (Object)requestVO.getMemberCode())) {
            return ResponseUtil.success((Object)new RightsBarrierFreeParkingDetailResponseVO());
        }
        RightsBarrierFreeParkingDetailResponseVO responseVO = ConvertUtil.po2vo((RightsBarrierFreeParkingRecordPO)barrierFreeParkingRecordPO);
        return ResponseUtil.success((Object)responseVO);
    }

    public ResponseData<RightsSpecialPassengerDetailResponseVO> specialPassengerDetail(RightsServiceDetailRequestVO requestVO) {
        RightsSpecialPassengerRecordPO specialPassengerRecordPO = this.rightsSpecialPassengerRecordService.detailByCode(requestVO.getServiceCode());
        if (specialPassengerRecordPO != null && ObjectUtils.notEqual((Object)specialPassengerRecordPO.getMbrMembersCode(), (Object)requestVO.getMemberCode())) {
            return ResponseUtil.success((Object)new RightsSpecialPassengerDetailResponseVO());
        }
        RightsSpecialPassengerDetailResponseVO responseVO = ConvertUtil.po2vo((RightsSpecialPassengerRecordPO)specialPassengerRecordPO);
        if (StringUtils.isNotBlank((CharSequence)responseVO.getRightsSpecialPassengerRecordCode())) {
            RightsSpecialPassengerFlightPO rightsSpecialPassengerFlightPO = this.rightsSpecialPassengerFlightService.queryByRightsSpecialPassengerRecordCode(responseVO.getRightsSpecialPassengerRecordCode());
            responseVO.setFlightDetail(ConvertUtil.po2vo((RightsSpecialPassengerFlightPO)rightsSpecialPassengerFlightPO));
        }
        return ResponseUtil.success((Object)responseVO);
    }

    public ResponseData<RightsLuggageDoorToDoorDetailResponseVO> luggageDoorToDoorDetail(RightsServiceDetailRequestVO requestVO) {
        RightsLuggageDoorToDoorPO rightsLuggageDoorToDoorPO = this.rightsLuggageDoorToDoorService.detailByCode(requestVO.getServiceCode());
        if (rightsLuggageDoorToDoorPO != null && ObjectUtils.notEqual((Object)rightsLuggageDoorToDoorPO.getMbrMembersCode(), (Object)requestVO.getMemberCode())) {
            return ResponseUtil.success((Object)new RightsLuggageDoorToDoorDetailResponseVO());
        }
        RightsLuggageDoorToDoorDetailResponseVO responseVO = ConvertUtil.po2vo((RightsLuggageDoorToDoorPO)rightsLuggageDoorToDoorPO);
        return ResponseUtil.success((Object)responseVO);
    }

    public ResponseData<Boolean> updateReviewStatus(RightsServiceRecordUpdateReviewsStatusVO vo) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(RightsServiceRecordPO::getReviewStatus, (Object)Boolean.TRUE)).eq(RightsServiceRecordPO::getServiceType, (Object)vo.getServiceType())).eq(RightsServiceRecordPO::getReservationRecordNo, (Object)vo.getReservationRecordNo());
        boolean update = this.rightsServiceRecordService.update((Wrapper)updateWrapper);
        return ResponseUtil.success((Object)update);
    }

    public ServiceRecordMobileServiceImpl(IRightsServiceRecordService rightsServiceRecordService, IRightsBarrierFreeParkingRecordService rightsBarrierFreeParkingRecordService, IRightsSpecialPassengerRecordService rightsSpecialPassengerRecordService, IRightsSpecialPassengerFlightService rightsSpecialPassengerFlightService, IRightsLuggageDoorToDoorService rightsLuggageDoorToDoorService) {
        this.rightsServiceRecordService = rightsServiceRecordService;
        this.rightsBarrierFreeParkingRecordService = rightsBarrierFreeParkingRecordService;
        this.rightsSpecialPassengerRecordService = rightsSpecialPassengerRecordService;
        this.rightsSpecialPassengerFlightService = rightsSpecialPassengerFlightService;
        this.rightsLuggageDoorToDoorService = rightsLuggageDoorToDoorService;
    }
}

