/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.bizvane.rights.api.service.HotelRoomTypeService;
import com.bizvane.rights.api.service.component.ProductComponent;
import com.bizvane.rights.api.util.NumberUtil;
import com.bizvane.rights.api.util.UID;
import com.bizvane.rights.domain.model.entity.RightsHotelPO;
import com.bizvane.rights.domain.model.entity.RightsHotelRoomTypePO;
import com.bizvane.rights.domain.service.IRightsHotelRoomTypeService;
import com.bizvane.rights.domain.service.IRightsHotelService;
import com.bizvane.rights.domain.util.ConvertUtil;
import com.bizvane.rights.domain.util.ResponseUtil;
import com.bizvane.rights.vo.hotel.roomtype.RightsHotelRoomTypeAddRequestVO;
import com.bizvane.rights.vo.hotel.roomtype.RightsHotelRoomTypeAddResponseVO;
import com.bizvane.rights.vo.hotel.roomtype.RightsHotelRoomTypeBatchUpdateRequestVO;
import com.bizvane.rights.vo.hotel.roomtype.RightsHotelRoomTypeBatchUpdateResponseVO;
import com.bizvane.rights.vo.hotel.roomtype.RightsHotelRoomTypeConditionRequestVO;
import com.bizvane.rights.vo.hotel.roomtype.RightsHotelRoomTypeDetailResponseVO;
import com.bizvane.rights.vo.hotel.roomtype.RightsHotelRoomTypeDisableRequestVO;
import com.bizvane.rights.vo.hotel.roomtype.RightsHotelRoomTypeDisableResponseVO;
import com.bizvane.rights.vo.hotel.roomtype.RightsHotelRoomTypeUpdateRequestVO;
import com.bizvane.rights.vo.hotel.roomtype.RightsHotelRoomTypeUpdateResponseVO;
import com.bizvane.rights.vo.hotel.roomtype.RightsHotelWithRoomTypeVO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class HotelRoomTypeServiceImpl
implements HotelRoomTypeService {
    private static final Logger log = LoggerFactory.getLogger(HotelRoomTypeServiceImpl.class);
    private final IRightsHotelRoomTypeService rightsHotelRoomTypeService;
    private final IRightsHotelService rightsHotelService;
    private final ProductComponent productComponent;

    public RightsHotelRoomTypeDetailResponseVO detail(String rightsHotelRoomTypeCode) {
        RightsHotelRoomTypePO rightsHotelRoomTypePO = this.rightsHotelRoomTypeService.detailByCode(rightsHotelRoomTypeCode);
        RightsHotelRoomTypeDetailResponseVO responseVO = ConvertUtil.po2vo((RightsHotelRoomTypePO)rightsHotelRoomTypePO);
        if (rightsHotelRoomTypePO != null) {
            RightsHotelPO rightsHotelPO = this.rightsHotelService.detailByCode(rightsHotelRoomTypePO.getRightsHotelCode());
            responseVO.setHotelName(rightsHotelPO.getHotelName());
        }
        return responseVO;
    }

    public List<RightsHotelRoomTypeDetailResponseVO> listByCondition(RightsHotelRoomTypeConditionRequestVO requestVO) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(StringUtils.isNotBlank((CharSequence)requestVO.getRoomTypeName()), RightsHotelRoomTypePO::getRoomTypeName, (Object)requestVO.getRoomTypeName())).eq(requestVO.getEnableStatus() != null, RightsHotelRoomTypePO::getEnableStatus, (Object)requestVO.getEnableStatus())).eq(StringUtils.isNotBlank((CharSequence)requestVO.getCreateUserName()), RightsHotelRoomTypePO::getCreateUserName, (Object)requestVO.getCreateUserName())).gt(requestVO.getCreateDateStart() != null, RightsHotelRoomTypePO::getCreateDate, (Object)requestVO.getCreateDateStart())).lt(requestVO.getCreateDateEnd() != null, RightsHotelRoomTypePO::getCreateDate, (Object)requestVO.getCreateDateEnd())).eq(StringUtils.isNotBlank((CharSequence)requestVO.getModifiedUserName()), RightsHotelRoomTypePO::getModifiedUserName, (Object)requestVO.getModifiedUserName())).gt(requestVO.getModifiedDateStart() != null, RightsHotelRoomTypePO::getModifiedDate, (Object)requestVO.getModifiedDateStart())).lt(requestVO.getModifiedDateEnd() != null, RightsHotelRoomTypePO::getModifiedDate, (Object)requestVO.getModifiedDateEnd())).orderByDesc(RightsHotelRoomTypePO::getCreateDate);
        HashMap<String, RightsHotelPO> hotelPOHashMap = new HashMap<String, RightsHotelPO>();
        if (StringUtils.isNotBlank((CharSequence)requestVO.getRightsHotelCode())) {
            RightsHotelPO rightsHotelPO = this.rightsHotelService.detailByCodeAndOrgCodeList(requestVO.getRightsHotelCode(), requestVO.getOrgCodeList());
            if (rightsHotelPO == null) {
                return new ArrayList<RightsHotelRoomTypeDetailResponseVO>();
            }
            hotelPOHashMap.put(rightsHotelPO.getRightsHotelCode(), rightsHotelPO);
            queryWrapper.eq(RightsHotelRoomTypePO::getRightsHotelCode, (Object)rightsHotelPO.getRightsHotelCode());
        } else {
            List rightsHotelPOS = this.rightsHotelService.listByOrgCodeList(requestVO.getOrgCodeList());
            if (CollectionUtils.isEmpty((Collection)rightsHotelPOS)) {
                return new ArrayList<RightsHotelRoomTypeDetailResponseVO>();
            }
            for (RightsHotelPO rightsHotelPO : rightsHotelPOS) {
                hotelPOHashMap.put(rightsHotelPO.getRightsHotelCode(), rightsHotelPO);
            }
            queryWrapper.in(RightsHotelRoomTypePO::getRightsHotelCode, (Collection)rightsHotelPOS.stream().map(RightsHotelPO::getRightsHotelCode).collect(Collectors.toList()));
        }
        List roomTypePOList = this.rightsHotelRoomTypeService.list((Wrapper)queryWrapper);
        List<RightsHotelRoomTypeDetailResponseVO> responseVOList = roomTypePOList.stream().map(rightsHotelRoomTypePO -> {
            RightsHotelRoomTypeDetailResponseVO responseVO = ConvertUtil.po2vo((RightsHotelRoomTypePO)rightsHotelRoomTypePO);
            responseVO.setHotelName(((RightsHotelPO)hotelPOHashMap.get(rightsHotelRoomTypePO.getRightsHotelCode())).getHotelName());
            return responseVO;
        }).collect(Collectors.toList());
        return responseVOList;
    }

    public ResponseData<RightsHotelRoomTypeAddResponseVO> add(RightsHotelRoomTypeAddRequestVO requestVO) {
        long count = this.rightsHotelRoomTypeService.countByRightsHotelCodeAndRoomTypeCode(requestVO.getRightsHotelCode(), requestVO.getRoomTypeCode());
        if (count > 0L) {
            return ResponseUtil.of((SysResponseEnum)SysResponseEnum.RIGHTS_HOTEL_ROOM_TYPE_CODE_EXISTS);
        }
        RightsHotelRoomTypePO rightsHotelRoomTypePO = new RightsHotelRoomTypePO();
        rightsHotelRoomTypePO.setRightsHotelRoomTypeCode(UID.getUid());
        rightsHotelRoomTypePO.setRightsHotelCode(requestVO.getRightsHotelCode());
        rightsHotelRoomTypePO.setRoomTypeName(requestVO.getRoomTypeName());
        rightsHotelRoomTypePO.setRoomTypeCode(requestVO.getRoomTypeCode());
        rightsHotelRoomTypePO.setRoomMainImage(requestVO.getRoomMainImage());
        rightsHotelRoomTypePO.setRoomOtherImage(requestVO.getRoomOtherImage());
        rightsHotelRoomTypePO.setRoomOriginalPrice(requestVO.getRoomOriginalPrice());
        rightsHotelRoomTypePO.setRoomMemberPrice(requestVO.getRoomMemberPrice());
        rightsHotelRoomTypePO.setRoomEmployeePrice(requestVO.getRoomEmployeePrice());
        rightsHotelRoomTypePO.setRoomArea(requestVO.getRoomArea());
        rightsHotelRoomTypePO.setBedType(requestVO.getBedType());
        rightsHotelRoomTypePO.setRoomFacilities(requestVO.getRoomFacilities());
        rightsHotelRoomTypePO.setRemark(requestVO.getRemark());
        rightsHotelRoomTypePO.setEnableStatus(Boolean.TRUE);
        rightsHotelRoomTypePO.setCreateUserCode(requestVO.getOptUserCode());
        rightsHotelRoomTypePO.setCreateUserName(requestVO.getOptUserName());
        boolean save = this.rightsHotelRoomTypeService.save((Object)rightsHotelRoomTypePO);
        if (save) {
            this.productComponent.syncHotelProductAsync(rightsHotelRoomTypePO.getRightsHotelRoomTypeCode());
        }
        RightsHotelRoomTypeAddResponseVO responseVO = new RightsHotelRoomTypeAddResponseVO();
        responseVO.setOptStatus(save);
        return ResponseUtil.success((Object)responseVO);
    }

    public ResponseData<RightsHotelRoomTypeUpdateResponseVO> update(RightsHotelRoomTypeUpdateRequestVO requestVO) {
        RightsHotelRoomTypePO rightsHotelRoomTypePO = this.rightsHotelRoomTypeService.detailByRightsHotelCodeAndRoomTypeCode(requestVO.getRightsHotelCode(), requestVO.getRoomTypeCode());
        if (rightsHotelRoomTypePO != null && !rightsHotelRoomTypePO.getRightsHotelRoomTypeCode().equals(requestVO.getRightsHotelRoomTypeCode())) {
            return ResponseUtil.of((SysResponseEnum)SysResponseEnum.RIGHTS_HOTEL_ROOM_TYPE_CODE_EXISTS);
        }
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(RightsHotelRoomTypePO::getRightsHotelCode, (Object)requestVO.getRightsHotelCode())).set(RightsHotelRoomTypePO::getRoomTypeName, (Object)requestVO.getRoomTypeName())).set(RightsHotelRoomTypePO::getRoomTypeCode, (Object)requestVO.getRoomTypeCode())).set(RightsHotelRoomTypePO::getRoomMainImage, (Object)requestVO.getRoomMainImage())).set(RightsHotelRoomTypePO::getRoomOtherImage, (Object)requestVO.getRoomOtherImage())).set(RightsHotelRoomTypePO::getRoomOriginalPrice, (Object)requestVO.getRoomOriginalPrice())).set(RightsHotelRoomTypePO::getRoomMemberPrice, (Object)requestVO.getRoomMemberPrice())).set(RightsHotelRoomTypePO::getRoomEmployeePrice, (Object)requestVO.getRoomEmployeePrice())).set(RightsHotelRoomTypePO::getRoomArea, (Object)requestVO.getRoomArea())).set(RightsHotelRoomTypePO::getBedType, (Object)requestVO.getBedType())).set(RightsHotelRoomTypePO::getRoomFacilities, (Object)requestVO.getRoomFacilities())).set(RightsHotelRoomTypePO::getRemark, (Object)requestVO.getRemark())).set(RightsHotelRoomTypePO::getModifiedUserCode, (Object)requestVO.getOptUserCode())).set(RightsHotelRoomTypePO::getModifiedUserName, (Object)requestVO.getOptUserName())).eq(RightsHotelRoomTypePO::getRightsHotelRoomTypeCode, (Object)requestVO.getRightsHotelRoomTypeCode());
        boolean update = this.rightsHotelRoomTypeService.update((Wrapper)updateWrapper);
        if (update) {
            this.productComponent.syncHotelProductAsync(rightsHotelRoomTypePO.getRightsHotelRoomTypeCode());
        }
        RightsHotelRoomTypeUpdateResponseVO responseVO = new RightsHotelRoomTypeUpdateResponseVO();
        responseVO.setOptStatus(update);
        return ResponseUtil.success((Object)responseVO);
    }

    public RightsHotelRoomTypeDisableResponseVO updateEnableStatus(RightsHotelRoomTypeDisableRequestVO requestVO) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(RightsHotelRoomTypePO::getEnableStatus, (Object)requestVO.getEnableStatus())).set(RightsHotelRoomTypePO::getModifiedUserCode, (Object)requestVO.getOptUserCode())).set(RightsHotelRoomTypePO::getModifiedUserName, (Object)requestVO.getOptUserName())).eq(RightsHotelRoomTypePO::getRightsHotelRoomTypeCode, (Object)requestVO.getRightsHotelRoomTypeCode());
        boolean update = this.rightsHotelRoomTypeService.update((Wrapper)updateWrapper);
        RightsHotelRoomTypeDisableResponseVO responseVO = new RightsHotelRoomTypeDisableResponseVO();
        responseVO.setOptStatus(update);
        return responseVO;
    }

    public List<RightsHotelWithRoomTypeVO> listHotelWithRoomType(List<String> orgCodeList) {
        ArrayList<RightsHotelWithRoomTypeVO> resultList = new ArrayList<RightsHotelWithRoomTypeVO>();
        List rightsHotelPOS = this.rightsHotelService.listByOrgCodeList(orgCodeList);
        if (CollectionUtils.isNotEmpty((Collection)rightsHotelPOS)) {
            for (RightsHotelPO rightsHotelPO : rightsHotelPOS) {
                List rightsHotelRoomTypePOS = this.rightsHotelRoomTypeService.listByRightsHotelCode(rightsHotelPO.getRightsHotelCode());
                List roomTypeVOList = rightsHotelRoomTypePOS.stream().map(rightsHotelRoomTypePO -> {
                    RightsHotelWithRoomTypeVO.RoomTypeVO roomTypeVO = new RightsHotelWithRoomTypeVO.RoomTypeVO();
                    roomTypeVO.setRightsHotelRoomTypeCode(rightsHotelRoomTypePO.getRightsHotelRoomTypeCode());
                    roomTypeVO.setRoomTypeCode(rightsHotelRoomTypePO.getRoomTypeCode());
                    roomTypeVO.setRoomTypeName(rightsHotelRoomTypePO.getRoomTypeName());
                    return roomTypeVO;
                }).collect(Collectors.toList());
                RightsHotelWithRoomTypeVO rightsHotelWithRoomTypeVO = new RightsHotelWithRoomTypeVO();
                rightsHotelWithRoomTypeVO.setRightsHotelCode(rightsHotelPO.getRightsHotelCode());
                rightsHotelWithRoomTypeVO.setHotelName(rightsHotelPO.getHotelName());
                rightsHotelWithRoomTypeVO.setHotelCode(rightsHotelPO.getHotelCode());
                rightsHotelWithRoomTypeVO.setRoomTypeVOList(roomTypeVOList);
                resultList.add(rightsHotelWithRoomTypeVO);
            }
        }
        return resultList;
    }

    public RightsHotelRoomTypeBatchUpdateResponseVO batchUpdatePrice(RightsHotelRoomTypeBatchUpdateRequestVO requestVO) {
        BigDecimal max = NumberUtil.max((BigDecimal[])new BigDecimal[]{requestVO.getRoomEmployeePrice(), requestVO.getRoomMemberPrice()});
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(requestVO.getRoomEmployeePrice() != null, RightsHotelRoomTypePO::getRoomEmployeePrice, (Object)requestVO.getRoomEmployeePrice())).set(requestVO.getRoomMemberPrice() != null, RightsHotelRoomTypePO::getRoomMemberPrice, (Object)requestVO.getRoomMemberPrice())).setSql(max != null, String.format("room_original_price = if(room_original_price < %s, %s , room_original_price)", max, max), new Object[0]).set(RightsHotelRoomTypePO::getModifiedUserCode, (Object)requestVO.getOptUserCode())).set(RightsHotelRoomTypePO::getModifiedUserName, (Object)requestVO.getOptUserName())).in(RightsHotelRoomTypePO::getRightsHotelRoomTypeCode, (Collection)requestVO.getRightsHotelRoomTypeCodeList());
        boolean update = this.rightsHotelRoomTypeService.update((Wrapper)updateWrapper);
        if (update) {
            for (String hotelRoomTypeCode : requestVO.getRightsHotelRoomTypeCodeList()) {
                this.productComponent.syncHotelProductAsync(hotelRoomTypeCode);
            }
        }
        RightsHotelRoomTypeBatchUpdateResponseVO responseVO = new RightsHotelRoomTypeBatchUpdateResponseVO();
        responseVO.setOptStatus(update);
        return responseVO;
    }

    public HotelRoomTypeServiceImpl(IRightsHotelRoomTypeService rightsHotelRoomTypeService, IRightsHotelService rightsHotelService, ProductComponent productComponent) {
        this.rightsHotelRoomTypeService = rightsHotelRoomTypeService;
        this.rightsHotelService = rightsHotelService;
        this.productComponent = productComponent;
    }
}

