/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.service.impl;

import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.bizvane.basic.feign.model.vo.TBasicMerchantVo;
import com.bizvane.members.feign.model.bo.CouponCalculateDiscountAmountRequestParam;
import com.bizvane.members.feign.model.bo.CouponEntityAvailableListReq;
import com.bizvane.members.feign.model.bo.CouponEntityUseRequestParam;
import com.bizvane.members.feign.model.vo.CouponCalculateDiscountAmountVO;
import com.bizvane.members.feign.model.vo.CouponEntityListResponseParam;
import com.bizvane.payment.feign.vo.req.PrepareOrderReqVO;
import com.bizvane.payment.feign.vo.req.RefundOrderReqVO;
import com.bizvane.payment.feign.vo.resp.PrepayOrderRespVO;
import com.bizvane.rights.api.service.HotelOrderMobileService;
import com.bizvane.rights.api.service.HotelRoomSituationService;
import com.bizvane.rights.api.service.component.CouponComponent;
import com.bizvane.rights.api.service.component.MerchantComponent;
import com.bizvane.rights.api.service.component.OrderComponent;
import com.bizvane.rights.api.service.component.PaymentComponent;
import com.bizvane.rights.api.service.impl.HotelOrderMobileServiceImpl;
import com.bizvane.rights.api.service.impl.HotelOrderServiceImpl;
import com.bizvane.rights.api.util.UID;
import com.bizvane.rights.consts.BusinessConst;
import com.bizvane.rights.domain.enums.HotelOrderCancellationTypeEnum;
import com.bizvane.rights.domain.enums.HotelOrderRefundStatusEnum;
import com.bizvane.rights.domain.enums.HotelOrderStatusEnum;
import com.bizvane.rights.domain.enums.HotelRoomSituationOptionTypeEnum;
import com.bizvane.rights.domain.model.entity.RightsHotelOrderDetailPO;
import com.bizvane.rights.domain.model.entity.RightsHotelOrderPO;
import com.bizvane.rights.domain.model.entity.RightsHotelPO;
import com.bizvane.rights.domain.model.entity.RightsHotelRoomSituationLogPO;
import com.bizvane.rights.domain.model.entity.RightsHotelRoomSituationPO;
import com.bizvane.rights.domain.model.entity.RightsHotelRoomTypePO;
import com.bizvane.rights.domain.service.IRightsHotelOrderDetailService;
import com.bizvane.rights.domain.service.IRightsHotelOrderService;
import com.bizvane.rights.domain.service.IRightsHotelRoomSituationLogService;
import com.bizvane.rights.domain.service.IRightsHotelRoomSituationService;
import com.bizvane.rights.domain.service.IRightsHotelRoomTypeService;
import com.bizvane.rights.domain.service.IRightsHotelService;
import com.bizvane.rights.domain.util.AssertUtil;
import com.bizvane.rights.domain.util.LocalDateUtils;
import com.bizvane.rights.domain.util.ResponseUtil;
import com.bizvane.rights.enums.HotelOrderPayTypeEnum;
import com.bizvane.rights.enums.HotelOrderReservationTypeEnum;
import com.bizvane.rights.mq.AddEvaluateMq;
import com.bizvane.rights.vo.hotel.order.mobile.RightsHotelOrderCancelRequestVO;
import com.bizvane.rights.vo.hotel.order.mobile.RightsHotelOrderCancelResponseVO;
import com.bizvane.rights.vo.hotel.order.mobile.RightsHotelOrderDetailRequestVO;
import com.bizvane.rights.vo.hotel.order.mobile.RightsHotelOrderDetailResponseVO;
import com.bizvane.rights.vo.hotel.order.mobile.RightsHotelOrderPaymentRequestVO;
import com.bizvane.rights.vo.hotel.order.mobile.RightsHotelOrderPaymentResponseVO;
import com.bizvane.rights.vo.hotel.order.mobile.RightsHotelOrderRequestVO;
import com.bizvane.rights.vo.hotel.order.mobile.RightsHotelOrderResponseVO;
import com.bizvane.rights.vo.hotel.order.mobile.RightsHotelPreOrderRequestVO;
import com.bizvane.rights.vo.hotel.order.mobile.RightsHotelPreOrderResponseVO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.exception.BizException;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class HotelOrderMobileServiceImpl
implements HotelOrderMobileService {
    private final IRightsHotelRoomTypeService rightsHotelRoomTypeService;
    private final IRightsHotelRoomSituationService rightsHotelRoomSituationService;
    private final IRightsHotelService rightsHotelService;
    private final IRightsHotelOrderService rightsHotelOrderService;
    private final IRightsHotelOrderDetailService rightsHotelOrderDetailService;
    private final IRightsHotelRoomSituationLogService rightsHotelRoomSituationLogService;
    private final HotelRoomSituationService hotelRoomSituationService;
    private final PaymentComponent paymentComponent;
    private final OrderComponent orderComponent;
    private final CouponComponent couponComponent;
    private final MerchantComponent merchantComponent;
    private final HotelOrderServiceImpl hotelOrderService;

    private RightsHotelOrderDetailResponseVO getRightsHotelOrderDetailResponseVO(RightsHotelOrderPO rightsHotelOrderPO, List<RightsHotelOrderDetailPO> rightsHotelOrderDetailPOS) {
        BigDecimal totalOriginalAmount = BigDecimal.ZERO;
        BigDecimal totalActualAmount = BigDecimal.ZERO;
        for (RightsHotelOrderDetailPO rightsHotelOrderDetailPO : rightsHotelOrderDetailPOS) {
            totalOriginalAmount = totalOriginalAmount.add(rightsHotelOrderDetailPO.getOriginalPrice().multiply(new BigDecimal(rightsHotelOrderDetailPO.getQuantity())));
            totalActualAmount = totalActualAmount.add(rightsHotelOrderDetailPO.getActualPrice().multiply(new BigDecimal(rightsHotelOrderDetailPO.getQuantity())));
        }
        RightsHotelOrderDetailResponseVO responseVO = new RightsHotelOrderDetailResponseVO();
        responseVO.setRightsHotelCode(rightsHotelOrderPO.getRightsHotelCode());
        responseVO.setHotelName(rightsHotelOrderPO.getHotelName());
        responseVO.setOrderNo(rightsHotelOrderPO.getOrderNo());
        responseVO.setRightsHotelOrderCode(rightsHotelOrderPO.getRightsHotelOrderCode());
        responseVO.setStartDate(rightsHotelOrderPO.getExpectedArrivalTime().toLocalDate());
        responseVO.setEndDate(rightsHotelOrderPO.getExpectedCheckOutTime().toLocalDate());
        responseVO.setQuantity(rightsHotelOrderDetailPOS.get(0).getQuantity());
        responseVO.setOrderStatus(rightsHotelOrderPO.getOrderStatus());
        responseVO.setTotalActualAmount(totalActualAmount);
        responseVO.setCouponDiscountPrice(rightsHotelOrderPO.getDiscountAmount());
        responseVO.setPayableAmount(rightsHotelOrderPO.getPayableAmount());
        if (responseVO.getCouponDiscountPrice() == null) {
            responseVO.setTotalDiscountAmount(totalOriginalAmount.subtract(totalActualAmount));
        } else {
            responseVO.setTotalDiscountAmount(totalOriginalAmount.subtract(totalActualAmount).add(responseVO.getCouponDiscountPrice()));
        }
        responseVO.setTotalOriginalAmount(totalOriginalAmount);
        responseVO.setReservationName(rightsHotelOrderPO.getReservationName());
        responseVO.setReservationPhone(rightsHotelOrderPO.getReservationPhone());
        responseVO.setExpectedArrivalTime(rightsHotelOrderPO.getExpectedArrivalTime().toLocalTime());
        responseVO.setPayType(rightsHotelOrderPO.getPayType());
        responseVO.setRightsHotelOrderCode(rightsHotelOrderPO.getRightsHotelOrderCode());
        responseVO.setHandlingInstructions(rightsHotelOrderPO.getHandlingInstructions());
        responseVO.setEvaluationStatus(rightsHotelOrderPO.getEvaluationStatus());
        String rightsHotelRoomTypeCode = rightsHotelOrderDetailPOS.get(0).getRightsHotelRoomTypeCode();
        RightsHotelRoomTypePO rightsHotelRoomTypePO = this.rightsHotelRoomTypeService.detailByCode(rightsHotelRoomTypeCode);
        responseVO.setRoomTypeName(rightsHotelRoomTypePO.getRoomTypeName());
        responseVO.setBedType(rightsHotelRoomTypePO.getBedType());
        responseVO.setRoomArea(rightsHotelRoomTypePO.getRoomArea());
        return responseVO;
    }

    public ResponseData<RightsHotelPreOrderResponseVO> preOrder(RightsHotelPreOrderRequestVO requestVO) {
        List localDates = LocalDateUtils.datesUntil((LocalDate)requestVO.getStartDate(), (LocalDate)requestVO.getEndDate());
        RightsHotelRoomTypePO rightsHotelRoomTypePO = this.rightsHotelRoomTypeService.detailByCode(requestVO.getRightsHotelRoomTypeCode());
        if (rightsHotelRoomTypePO == null) {
            return ResponseUtil.of((SysResponseEnum)SysResponseEnum.RIGHTS_HOTEL_ROOM_TYPE_SHELVES);
        }
        if (!this.judgeContinuePlaceOrder(requestVO.getReservationType(), requestVO.getMemberCode())) {
            return ResponseUtil.of((SysResponseEnum)SysResponseEnum.RIGHTS_HOTEL_ORDER_STAFF_DAY_LIMIT);
        }
        RightsHotelPO rightsHotelPO = this.rightsHotelService.detailByCode(rightsHotelRoomTypePO.getRightsHotelCode());
        RightsHotelPreOrderResponseVO responseVO = new RightsHotelPreOrderResponseVO();
        responseVO.setRightsHotelCode(rightsHotelPO.getRightsHotelCode());
        responseVO.setHotelName(rightsHotelPO.getHotelName());
        responseVO.setStartDate(requestVO.getStartDate());
        responseVO.setEndDate(requestVO.getEndDate());
        responseVO.setQuantity(requestVO.getQuantity());
        BigDecimal totalOriginalAmount = rightsHotelRoomTypePO.getRoomOriginalPrice().multiply(new BigDecimal(requestVO.getQuantity())).multiply(BigDecimal.valueOf(localDates.size()));
        responseVO.setTotalOriginalAmount(totalOriginalAmount);
        HotelOrderReservationTypeEnum hotelOrderReservationTypeEnum = HotelOrderReservationTypeEnum.fromType((Integer)requestVO.getReservationType());
        BigDecimal sourcePrice = BigDecimal.ZERO;
        if (HotelOrderReservationTypeEnum.EMPLOYEE_RESERVATION.equals((Object)hotelOrderReservationTypeEnum)) {
            sourcePrice = sourcePrice.add(rightsHotelRoomTypePO.getRoomEmployeePrice());
        } else if (HotelOrderReservationTypeEnum.MEMBER_RESERVATION.equals((Object)hotelOrderReservationTypeEnum)) {
            sourcePrice = sourcePrice.add(rightsHotelRoomTypePO.getRoomMemberPrice());
        } else {
            throw new BizException("\u83b7\u53d6\u9884\u5b9a\u7c7b\u578b\u4ef7\u683c\u5931\u8d25!");
        }
        BigDecimal totalActualAmount = sourcePrice.multiply(new BigDecimal(requestVO.getQuantity())).multiply(BigDecimal.valueOf(localDates.size()));
        TBasicMerchantVo merchantByOrgCode = this.merchantComponent.getMerchantByOrgCode(rightsHotelPO.getOrgCode());
        if (StringUtils.isNotBlank((CharSequence)requestVO.getCouponNo())) {
            CouponCalculateDiscountAmountRequestParam.GoodsSkuBO goodsSkuBO = CouponCalculateDiscountAmountRequestParam.GoodsSkuBO.builder().tagPrice(rightsHotelRoomTypePO.getRoomOriginalPrice()).discountPrice(sourcePrice).skuNo(rightsHotelRoomTypePO.getRoomTypeCode()).quantityDecimal(BigDecimal.valueOf(localDates.size()).multiply(BigDecimal.valueOf(requestVO.getQuantity().intValue()))).build();
            CouponCalculateDiscountAmountRequestParam requestParam = CouponCalculateDiscountAmountRequestParam.builder().orderTagPrice(totalOriginalAmount).orderAmount(totalActualAmount).couponNo(requestVO.getCouponNo()).goodsSkuBOList(Arrays.asList(goodsSkuBO)).build();
            CouponCalculateDiscountAmountVO couponCalculateDiscountAmountVO = this.couponComponent.preUseQuery(requestParam, merchantByOrgCode);
            responseVO.setCouponDiscountPrice(couponCalculateDiscountAmountVO.getDiscountPrice());
        }
        CouponEntityAvailableListReq couponEntityAvailableListReq = new CouponEntityAvailableListReq();
        couponEntityAvailableListReq.setOrderTagPrice(totalOriginalAmount);
        couponEntityAvailableListReq.setOrderAmount(totalActualAmount);
        couponEntityAvailableListReq.setPageNum(requestVO.getPageNum().intValue());
        couponEntityAvailableListReq.setPageSize(requestVO.getPageSize().intValue());
        couponEntityAvailableListReq.setMbrMembersCode(requestVO.getMemberCode());
        couponEntityAvailableListReq.setSkuNoList(Arrays.asList(rightsHotelRoomTypePO.getRoomTypeCode()));
        ResponseData listAvailable = this.couponComponent.listAvailable(couponEntityAvailableListReq, merchantByOrgCode);
        if (ResponseUtil.isSuccess((ResponseData)listAvailable)) {
            responseVO.setAvailableCouponCount(((PageInfo)listAvailable.getData()).getTotal());
        }
        responseVO.setTotalActualAmount(totalActualAmount);
        if (responseVO.getCouponDiscountPrice() == null) {
            responseVO.setPayableAmount(totalActualAmount);
            responseVO.setTotalDiscountAmount(totalOriginalAmount.subtract(totalActualAmount));
        } else {
            responseVO.setPayableAmount(totalActualAmount.subtract(responseVO.getCouponDiscountPrice()));
            responseVO.setTotalDiscountAmount(totalOriginalAmount.subtract(totalActualAmount).add(responseVO.getCouponDiscountPrice()));
        }
        return ResponseUtil.success((Object)responseVO);
    }

    public ResponseData<PageInfo<CouponEntityListResponseParam>> listAvailable(RightsHotelPreOrderRequestVO requestVO) {
        List localDates = LocalDateUtils.datesUntil((LocalDate)requestVO.getStartDate(), (LocalDate)requestVO.getEndDate());
        RightsHotelRoomTypePO rightsHotelRoomTypePO = this.rightsHotelRoomTypeService.detailByCode(requestVO.getRightsHotelRoomTypeCode());
        if (rightsHotelRoomTypePO == null) {
            return ResponseUtil.of((SysResponseEnum)SysResponseEnum.RIGHTS_HOTEL_ROOM_TYPE_SHELVES);
        }
        if (!this.judgeContinuePlaceOrder(requestVO.getReservationType(), requestVO.getMemberCode())) {
            return ResponseUtil.of((SysResponseEnum)SysResponseEnum.RIGHTS_HOTEL_ORDER_STAFF_DAY_LIMIT);
        }
        RightsHotelPO rightsHotelPO = this.rightsHotelService.detailByCode(rightsHotelRoomTypePO.getRightsHotelCode());
        BigDecimal totalOriginalAmount = rightsHotelRoomTypePO.getRoomOriginalPrice().multiply(new BigDecimal(requestVO.getQuantity())).multiply(BigDecimal.valueOf(localDates.size()));
        HotelOrderReservationTypeEnum hotelOrderReservationTypeEnum = HotelOrderReservationTypeEnum.fromType((Integer)requestVO.getReservationType());
        BigDecimal sourcePrice = BigDecimal.ZERO;
        if (HotelOrderReservationTypeEnum.EMPLOYEE_RESERVATION.equals((Object)hotelOrderReservationTypeEnum)) {
            sourcePrice = sourcePrice.add(rightsHotelRoomTypePO.getRoomEmployeePrice());
        } else if (HotelOrderReservationTypeEnum.MEMBER_RESERVATION.equals((Object)hotelOrderReservationTypeEnum)) {
            sourcePrice = sourcePrice.add(rightsHotelRoomTypePO.getRoomMemberPrice());
        } else {
            throw new BizException("\u83b7\u53d6\u9884\u5b9a\u7c7b\u578b\u4ef7\u683c\u5931\u8d25!");
        }
        BigDecimal totalActualAmount = sourcePrice.multiply(new BigDecimal(requestVO.getQuantity())).multiply(BigDecimal.valueOf(localDates.size()));
        CouponEntityAvailableListReq couponEntityAvailableListReq = new CouponEntityAvailableListReq();
        couponEntityAvailableListReq.setOrderTagPrice(totalOriginalAmount);
        couponEntityAvailableListReq.setOrderAmount(totalActualAmount);
        couponEntityAvailableListReq.setPageNum(requestVO.getPageNum().intValue());
        couponEntityAvailableListReq.setPageSize(requestVO.getPageSize().intValue());
        couponEntityAvailableListReq.setMbrMembersCode(requestVO.getMemberCode());
        couponEntityAvailableListReq.setSkuNoList(Arrays.asList(rightsHotelRoomTypePO.getRoomTypeCode()));
        TBasicMerchantVo merchantByOrgCode = this.merchantComponent.getMerchantByOrgCode(rightsHotelPO.getOrgCode());
        return this.couponComponent.listAvailable(couponEntityAvailableListReq, merchantByOrgCode);
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<RightsHotelOrderResponseVO> order(RightsHotelOrderRequestVO requestVO) {
        TBasicMerchantVo merchantByOrgCode;
        List localDates = LocalDateUtils.datesUntil((LocalDate)requestVO.getStartDate(), (LocalDate)requestVO.getEndDate());
        RightsHotelRoomTypePO rightsHotelRoomTypePO = this.rightsHotelRoomTypeService.detailByCode(requestVO.getRightsHotelRoomTypeCode());
        if (rightsHotelRoomTypePO == null || !rightsHotelRoomTypePO.getEnableStatus().booleanValue()) {
            return ResponseUtil.of((SysResponseEnum)SysResponseEnum.RIGHTS_HOTEL_ROOM_TYPE_CODE_EXISTS);
        }
        RightsHotelPO rightsHotelPO = this.rightsHotelService.detailByCode(rightsHotelRoomTypePO.getRightsHotelCode());
        if (!rightsHotelPO.getEnableStatus().booleanValue()) {
            return ResponseUtil.of((SysResponseEnum)SysResponseEnum.RIGHTS_HOTEL_ROOM_TYPE_CODE_EXISTS);
        }
        if (!this.judgeContinuePlaceOrder(requestVO.getReservationType(), requestVO.getMemberCode())) {
            return ResponseUtil.of((SysResponseEnum)SysResponseEnum.RIGHTS_HOTEL_ORDER_STAFF_DAY_LIMIT);
        }
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RightsHotelRoomSituationPO::getRightsHotelRoomTypeCode, (Object)requestVO.getRightsHotelRoomTypeCode())).in(RightsHotelRoomSituationPO::getDayDate, (Collection)localDates)).ge(RightsHotelRoomSituationPO::getTotalStock, (Object)requestVO.getQuantity());
        List hotelRoomSituationPOList = this.rightsHotelRoomSituationService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)hotelRoomSituationPOList) || hotelRoomSituationPOList.size() != localDates.size()) {
            return ResponseUtil.of((SysResponseEnum)SysResponseEnum.RIGHTS_HOTEL_ROOM_SITUATION_INSUFFICIENT_STOCK);
        }
        RightsHotelOrderPO rightsHotelOrderPOAdd = new RightsHotelOrderPO();
        rightsHotelOrderPOAdd.setRightsHotelOrderCode(UID.getUid());
        rightsHotelOrderPOAdd.setRightsHotelCode(rightsHotelPO.getRightsHotelCode());
        rightsHotelOrderPOAdd.setHotelName(rightsHotelPO.getHotelName());
        rightsHotelOrderPOAdd.setOrderNo(UID.getHotelNo());
        rightsHotelOrderPOAdd.setReservationName(requestVO.getReservationName());
        rightsHotelOrderPOAdd.setReservationPhone(requestVO.getReservationPhone());
        rightsHotelOrderPOAdd.setReservationPhoneEncrypt(requestVO.getReservationPhoneEncrypt());
        rightsHotelOrderPOAdd.setExpectedArrivalTime(LocalDateTime.of(requestVO.getStartDate(), requestVO.getExpectedArrivalTime()));
        rightsHotelOrderPOAdd.setExpectedCheckOutTime(LocalDateTime.of(requestVO.getEndDate(), BusinessConst.EXPECTED_ARRIVAL_TIME));
        rightsHotelOrderPOAdd.setReservationTime(LocalDateTime.now());
        rightsHotelOrderPOAdd.setMemberCode(requestVO.getMemberCode());
        HotelOrderReservationTypeEnum hotelOrderReservationTypeEnum = HotelOrderReservationTypeEnum.fromType((Integer)requestVO.getReservationType());
        BigDecimal roomTypePrice = BigDecimal.ZERO;
        if (HotelOrderReservationTypeEnum.EMPLOYEE_RESERVATION.equals((Object)hotelOrderReservationTypeEnum)) {
            roomTypePrice = roomTypePrice.add(rightsHotelRoomTypePO.getRoomEmployeePrice());
        } else if (HotelOrderReservationTypeEnum.MEMBER_RESERVATION.equals((Object)hotelOrderReservationTypeEnum)) {
            roomTypePrice = roomTypePrice.add(rightsHotelRoomTypePO.getRoomMemberPrice());
        } else {
            throw new BizException("\u83b7\u53d6\u9884\u5b9a\u7c7b\u578b\u4ef7\u683c\u5931\u8d25!");
        }
        BigDecimal totalPrices = roomTypePrice.multiply(new BigDecimal(requestVO.getQuantity()));
        BigDecimal totalAmount = totalPrices.multiply(BigDecimal.valueOf(localDates.size()));
        rightsHotelOrderPOAdd.setTotalPrices(totalAmount);
        rightsHotelOrderPOAdd.setPayableAmount(totalAmount);
        rightsHotelOrderPOAdd.setPayType(requestVO.getPayType());
        rightsHotelOrderPOAdd.setReservationType(requestVO.getReservationType());
        rightsHotelOrderPOAdd.setCreateDate(LocalDateTime.now());
        if (StringUtils.isNotBlank((CharSequence)requestVO.getCouponNo())) {
            BigDecimal totalActualAmount = roomTypePrice.multiply(new BigDecimal(requestVO.getQuantity())).multiply(BigDecimal.valueOf(localDates.size()));
            BigDecimal totalOriginalAmount = rightsHotelRoomTypePO.getRoomOriginalPrice().multiply(new BigDecimal(requestVO.getQuantity())).multiply(BigDecimal.valueOf(localDates.size()));
            CouponCalculateDiscountAmountRequestParam.GoodsSkuBO goodsSkuBO = CouponCalculateDiscountAmountRequestParam.GoodsSkuBO.builder().tagPrice(rightsHotelRoomTypePO.getRoomOriginalPrice()).discountPrice(roomTypePrice).skuNo(rightsHotelRoomTypePO.getRoomTypeCode()).quantityDecimal(BigDecimal.valueOf(localDates.size()).multiply(BigDecimal.valueOf(requestVO.getQuantity().intValue()))).build();
            CouponCalculateDiscountAmountRequestParam requestParam = CouponCalculateDiscountAmountRequestParam.builder().orderTagPrice(totalOriginalAmount).orderAmount(totalActualAmount).couponNo(requestVO.getCouponNo()).goodsSkuBOList(Arrays.asList(goodsSkuBO)).build();
            merchantByOrgCode = this.merchantComponent.getMerchantByOrgCode(rightsHotelPO.getOrgCode());
            CouponCalculateDiscountAmountVO couponCalculateDiscountAmountVO = this.couponComponent.preUseQuery(requestParam, merchantByOrgCode);
            rightsHotelOrderPOAdd.setDiscountAmount(couponCalculateDiscountAmountVO.getDiscountPrice());
            rightsHotelOrderPOAdd.setPayableAmount(totalAmount.subtract(couponCalculateDiscountAmountVO.getDiscountPrice()));
            rightsHotelOrderPOAdd.setCouponNo(requestVO.getCouponNo());
        }
        HotelOrderPayTypeEnum hotelOrderPayTypeEnum = HotelOrderPayTypeEnum.fromType((Integer)requestVO.getPayType());
        switch (1.$SwitchMap$com$bizvane$rights$enums$HotelOrderPayTypeEnum[hotelOrderPayTypeEnum.ordinal()]) {
            case 1: {
                rightsHotelOrderPOAdd.setOrderStatus(HotelOrderStatusEnum.TO_BE_CONFIRMED.getOrderStatus());
                break;
            }
            case 2: {
                rightsHotelOrderPOAdd.setOrderStatus(HotelOrderStatusEnum.PENDING_PAYMENT.getOrderStatus());
                break;
            }
            default: {
                throw new BizException("\u83b7\u53d6\u652f\u4ed8\u7c7b\u578b\u5931\u8d25!");
            }
        }
        boolean orderSave = this.rightsHotelOrderService.save((Object)rightsHotelOrderPOAdd);
        ArrayList<RightsHotelRoomSituationLogPO> rightsHotelRoomSituationLogPOList = new ArrayList<RightsHotelRoomSituationLogPO>();
        for (RightsHotelRoomSituationPO rightsHotelRoomSituationPO : hotelRoomSituationPOList) {
            long updateStock = this.rightsHotelRoomSituationService.reduceStock(rightsHotelRoomSituationPO.getRightsHotelRoomSituationCode(), requestVO.getQuantity(), rightsHotelRoomSituationPO.getVersion());
            if (updateStock == 0L) {
                throw new BizException(SysResponseEnum.RIGHTS_HOTEL_ROOM_SITUATION_INVENTORY_STOCK_FAILED.getCode(), SysResponseEnum.RIGHTS_HOTEL_ROOM_SITUATION_INVENTORY_STOCK_FAILED.getMessage());
            }
            RightsHotelOrderDetailPO rightsHotelOrderDetailPOAdd = new RightsHotelOrderDetailPO();
            rightsHotelOrderDetailPOAdd.setRightsHotelOrderDetailCode(UID.getUid());
            rightsHotelOrderDetailPOAdd.setRightsHotelOrderCode(rightsHotelOrderPOAdd.getRightsHotelOrderCode());
            rightsHotelOrderDetailPOAdd.setRightsHotelRoomTypeCode(rightsHotelRoomTypePO.getRightsHotelRoomTypeCode());
            rightsHotelOrderDetailPOAdd.setRoomTypeName(rightsHotelRoomTypePO.getRoomTypeName());
            rightsHotelOrderDetailPOAdd.setRoomMainImage(rightsHotelRoomTypePO.getRoomMainImage());
            rightsHotelOrderDetailPOAdd.setOriginalPrice(rightsHotelRoomTypePO.getRoomOriginalPrice());
            rightsHotelOrderDetailPOAdd.setActualPrice(roomTypePrice);
            rightsHotelOrderDetailPOAdd.setQuantity(requestVO.getQuantity());
            rightsHotelOrderDetailPOAdd.setTotalPrices(totalPrices);
            rightsHotelOrderDetailPOAdd.setRightsHotelRoomSituationCode(rightsHotelRoomSituationPO.getRightsHotelRoomSituationCode());
            boolean orderDetailSave = this.rightsHotelOrderDetailService.save((Object)rightsHotelOrderDetailPOAdd);
            String jsonString = JSON.toJSONString((Object)rightsHotelRoomSituationPO);
            RightsHotelRoomSituationLogPO rightsHotelRoomSituationLogPO = new RightsHotelRoomSituationLogPO();
            rightsHotelRoomSituationLogPO.setRightsHotelRoomSituationCode(rightsHotelRoomSituationPO.getRightsHotelRoomSituationCode());
            rightsHotelRoomSituationLogPO.setOldHotelRoomSituation(jsonString);
            rightsHotelRoomSituationLogPO.setDayDate(rightsHotelRoomSituationPO.getDayDate());
            rightsHotelRoomSituationLogPO.setOldTotalStock(rightsHotelRoomSituationPO.getTotalStock());
            rightsHotelRoomSituationLogPO.setOldSalesVolume(rightsHotelRoomSituationPO.getSalesVolume());
            rightsHotelRoomSituationLogPO.setNewTotalStock(Integer.valueOf(rightsHotelRoomSituationPO.getTotalStock() - requestVO.getQuantity()));
            rightsHotelRoomSituationLogPO.setType(HotelRoomSituationOptionTypeEnum.FILED_1.getType());
            rightsHotelRoomSituationLogPOList.add(rightsHotelRoomSituationLogPO);
        }
        this.rightsHotelRoomSituationLogService.saveBatch(rightsHotelRoomSituationLogPOList);
        if (StringUtils.isNotBlank((CharSequence)requestVO.getCouponNo())) {
            CouponEntityUseRequestParam couponEntityUseRequestParam = CouponEntityUseRequestParam.builder().useType(Integer.valueOf(1)).couponNo(requestVO.getCouponNo()).useBusinessCode(rightsHotelOrderPOAdd.getOrderNo()).useBusinessAmount(rightsHotelOrderPOAdd.getTotalPrices()).discountPrice(BigDecimal.ZERO).useTime(LocalDateTime.now()).useStaffStatus(Boolean.FALSE).skuNoList(Arrays.asList(rightsHotelRoomTypePO.getRoomTypeCode())).build();
            merchantByOrgCode = this.merchantComponent.getMerchantByOrgCode(rightsHotelPO.getOrgCode());
            this.couponComponent.use(couponEntityUseRequestParam, merchantByOrgCode);
        }
        this.orderComponent.syncHotelOrderAsync(rightsHotelOrderPOAdd.getRightsHotelOrderCode());
        if (hotelOrderPayTypeEnum == HotelOrderPayTypeEnum.WECHAT_PAY) {
            this.orderComponent.hotelOrderPendingPayment(rightsHotelOrderPOAdd);
        }
        RightsHotelOrderResponseVO responseVO = new RightsHotelOrderResponseVO();
        responseVO.setRightsHotelOrderCode(rightsHotelOrderPOAdd.getRightsHotelOrderCode());
        responseVO.setOrderNo(rightsHotelOrderPOAdd.getOrderNo());
        responseVO.setOptStatus(orderSave);
        return ResponseUtil.success((Object)responseVO);
    }

    private boolean judgeContinuePlaceOrder(Integer reservationType, String memberCode) {
        HotelOrderReservationTypeEnum hotelOrderReservationTypeEnum = HotelOrderReservationTypeEnum.fromType((Integer)reservationType);
        if (hotelOrderReservationTypeEnum != HotelOrderReservationTypeEnum.EMPLOYEE_RESERVATION) {
            return true;
        }
        List rightsHotelOrderPOS = this.rightsHotelOrderService.listByMemberCodeToday(memberCode);
        if (CollectionUtils.isEmpty((Collection)rightsHotelOrderPOS)) {
            return true;
        }
        List rightsHotelOrderCodeList = rightsHotelOrderPOS.stream().map(rightsHotelOrderPO -> rightsHotelOrderPO.getRightsHotelOrderCode()).collect(Collectors.toList());
        List rightsHotelOrderDetailPOS = this.rightsHotelOrderDetailService.listByRightsHotelOrderCodeList(rightsHotelOrderCodeList);
        int quantitySum = rightsHotelOrderDetailPOS.stream().collect(Collectors.groupingBy(RightsHotelOrderDetailPO::getRightsHotelOrderCode, Collectors.collectingAndThen(Collectors.toList(), list -> ((RightsHotelOrderDetailPO)list.get(0)).getQuantity()))).values().stream().mapToInt(x -> (Integer)ObjUtil.defaultIfNull((Object)x, (Object)1)).sum();
        return (long)quantitySum < 3L;
    }

    public ResponseData<RightsHotelOrderPaymentResponseVO> orderPayment(RightsHotelOrderPaymentRequestVO requestVO) {
        RightsHotelOrderPO rightsHotelOrderPO = this.rightsHotelOrderService.detailByCode(requestVO.getRightsHotelOrderCode());
        if (HotelOrderStatusEnum.codeByOrderStatus((Integer)rightsHotelOrderPO.getOrderStatus()) != HotelOrderStatusEnum.PENDING_PAYMENT) {
            return ResponseUtil.of((SysResponseEnum)SysResponseEnum.RIGHTS_HOTEL_ORDER_WECHAT_PAY_STATUS_FAIL);
        }
        if (LocalDateTimeUtil.toEpochMilli((TemporalAccessor)rightsHotelOrderPO.getCreateDate()) + 900000L < System.currentTimeMillis()) {
            return ResponseUtil.of((SysResponseEnum)SysResponseEnum.RIGHTS_HOTEL_ORDER_WECHAT_PAY_DELAY);
        }
        if (HotelOrderPayTypeEnum.fromType((Integer)rightsHotelOrderPO.getPayType()) != HotelOrderPayTypeEnum.WECHAT_PAY) {
            return ResponseUtil.of((SysResponseEnum)SysResponseEnum.RIGHTS_HOTEL_ORDER_WECHAT_PAY_FAILED);
        }
        RightsHotelOrderPaymentResponseVO responseVO = new RightsHotelOrderPaymentResponseVO();
        if (NumberUtil.equals((BigDecimal)BigDecimal.ZERO, (BigDecimal)rightsHotelOrderPO.getPayableAmount())) {
            this.hotelOrderService.paymentSuccess(rightsHotelOrderPO);
        } else {
            PrepareOrderReqVO prepareOrderReqVO = new PrepareOrderReqVO();
            prepareOrderReqVO.setOpenid(requestVO.getOpenId());
            prepareOrderReqVO.setOutTradeNo(rightsHotelOrderPO.getOrderNo());
            prepareOrderReqVO.setAmount(rightsHotelOrderPO.getPayableAmount());
            prepareOrderReqVO.setDescription("\u9152\u5e97\u9884\u8ba2");
            ResponseData prepareOrder = this.paymentComponent.prepareOrder(prepareOrderReqVO);
            AssertUtil.judge((Boolean)ResponseUtil.isSuccess((ResponseData)prepareOrder), (String)"\u83b7\u53d6\u9152\u5e97\u8ba2\u5355\u5fae\u4fe1\u652f\u4ed8\u53c2\u6570\u5931\u8d25!");
            PrepayOrderRespVO prepareOrderData = (PrepayOrderRespVO)prepareOrder.getData();
            BeanUtils.copyProperties((Object)prepareOrderData, (Object)responseVO);
            responseVO.setTimestamp(prepareOrderData.getTimeStamp());
        }
        responseVO.setPayableAmount(rightsHotelOrderPO.getPayableAmount());
        return ResponseUtil.success((Object)responseVO);
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<RightsHotelOrderCancelResponseVO> orderCancel(RightsHotelOrderCancelRequestVO requestVO) {
        RightsHotelOrderPO rightsHotelOrderPO = this.rightsHotelOrderService.detailByCode(requestVO.getRightsHotelOrderCode());
        if (rightsHotelOrderPO == null) {
            return ResponseUtil.of((SysResponseEnum)SysResponseEnum.RIGHTS_HOTEL_ORDER_NOT_EXISTS);
        }
        if (ObjectUtils.notEqual((Object)rightsHotelOrderPO.getMemberCode(), (Object)requestVO.getMemberCode())) {
            return ResponseUtil.of((SysResponseEnum)SysResponseEnum.RIGHTS_HOTEL_ORDER_MEMBER_NOT_MATCH);
        }
        if (!Arrays.asList(HotelOrderStatusEnum.TO_BE_CONFIRMED.getOrderStatus(), HotelOrderStatusEnum.CONFIRMED.getOrderStatus()).contains(rightsHotelOrderPO.getOrderStatus())) {
            return ResponseUtil.of((SysResponseEnum)SysResponseEnum.RIGHTS_HOTEL_ORDER_STATUS_NO_MATCH);
        }
        RightsHotelPO rightsHotelPO = this.rightsHotelService.detailByCode(rightsHotelOrderPO.getRightsHotelCode());
        LocalDate expectedArrivalDate = rightsHotelOrderPO.getExpectedArrivalTime().toLocalDate();
        if (!LocalDateTime.now().isBefore(LocalDateTime.of(expectedArrivalDate, rightsHotelPO.getLatestCancellationTime()))) {
            return ResponseUtil.of((SysResponseEnum)SysResponseEnum.RIGHTS_HOTEL_ORDER_AFTER_LATEST_CANCELLATION_TIME);
        }
        HotelOrderPayTypeEnum payTypeEnum = HotelOrderPayTypeEnum.fromType((Integer)rightsHotelOrderPO.getPayType());
        if (payTypeEnum == HotelOrderPayTypeEnum.WECHAT_PAY) {
            return this.wechatCancel(rightsHotelOrderPO);
        }
        return this.singleCancel(rightsHotelOrderPO);
    }

    @NotNull
    private ResponseData<RightsHotelOrderCancelResponseVO> singleCancel(RightsHotelOrderPO rightsHotelOrderPO) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(RightsHotelOrderPO::getOrderStatus, (Object)HotelOrderStatusEnum.CANCELLED.getOrderStatus())).set(RightsHotelOrderPO::getCancellationType, (Object)HotelOrderCancellationTypeEnum.USER.getCancellationType())).set(RightsHotelOrderPO::getCancellationTime, (Object)LocalDateTime.now())).eq(RightsHotelOrderPO::getRightsHotelOrderCode, (Object)rightsHotelOrderPO.getRightsHotelOrderCode())).in(RightsHotelOrderPO::getOrderStatus, Arrays.asList(HotelOrderStatusEnum.TO_BE_CONFIRMED.getOrderStatus(), HotelOrderStatusEnum.CONFIRMED.getOrderStatus()));
        boolean update = this.rightsHotelOrderService.update((Wrapper)updateWrapper);
        if (update) {
            this.hotelRoomSituationService.addBatchStock(rightsHotelOrderPO.getRightsHotelOrderCode(), HotelRoomSituationOptionTypeEnum.FILED_2);
            this.couponComponent.couponCorrection(rightsHotelOrderPO, Boolean.TRUE);
            this.orderComponent.syncHotelOrderAsync(rightsHotelOrderPO.getRightsHotelOrderCode());
        }
        RightsHotelOrderCancelResponseVO responseVO = new RightsHotelOrderCancelResponseVO();
        responseVO.setOptStatus(update);
        return ResponseUtil.success((Object)responseVO);
    }

    private ResponseData<RightsHotelOrderCancelResponseVO> wechatCancel(RightsHotelOrderPO rightsHotelOrderPO) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(RightsHotelOrderPO::getOrderStatus, (Object)HotelOrderStatusEnum.CANCELLED.getOrderStatus())).set(RightsHotelOrderPO::getRefundStatus, (Object)HotelOrderRefundStatusEnum.REFUND_PROCESSING.getRefundStatus())).set(RightsHotelOrderPO::getCancellationType, (Object)HotelOrderCancellationTypeEnum.USER.getCancellationType())).set(RightsHotelOrderPO::getCancellationTime, (Object)LocalDateTime.now())).eq(RightsHotelOrderPO::getRightsHotelOrderCode, (Object)rightsHotelOrderPO.getRightsHotelOrderCode())).in(RightsHotelOrderPO::getOrderStatus, Arrays.asList(HotelOrderStatusEnum.TO_BE_CONFIRMED.getOrderStatus()));
        boolean update = this.rightsHotelOrderService.update((Wrapper)updateWrapper);
        if (update) {
            if (NumberUtil.equals((BigDecimal)BigDecimal.ZERO, (BigDecimal)rightsHotelOrderPO.getPayableAmount())) {
                this.hotelOrderService.refundSuccess(rightsHotelOrderPO);
            } else {
                RefundOrderReqVO refundOrderReqVO = new RefundOrderReqVO();
                refundOrderReqVO.setOutTradeNo(rightsHotelOrderPO.getOrderNo());
                refundOrderReqVO.setRefundAmount(rightsHotelOrderPO.getPayableAmount());
                refundOrderReqVO.setOrderAmount(rightsHotelOrderPO.getPayableAmount());
                refundOrderReqVO.setOutRefundNo(String.format("R%s", refundOrderReqVO.getOutTradeNo()));
                ResponseData responseData = this.paymentComponent.refundOrder(refundOrderReqVO);
                AssertUtil.judge((Boolean)ResponseUtil.isSuccess((ResponseData)responseData), (String)String.format("\u9152\u5e97\u8ba2\u5355:%s\u53d1\u8d77\u9000\u6b3e\u5931\u8d25", rightsHotelOrderPO.getOrderNo()));
                this.orderComponent.syncHotelOrderAsync(rightsHotelOrderPO.getRightsHotelOrderCode());
            }
        }
        RightsHotelOrderCancelResponseVO responseVO = new RightsHotelOrderCancelResponseVO();
        responseVO.setOptStatus(update);
        return ResponseUtil.success((Object)responseVO);
    }

    public ResponseData<RightsHotelOrderDetailResponseVO> orderDetail(RightsHotelOrderDetailRequestVO requestVO) {
        RightsHotelOrderPO rightsHotelOrderPO = null;
        rightsHotelOrderPO = StringUtils.isNotBlank((CharSequence)requestVO.getOrderNo()) ? this.rightsHotelOrderService.detailByOrderNo(requestVO.getOrderNo()) : this.rightsHotelOrderService.detailByCode(requestVO.getRightsHotelOrderCode());
        if (rightsHotelOrderPO == null) {
            return ResponseUtil.of((SysResponseEnum)SysResponseEnum.RIGHTS_HOTEL_ORDER_NOT_EXISTS);
        }
        if (ObjectUtils.notEqual((Object)rightsHotelOrderPO.getMemberCode(), (Object)requestVO.getMemberCode())) {
            return ResponseUtil.of((SysResponseEnum)SysResponseEnum.RIGHTS_HOTEL_ORDER_MEMBER_NOT_MATCH);
        }
        List rightsHotelOrderDetailPOS = this.rightsHotelOrderDetailService.listByRightsHotelOrderCode(rightsHotelOrderPO.getRightsHotelOrderCode());
        RightsHotelOrderDetailResponseVO responseVO = this.getRightsHotelOrderDetailResponseVO(rightsHotelOrderPO, rightsHotelOrderDetailPOS);
        if (HotelOrderStatusEnum.codeByOrderStatus((Integer)rightsHotelOrderPO.getOrderStatus()) == HotelOrderStatusEnum.PENDING_PAYMENT) {
            LocalDateTime paymentDeadline = rightsHotelOrderPO.getCreateDate().plusMinutes(15L);
            responseVO.setPaymentDeadline(paymentDeadline);
            responseVO.setPaymentDeadlineSeconds(paymentDeadline.toEpochSecond(ZoneOffset.of("+8")) - LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8")));
        }
        RightsHotelPO rightsHotelPO = this.rightsHotelService.detailByCode(rightsHotelOrderPO.getRightsHotelCode());
        LocalDate expectedArrivalDate = rightsHotelOrderPO.getExpectedArrivalTime().toLocalDate();
        responseVO.setLatestCancellationDateTime(LocalDateTime.of(expectedArrivalDate, rightsHotelPO.getLatestCancellationTime()));
        responseVO.setLatestCancellationTime(rightsHotelPO.getLatestCancellationTime());
        responseVO.setHotelPhone(rightsHotelPO.getHotelPhone());
        return ResponseUtil.success((Object)responseVO);
    }

    public ResponseData<Boolean> updateEvaluationStatus(AddEvaluateMq addEvaluateMq) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(RightsHotelOrderPO::getEvaluationStatus, (Object)2)).eq(RightsHotelOrderPO::getOrderNo, (Object)addEvaluateMq.getOrderNo());
        boolean update = this.rightsHotelOrderService.update((Wrapper)updateWrapper);
        return ResponseUtil.success((Object)update);
    }

    public HotelOrderMobileServiceImpl(IRightsHotelRoomTypeService rightsHotelRoomTypeService, IRightsHotelRoomSituationService rightsHotelRoomSituationService, IRightsHotelService rightsHotelService, IRightsHotelOrderService rightsHotelOrderService, IRightsHotelOrderDetailService rightsHotelOrderDetailService, IRightsHotelRoomSituationLogService rightsHotelRoomSituationLogService, HotelRoomSituationService hotelRoomSituationService, PaymentComponent paymentComponent, OrderComponent orderComponent, CouponComponent couponComponent, MerchantComponent merchantComponent, HotelOrderServiceImpl hotelOrderService) {
        this.rightsHotelRoomTypeService = rightsHotelRoomTypeService;
        this.rightsHotelRoomSituationService = rightsHotelRoomSituationService;
        this.rightsHotelService = rightsHotelService;
        this.rightsHotelOrderService = rightsHotelOrderService;
        this.rightsHotelOrderDetailService = rightsHotelOrderDetailService;
        this.rightsHotelRoomSituationLogService = rightsHotelRoomSituationLogService;
        this.hotelRoomSituationService = hotelRoomSituationService;
        this.paymentComponent = paymentComponent;
        this.orderComponent = orderComponent;
        this.couponComponent = couponComponent;
        this.merchantComponent = merchantComponent;
        this.hotelOrderService = hotelOrderService;
    }
}

