/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.service.impl;

import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.bizvane.basic.feign.feign.BasicMerchantRpcFeign;
import com.bizvane.basic.feign.feign.SerialNumberServiceFeign;
import com.bizvane.basic.feign.model.vo.TBasicMerchantVo;
import com.bizvane.members.feign.model.bo.OrderListRequestParam;
import com.bizvane.members.feign.service.OrderFeign;
import com.bizvane.rights.api.service.EvaluateService;
import com.bizvane.rights.api.service.ServiceRecordMobileService;
import com.bizvane.rights.domain.enums.ServiceTypeEnum;
import com.bizvane.rights.domain.model.entity.RightEvaluatePO;
import com.bizvane.rights.domain.model.entity.RightsServiceRecordPO;
import com.bizvane.rights.domain.service.IRightsEvaluateService;
import com.bizvane.rights.domain.service.IRightsServiceRecordService;
import com.bizvane.rights.domain.util.ResponseUtil;
import com.bizvane.rights.enums.EvaluateLabelTypeEnum;
import com.bizvane.rights.mq.AddEvaluateMq;
import com.bizvane.rights.vo.evaluate.RightEvaluateAddRequestVO;
import com.bizvane.rights.vo.evaluate.RightEvaluateAddResponseVO;
import com.bizvane.rights.vo.evaluate.RightEvaluateRequestVO;
import com.bizvane.rights.vo.evaluate.RightEvaluateResponseVO;
import com.bizvane.rights.vo.service.RightsServiceRecordUpdateReviewsStatusVO;
import com.bizvane.utils.exception.BizException;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class EvaluateServiceImpl
implements EvaluateService {
    private static final Logger log = LoggerFactory.getLogger(EvaluateServiceImpl.class);
    private final IRightsEvaluateService rightsEvaluateService;
    @Autowired
    private RocketMQTemplate rocketMQTemplate;
    @Autowired
    private OrderFeign orderFeign;
    @Autowired
    private SerialNumberServiceFeign serialNumberServiceFeign;
    @Autowired
    private IRightsServiceRecordService serviceRecordService;
    @Autowired
    private BasicMerchantRpcFeign basicMerchantRpcFeign;
    @Autowired
    private ServiceRecordMobileService serviceRecordMobileService;

    public ResponseData<PageInfo<RightEvaluateResponseVO>> page(RightEvaluateRequestVO requestVO) {
        IPage pageList = this.rightsEvaluateService.pageList(requestVO);
        if (pageList == null || pageList.getRecords().isEmpty()) {
            return ResponseUtil.success((Object)new PageInfo());
        }
        pageList.getRecords().forEach(item -> {
            String desc;
            if (item.getEvaluateType() != null && (desc = EvaluateLabelTypeEnum.fromCode((Integer)item.getEvaluateType()).getDesc()) != null) {
                item.setEvaluateDesc(desc);
            }
        });
        PageInfo pageInfo = new PageInfo(requestVO.getPageNum().intValue(), requestVO.getPageSize().intValue(), pageList.getTotal(), pageList.getRecords());
        return ResponseUtil.success((Object)pageInfo);
    }

    public ResponseData<RightEvaluateAddResponseVO> add(RightEvaluateAddRequestVO requestVO) {
        List list = this.rightsEvaluateService.selectEvaluateByOrderNo(requestVO.getOrderNo());
        if (!list.isEmpty()) {
            throw new BizException("\u8be5\u8ba2\u5355\u5df2\u8bc4\u4ef7");
        }
        Integer satisfactionDegree = requestVO.getSatisfactionDegree();
        if (satisfactionDegree != null && satisfactionDegree < 1 || satisfactionDegree > 5) {
            throw new BizException("\u6ee1\u610f\u5ea6\u8bc4\u5206\u5fc5\u987b\u57281\u52305\u4e4b\u95f4");
        }
        RightEvaluatePO rightEvaluatePO = this.packageRightEvaluatePo(requestVO);
        if (EvaluateLabelTypeEnum.LUGGAGE_TO_DOOR_SERVICE.getCode().equals(requestVO.getEvaluateType()) || EvaluateLabelTypeEnum.BARRIER_FREE_PARKING_SERVICE.getCode().equals(requestVO.getEvaluateType()) || EvaluateLabelTypeEnum.SPECIAL_TRAVELER_SERVICE.getCode().equals(requestVO.getEvaluateType())) {
            this.serverEvaluate(requestVO, rightEvaluatePO);
        } else {
            this.orderEvaluate(requestVO, rightEvaluatePO);
        }
        boolean save = this.rightsEvaluateService.save((Object)rightEvaluatePO);
        RightEvaluateAddResponseVO responseVO = new RightEvaluateAddResponseVO();
        AddEvaluateMq evaluateMq = AddEvaluateMq.builder().rightsEvaluateCode(rightEvaluatePO.getRightsEvaluateCode()).orderNo(requestVO.getOrderNo()).evaluateType(requestVO.getEvaluateType()).memberCode(requestVO.getMemberCode()).orderCode(rightEvaluatePO.getOrderCode()).build();
        log.info("\u65b0\u589e\u8bc4\u4ef7MQ\u5165\u53c2:{}", (Object)JacksonUtil.bean2Json((Object)evaluateMq));
        try {
            this.rocketMQTemplate.send(Destination.builder().topic("add_evaluate_topic").build(), (Object)evaluateMq);
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u8bc4\u4ef7MQ\u5f02\u5e38:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
        responseVO.setOptStatus(save);
        return ResponseUtil.success((Object)responseVO);
    }

    public ResponseData<RightEvaluateResponseVO> detailByTypeAndOrderNo(RightEvaluateRequestVO requestVO) {
        IPage pageList = this.rightsEvaluateService.pageList(requestVO);
        if (CollectionUtils.isEmpty((Collection)pageList.getRecords())) {
            return ResponseUtil.success(null);
        }
        RightEvaluateResponseVO rightEvaluateResponseVO = (RightEvaluateResponseVO)pageList.getRecords().get(0);
        return ResponseUtil.success((Object)rightEvaluateResponseVO);
    }

    private void orderEvaluate(RightEvaluateAddRequestVO requestVO, RightEvaluatePO rightEvaluatePO) {
        OrderListRequestParam orderListRequestParam = new OrderListRequestParam();
        orderListRequestParam.setOrderNo(requestVO.getOrderNo());
        orderListRequestParam.setOrderType(requestVO.getEvaluateType());
        ResponseData detail = this.orderFeign.list(orderListRequestParam);
        if (null == detail.getData()) {
            throw new BizException("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        log.info("orderFeign.list.{},\u53c2\u6570\uff1a{}", (Object)JacksonUtil.bean2Json((Object)detail), (Object)JacksonUtil.bean2Json((Object)orderListRequestParam));
        ((PageInfo)detail.getData()).getList().forEach(item -> {
            rightEvaluatePO.setOrderCode(item.getMbrOrderCode());
            rightEvaluatePO.setMerchantCode(item.getMerchantNo());
            rightEvaluatePO.setBusinessCode(item.getIndustryNo());
        });
    }

    private void serverEvaluate(RightEvaluateAddRequestVO requestVO, RightEvaluatePO rightEvaluatePO) {
        Integer serverType = EvaluateServiceImpl.convertType((RightEvaluateAddRequestVO)requestVO);
        RightsServiceRecordPO rightsServiceRecordPO = this.serviceRecordService.detailByServiceTypeAndReservationRecordNo(serverType, requestVO.getOrderNo());
        log.info("\u670d\u52a1\u4e3b\u8868\u8fd4\u56de\u6570\u636e\uff1a{}", (Object)rightsServiceRecordPO);
        if (null == rightsServiceRecordPO) {
            throw new BizException("\u670d\u52a1\u4e0d\u5b58\u5728");
        }
        rightEvaluatePO.setOrderCode(rightsServiceRecordPO.getServiceCode());
        rightEvaluatePO.setMerchantCode(rightsServiceRecordPO.getMerchantNo());
        TBasicMerchantVo merchantVo = new TBasicMerchantVo();
        merchantVo.setMerchantCode(rightsServiceRecordPO.getMerchantNo());
        ResponseData detail = this.basicMerchantRpcFeign.detail(merchantVo);
        rightEvaluatePO.setBusinessCode(((TBasicMerchantVo)detail.getData()).getBusinessCode());
        RightsServiceRecordUpdateReviewsStatusVO rightsServiceRecordUpdateReviewsStatusVO = new RightsServiceRecordUpdateReviewsStatusVO();
        rightsServiceRecordUpdateReviewsStatusVO.setServiceType(rightsServiceRecordPO.getServiceType());
        rightsServiceRecordUpdateReviewsStatusVO.setReservationRecordNo(rightsServiceRecordPO.getReservationRecordNo());
        ResponseData updateReviewStatus = this.serviceRecordMobileService.updateReviewStatus(rightsServiceRecordUpdateReviewsStatusVO);
        log.info("serviceRecordMobileService.updateReviewStatus:{}", (Object)JSON.toJSONString((Object)updateReviewStatus));
    }

    @NotNull
    private RightEvaluatePO packageRightEvaluatePo(RightEvaluateAddRequestVO requestVO) {
        RightEvaluatePO rightEvaluatePO = new RightEvaluatePO();
        rightEvaluatePO.setCreateUserCode(requestVO.getOptUserCode());
        rightEvaluatePO.setCreateUserName(requestVO.getOptUserName());
        rightEvaluatePO.setCreateDate(LocalDateTime.now());
        rightEvaluatePO.setEvaluateType(requestVO.getEvaluateType());
        rightEvaluatePO.setSuggest(requestVO.getSuggest());
        rightEvaluatePO.setMemberCardNo(requestVO.getMemberCardNo());
        rightEvaluatePO.setMemberCode(requestVO.getMemberCode());
        rightEvaluatePO.setRightsEvaluateLabelCode(requestVO.getRightsEvaluateLabelCode());
        rightEvaluatePO.setSatisfactionDegree(requestVO.getSatisfactionDegree());
        rightEvaluatePO.setOrderNo(requestVO.getOrderNo());
        ResponseData longResponseData = this.serialNumberServiceFeign.generateId();
        log.info("generateId: {}", (Object)JacksonUtil.bean2Json((Object)longResponseData));
        if (longResponseData.getData() == null) {
            throw new BizException("\u751f\u6210code\u5931\u8d25");
        }
        rightEvaluatePO.setRightsEvaluateCode(((Long)longResponseData.getData()).toString());
        rightEvaluatePO.setEvaluateDate(LocalDateTime.now());
        return rightEvaluatePO;
    }

    @Nullable
    private static Integer convertType(RightEvaluateAddRequestVO requestVO) {
        Integer serverType = null;
        if (EvaluateLabelTypeEnum.LUGGAGE_TO_DOOR_SERVICE.getCode().equals(requestVO.getEvaluateType())) {
            serverType = ServiceTypeEnum.THREE.getServiceType();
        }
        if (EvaluateLabelTypeEnum.BARRIER_FREE_PARKING_SERVICE.getCode().equals(requestVO.getEvaluateType())) {
            serverType = ServiceTypeEnum.TWO.getServiceType();
        }
        if (EvaluateLabelTypeEnum.SPECIAL_TRAVELER_SERVICE.getCode().equals(requestVO.getEvaluateType())) {
            serverType = ServiceTypeEnum.ONE.getServiceType();
        }
        return serverType;
    }

    public EvaluateServiceImpl(IRightsEvaluateService rightsEvaluateService) {
        this.rightsEvaluateService = rightsEvaluateService;
    }
}

