/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.controller.mobile;

import com.bizvane.members.feign.model.vo.CouponEntityListResponseParam;
import com.bizvane.rights.api.service.HotelOrderMobileService;
import com.bizvane.rights.api.service.component.OrderTemporaryComponent;
import com.bizvane.rights.domain.util.AssertUtil;
import com.bizvane.rights.enums.HotelOrderPayTypeEnum;
import com.bizvane.rights.feign.HotelOrderMobileFeign;
import com.bizvane.rights.vo.hotel.order.mobile.RightsHotelOrderCancelRequestVO;
import com.bizvane.rights.vo.hotel.order.mobile.RightsHotelOrderCancelResponseVO;
import com.bizvane.rights.vo.hotel.order.mobile.RightsHotelOrderDetailRequestVO;
import com.bizvane.rights.vo.hotel.order.mobile.RightsHotelOrderDetailResponseVO;
import com.bizvane.rights.vo.hotel.order.mobile.RightsHotelOrderPaymentRequestVO;
import com.bizvane.rights.vo.hotel.order.mobile.RightsHotelOrderPaymentResponseVO;
import com.bizvane.rights.vo.hotel.order.mobile.RightsHotelOrderRequestVO;
import com.bizvane.rights.vo.hotel.order.mobile.RightsHotelOrderResponseVO;
import com.bizvane.rights.vo.hotel.order.mobile.RightsHotelPreOrderRequestVO;
import com.bizvane.rights.vo.hotel.order.mobile.RightsHotelPreOrderResponseVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"hotelOrderMobile"})
@Api(value="\u9152\u5e97\u8ba2\u5355mobile", tags={"\u9152\u5e97\u8ba2\u5355mobile"})
public class HotelOrderMobileController
implements HotelOrderMobileFeign {
    private final HotelOrderMobileService hotelOrderMobileService;
    private final OrderTemporaryComponent orderComponent;

    public ResponseData<RightsHotelPreOrderResponseVO> preOrder(@RequestBody RightsHotelPreOrderRequestVO requestVO) {
        AssertUtil.judge((Boolean)(requestVO.getQuantity() > 0 ? 1 : 0), (String)"\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e1");
        AssertUtil.notNull((String)requestVO.getMemberCode(), (String)"memberCode\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getRightsHotelRoomTypeCode(), (String)"rightsHotelRoomTypeCode\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((Object)requestVO.getStartDate(), (String)"startDate\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((Object)requestVO.getEndDate(), (String)"endDate\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.judge((Boolean)requestVO.getStartDate().isBefore(requestVO.getEndDate()), (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7b49\u4e8e\u7ed3\u675f\u65f6\u95f4");
        return this.hotelOrderMobileService.preOrder(requestVO);
    }

    public ResponseData<PageInfo<CouponEntityListResponseParam>> listAvailable(@RequestBody RightsHotelPreOrderRequestVO requestVO) {
        AssertUtil.judge((Boolean)(requestVO.getQuantity() > 0 ? 1 : 0), (String)"\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e1");
        AssertUtil.notNull((String)requestVO.getMemberCode(), (String)"memberCode\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getRightsHotelRoomTypeCode(), (String)"rightsHotelRoomTypeCode\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((Object)requestVO.getStartDate(), (String)"startDate\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((Object)requestVO.getEndDate(), (String)"endDate\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.judge((Boolean)requestVO.getStartDate().isBefore(requestVO.getEndDate()), (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7b49\u4e8e\u7ed3\u675f\u65f6\u95f4");
        return this.hotelOrderMobileService.listAvailable(requestVO);
    }

    public ResponseData<RightsHotelOrderResponseVO> order(@RequestBody RightsHotelOrderRequestVO requestVO) {
        AssertUtil.judge((Boolean)(requestVO.getQuantity() > 0 ? 1 : 0), (String)"\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e1");
        AssertUtil.notNull((String)requestVO.getMemberCode(), (String)"memberCode\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getRightsHotelRoomTypeCode(), (String)"rightsHotelRoomTypeCode\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((Object)requestVO.getStartDate(), (String)"startDate\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((Object)requestVO.getEndDate(), (String)"endDate\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.judge((Boolean)requestVO.getStartDate().isBefore(requestVO.getEndDate()), (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7b49\u4e8e\u7ed3\u675f\u65f6\u95f4");
        AssertUtil.notNull((Object)HotelOrderPayTypeEnum.fromType((Integer)requestVO.getPayType()), (String)"payType\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((Object)requestVO.getPayType(), (String)"payType\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getReservationName(), (String)"reservationName\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getReservationPhone(), (String)"reservationPhone\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((Object)requestVO.getExpectedArrivalTime(), (String)"expectedArrivalTime\u4e0d\u80fd\u4e3a\u7a7a");
        return this.hotelOrderMobileService.order(requestVO);
    }

    public ResponseData<RightsHotelOrderPaymentResponseVO> orderPayment(RightsHotelOrderPaymentRequestVO requestVO) {
        AssertUtil.notNull((String)requestVO.getRightsHotelOrderCode(), (String)"rightsHotelOrderCode\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getOpenId(), (String)"openId\u4e0d\u80fd\u4e3a\u7a7a");
        return this.hotelOrderMobileService.orderPayment(requestVO);
    }

    public ResponseData<RightsHotelOrderCancelResponseVO> orderCancel(@RequestBody RightsHotelOrderCancelRequestVO requestVO) {
        AssertUtil.notNull((String)requestVO.getRightsHotelOrderCode(), (String)"rightsHotelOrderCode\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getMemberCode(), (String)"memberCode\u4e0d\u80fd\u4e3a\u7a7a");
        return this.hotelOrderMobileService.orderCancel(requestVO);
    }

    public ResponseData<RightsHotelOrderDetailResponseVO> orderDetail(@RequestBody RightsHotelOrderDetailRequestVO requestVO) {
        AssertUtil.judge((Boolean)(!StringUtils.isAllBlank((CharSequence[])new CharSequence[]{requestVO.getRightsHotelOrderCode(), requestVO.getOrderNo()}) ? 1 : 0), (String)"rightsHotelOrderCode\u548corderNo\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getMemberCode(), (String)"memberCode\u4e0d\u80fd\u4e3a\u7a7a");
        return this.hotelOrderMobileService.orderDetail(requestVO);
    }

    public HotelOrderMobileController(HotelOrderMobileService hotelOrderMobileService, OrderTemporaryComponent orderComponent) {
        this.hotelOrderMobileService = hotelOrderMobileService;
        this.orderComponent = orderComponent;
    }
}

