/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.controller;

import com.bizvane.rights.api.service.impl.StewardService;
import com.bizvane.rights.domain.util.AssertUtil;
import com.bizvane.rights.feign.StewardServiceFeign;
import com.bizvane.rights.vo.steward.StatusReqVO;
import com.bizvane.rights.vo.steward.StewardQueryReqVO;
import com.bizvane.rights.vo.steward.StewardServiceDescriptionReqRespVO;
import com.bizvane.rights.vo.steward.StewardServiceReqRespVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/stewardService"})
@Api(value="\u7ba1\u5bb6\u670d\u52a1\u8bb0\u5f55", tags={"\u7ba1\u5bb6\u670d\u52a1\u8bb0\u5f55"})
public class StewardServiceController
implements StewardServiceFeign {
    @Autowired
    private StewardService stewardService;

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/addOrUpdate"})
    public ResponseData<Boolean> addOrUpdate(@RequestBody StewardServiceReqRespVO stewardServiceReqRespVO) {
        AssertUtil.notNull((String)stewardServiceReqRespVO.getServiceNo(), (String)"\u8bf7\u8f93\u5165\u670d\u52a1\u4ee3\u7801");
        AssertUtil.notNull((String)stewardServiceReqRespVO.getAirportCode(), (String)"\u8bf7\u9009\u62e9\u670d\u52a1\u673a\u573a\u4e0d");
        AssertUtil.notNull((Object)stewardServiceReqRespVO.getOriginalPrice(), (String)"\u8bf7\u8f93\u5165\u670d\u52a1\u539f\u4ef7");
        AssertUtil.notNull((Object)stewardServiceReqRespVO.getServiceType(), (String)"\u8bf7\u9009\u62e9\u670d\u52a1\u7c7b\u578b");
        AssertUtil.notNull((Object)stewardServiceReqRespVO.getCarServer(), (String)"\u8bf7\u9009\u62e9\u662f\u5426\u5305\u542b\u8f66\u8f86\u670d\u52a1");
        return this.stewardService.addOrUpdate(stewardServiceReqRespVO);
    }

    @ApiOperation(value="\u542f\u7528/\u7981\u7528")
    @PostMapping(value={"/changeStatus"})
    public ResponseData<Boolean> changeStatus(@RequestBody StatusReqVO statusReqVO) {
        AssertUtil.notNull((String)statusReqVO.getStewardServiceCode(), (String)"\u673a\u573a\u7ba1\u5bb6\u670d\u52a1code\u4e3a\u7a7a");
        AssertUtil.notNull((Object)statusReqVO.getStatus(), (String)"\u8bf7\u9009\u62e9\u542f\u7528/\u7981\u7528");
        AssertUtil.judge((Boolean)(1 == statusReqVO.getStatus() || 2 == statusReqVO.getStatus() ? 1 : 0), (String)"\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u542f\u7528/\u7981\u7528\u72b6\u6001");
        return this.stewardService.changeStatus(statusReqVO);
    }

    @ApiOperation(value="\u4fdd\u5b58\u7ba1\u5bb6\u670d\u52a1\u4ecb\u7ecd")
    @PostMapping(value={"/saveDescription"})
    public ResponseData<Boolean> saveDescription(@RequestBody StewardServiceDescriptionReqRespVO requestVO) {
        AssertUtil.notNull((String)requestVO.getTelePhone(), (String)"\u8bf7\u8f93\u5165\u670d\u52a1\u7535\u8bdd");
        return this.stewardService.saveDescription(requestVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u5217\u8868")
    @PostMapping(value={"/pageList"})
    public ResponseData<PageInfo<StewardServiceReqRespVO>> pageList(@RequestBody StewardQueryReqVO stewardServiceVO) {
        return this.stewardService.pageList(stewardServiceVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u7ba1\u5bb6\u670d\u52a1\u4ecb\u7ecd")
    @PostMapping(value={"/detailDescription"})
    public ResponseData<StewardServiceDescriptionReqRespVO> detailDescription() {
        return this.stewardService.detailDescription();
    }

    @ApiOperation(value="\u83b7\u53d6\u7ba1\u5bb6\u670d\u52a1\u660e\u7ec6")
    @PostMapping(value={"/detailService"})
    public ResponseData<StewardServiceReqRespVO> detailService(@RequestBody StatusReqVO statusReqVO) {
        return this.stewardService.detailService(statusReqVO);
    }

    public StewardServiceController(StewardService stewardService) {
        this.stewardService = stewardService;
    }
}

