/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.controller;

import com.bizvane.rights.api.service.ParkingOrderService;
import com.bizvane.rights.api.service.component.OrderComponent;
import com.bizvane.rights.domain.util.ResponseUtil;
import com.bizvane.rights.feign.ParkingOrderFeign;
import com.bizvane.rights.vo.parking.order.RightsParkingOrderSaveRequestVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"parkingOrder"})
@Api(value="\u505c\u8f66\u8bb0\u5f55", tags={"\u505c\u8f66\u8bb0\u5f55"})
public class ParkingOrderController
implements ParkingOrderFeign {
    private final ParkingOrderService parkingOrderService;
    private final OrderComponent orderComponent;

    public ResponseData<Boolean> addOrUpdate(@RequestBody RightsParkingOrderSaveRequestVO requestVO) {
        ResponseData responseData = this.parkingOrderService.addOrUpdate(requestVO);
        if (ResponseUtil.isSuccess((ResponseData)responseData) && ((Boolean)responseData.getData()).booleanValue()) {
            this.orderComponent.syncParkingOrderAsync(requestVO.getParkingRecordNo());
        }
        return responseData;
    }

    public ParkingOrderController(ParkingOrderService parkingOrderService, OrderComponent orderComponent) {
        this.parkingOrderService = parkingOrderService;
        this.orderComponent = orderComponent;
    }
}

