/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.controller;

import com.bizvane.rights.api.service.HotelRoomSituationService;
import com.bizvane.rights.domain.util.AssertUtil;
import com.bizvane.rights.feign.HotelRoomSituationFeign;
import com.bizvane.rights.vo.OptUserVO;
import com.bizvane.rights.vo.hotel.roomsituation.RightsHotelRoomSituationBatchUpdateRequestVO;
import com.bizvane.rights.vo.hotel.roomsituation.RightsHotelRoomSituationDaysConditionRequestVO;
import com.bizvane.rights.vo.hotel.roomsituation.RightsHotelRoomSituationDaysConditionResponseVO;
import com.bizvane.rights.vo.hotel.roomsituation.RightsHotelRoomSituationDaysRequestVO;
import com.bizvane.utils.responseinfo.ResponseData;
import com.google.common.base.Stopwatch;
import io.swagger.annotations.Api;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"hotelRoomSituation"})
@Api(value="\u9152\u5e97\u623f\u6001", tags={"\u9152\u5e97\u623f\u6001"})
public class HotelRoomSituationController
implements HotelRoomSituationFeign {
    private static final Logger log = LoggerFactory.getLogger(HotelRoomSituationController.class);
    private final HotelRoomSituationService hotelRoomSituationService;

    public ResponseData<RightsHotelRoomSituationDaysConditionResponseVO> listRoomSituationByDaysCondition(@RequestBody RightsHotelRoomSituationDaysConditionRequestVO requestVO) {
        Stopwatch started = Stopwatch.createStarted();
        ResponseData responseData = this.hotelRoomSituationService.listRoomSituationByDaysCondition(requestVO);
        started.stop();
        log.info("\u82b1\u8d39\u65f6\u95f4:{}\u6beb\u79d2", (Object)started.elapsed(TimeUnit.MILLISECONDS));
        return responseData;
    }

    public ResponseData<RightsHotelRoomSituationDaysConditionResponseVO> detailRoomSituationByDays(@RequestBody RightsHotelRoomSituationDaysRequestVO requestVO) {
        return this.hotelRoomSituationService.detailRoomSituationByDays(requestVO);
    }

    public ResponseData batchUpdateRoomSituation(@RequestBody RightsHotelRoomSituationBatchUpdateRequestVO requestVO) {
        AssertUtil.notNull((String)requestVO.getRightsHotelCode(), (String)"\u9152\u5e97\u4e3b\u4f53code\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notEmpty((Collection)requestVO.getRightsHotelRoomTypeCodeList(), (String)"\u9152\u5e97\u623f\u578bcode\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((Object)requestVO.getStartDate(), (String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((Object)requestVO.getEndDate(), (String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((Object)requestVO.getTotalStock(), (String)"\u5e93\u5b58\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.judge((Boolean)(requestVO.getStartDate().isEqual(requestVO.getEndDate()) || requestVO.getStartDate().isBefore(requestVO.getEndDate()) ? 1 : 0), (String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f00\u59cb\u65e5\u671f");
        AssertUtil.optUserNotNull((OptUserVO)requestVO);
        return this.hotelRoomSituationService.batchUpdateRoomSituation(requestVO);
    }

    public HotelRoomSituationController(HotelRoomSituationService hotelRoomSituationService) {
        this.hotelRoomSituationService = hotelRoomSituationService;
    }
}

