/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.controller;

import com.bizvane.rights.api.service.HotelService;
import com.bizvane.rights.domain.util.AssertUtil;
import com.bizvane.rights.domain.util.ResponseUtil;
import com.bizvane.rights.feign.HotelFeign;
import com.bizvane.rights.vo.OptUserVO;
import com.bizvane.rights.vo.hotel.RightsHotelAddRequestVO;
import com.bizvane.rights.vo.hotel.RightsHotelAddResponseVO;
import com.bizvane.rights.vo.hotel.RightsHotelConditionRequestVO;
import com.bizvane.rights.vo.hotel.RightsHotelDetailResponseVO;
import com.bizvane.rights.vo.hotel.RightsHotelUpdateRequestVO;
import com.bizvane.rights.vo.hotel.RightsHotelUpdateResponseVO;
import com.bizvane.rights.vo.hotel.RightsHotelUpdateStatusRequestVO;
import com.bizvane.rights.vo.hotel.RightsHotelUpdateStatusResponseVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import java.util.Collection;
import java.util.List;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"hotel"})
@Api(value="\u9152\u5e97\u4e3b\u4f53", tags={"\u9152\u5e97\u4e3b\u4f53"})
public class HotelController
implements HotelFeign {
    private final HotelService hotelService;

    public ResponseData<RightsHotelDetailResponseVO> detail(@RequestParam(value="rightsHotelCode") String rightsHotelCode, @RequestParam(value="orgCodeList") List<String> orgCode) {
        AssertUtil.notNull((String)rightsHotelCode, (String)"\u9152\u5e97\u4e3b\u4f53code\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull(orgCode, (String)"\u7ec4\u7ec7code\u4e0d\u80fd\u4e3a\u7a7a");
        RightsHotelDetailResponseVO detail = this.hotelService.detail(rightsHotelCode, orgCode);
        return ResponseUtil.success((Object)detail);
    }

    public ResponseData<List<RightsHotelDetailResponseVO>> listAll(@RequestParam(value="orgCodeList") List<String> orgCodeList) {
        AssertUtil.notEmpty(orgCodeList, (String)"\u7ec4\u7ec7codeList\u4e0d\u80fd\u4e3a\u7a7a");
        List responseVOList = this.hotelService.listAll(orgCodeList);
        return ResponseUtil.success((Object)responseVOList);
    }

    public ResponseData<List<RightsHotelDetailResponseVO>> listByCondition(@RequestBody RightsHotelConditionRequestVO requestVO) {
        AssertUtil.notEmpty((Collection)requestVO.getOrgCodeList(), (String)"\u7ec4\u7ec7codeList\u4e0d\u80fd\u4e3a\u7a7a");
        List responseVOList = this.hotelService.listByCondition(requestVO);
        return ResponseUtil.success((Object)responseVOList);
    }

    public ResponseData<RightsHotelAddResponseVO> add(@RequestBody RightsHotelAddRequestVO requestVO) {
        AssertUtil.optUserNotNull((OptUserVO)requestVO);
        AssertUtil.notNull((String)requestVO.getHotelName(), (String)"\u9152\u5e97\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getHotelCode(), (String)"\u9152\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getHotelPhone(), (String)"\u9152\u5e97\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getHotelAddress(), (String)"\u9152\u5e97\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getMainImage(), (String)"\u9152\u5e97\u4e3b\u56fe\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getOtherImage(), (String)"\u9152\u5e97\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getHotelSummary(), (String)"\u9152\u5e97\u7b80\u4ecb\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getHotelIntroduction(), (String)"\u9152\u5e97\u4ecb\u7ecd\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getHotelAgreement(), (String)"\u9152\u5e97\u5165\u4f4f\u534f\u8bae\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getOrgCode(), (String)"\u7ec4\u7ec7code\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((Object)requestVO.getLatestCancellationTime(), (String)"\u9152\u5e97\u6700\u665a\u53d6\u6d88\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        return this.hotelService.add(requestVO);
    }

    public ResponseData<RightsHotelUpdateResponseVO> update(@RequestBody RightsHotelUpdateRequestVO requestVO) {
        AssertUtil.optUserNotNull((OptUserVO)requestVO);
        AssertUtil.notNull((String)requestVO.getHotelName(), (String)"\u9152\u5e97\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getHotelCode(), (String)"\u9152\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getHotelPhone(), (String)"\u9152\u5e97\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getHotelAddress(), (String)"\u9152\u5e97\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getMainImage(), (String)"\u9152\u5e97\u4e3b\u56fe\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getOtherImage(), (String)"\u9152\u5e97\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getHotelSummary(), (String)"\u9152\u5e97\u7b80\u4ecb\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getHotelIntroduction(), (String)"\u9152\u5e97\u4ecb\u7ecd\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getHotelAgreement(), (String)"\u9152\u5e97\u5165\u4f4f\u534f\u8bae\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getRightsHotelCode(), (String)"\u9152\u5e97\u4e3b\u4f53code\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notEmpty((Collection)requestVO.getOrgCodeList(), (String)"\u7ec4\u7ec7codeList\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((Object)requestVO.getLatestCancellationTime(), (String)"\u9152\u5e97\u6700\u665a\u53d6\u6d88\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        return this.hotelService.update(requestVO);
    }

    public ResponseData<RightsHotelUpdateStatusResponseVO> updateEnableStatus(@RequestBody RightsHotelUpdateStatusRequestVO requestVO) {
        AssertUtil.optUserNotNull((OptUserVO)requestVO);
        AssertUtil.notNull((String)requestVO.getRightsHotelCode(), (String)"\u9152\u5e97\u4e3b\u4f53code\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((Object)requestVO.getEnableStatus(), (String)"\u542f\u7528\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notEmpty((Collection)requestVO.getOrgCodeList(), (String)"\u7ec4\u7ec7codeList\u4e0d\u80fd\u4e3a\u7a7a");
        RightsHotelUpdateStatusResponseVO responseVO = this.hotelService.updateEnableStatus(requestVO);
        return ResponseUtil.success((Object)responseVO);
    }

    public HotelController(HotelService hotelService) {
        this.hotelService = hotelService;
    }
}

