/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.service.listener;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import com.alibaba.fastjson.JSON;
import com.bizvane.rights.api.service.HotelOrderService;
import com.bizvane.rights.mq.HotelOrderCloseMq;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RocketMQMessageListener(topic="SYNC_ORDER_AND_SERVICE", tags={"ORDER_HOTEL_PAYMENT_TIMEOUT"})
public class HotelOrderPaymentTimeoutListener
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(HotelOrderPaymentTimeoutListener.class);
    private final HotelOrderService hotelOrderService;

    public void onMessage(ConsumerMessage<String> message) {
        log.info("HotelOrderCloseListener.start:{}", message.getMessage());
        try {
            ResponseData responseData = this.hotelOrderService.paymentTimeout((HotelOrderCloseMq)JSON.parseObject((String)((String)message.getMessage()), HotelOrderCloseMq.class));
            log.info("paymentTimeout:{}", (Object)JacksonUtil.bean2Json((Object)responseData));
        }
        catch (Exception e) {
            log.error("\u9152\u5e97\u8ba2\u5355\u5173\u95ed\u5f02\u5e38:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
        log.info("HotelOrderCloseListener.end");
    }

    public HotelOrderPaymentTimeoutListener(HotelOrderService hotelOrderService) {
        this.hotelOrderService = hotelOrderService;
    }
}

