/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.bizvane.members.feign.model.vo.CouponDefinitionVO;
import com.bizvane.rights.api.service.TransitBenefitsService;
import com.bizvane.rights.api.service.component.CouponComponent;
import com.bizvane.rights.api.util.UID;
import com.bizvane.rights.domain.model.entity.RightsTransitBenefitsCouponPO;
import com.bizvane.rights.domain.model.entity.RightsTransitBenefitsPO;
import com.bizvane.rights.domain.model.entity.RightsTransitGuidePO;
import com.bizvane.rights.domain.service.IRightsTransitBenefitsCouponService;
import com.bizvane.rights.domain.service.IRightsTransitBenefitsService;
import com.bizvane.rights.domain.service.IRightsTransitGuideService;
import com.bizvane.rights.domain.util.ConvertUtil;
import com.bizvane.rights.domain.util.ResponseUtil;
import com.bizvane.rights.enums.TransitBenefitsRightsTypeEnum;
import com.bizvane.rights.vo.OptStatusVO;
import com.bizvane.rights.vo.OptUserVO;
import com.bizvane.rights.vo.transit.benefits.TransitBenefitsAddOrUpdateRequestVO;
import com.bizvane.rights.vo.transit.benefits.TransitBenefitsAddOrUpdateResponseVO;
import com.bizvane.rights.vo.transit.benefits.TransitBenefitsAllResponseVO;
import com.bizvane.rights.vo.transit.benefits.TransitBenefitsDetailResponseVO;
import com.bizvane.rights.vo.transit.guide.TransitGuideUpdateRequestVO;
import com.bizvane.rights.vo.transit.guide.TransitGuideVO;
import com.bizvane.utils.exception.BizException;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TransitBenefitsServiceImpl
implements TransitBenefitsService {
    private final IRightsTransitBenefitsService rightsTransitBenefitsService;
    private final IRightsTransitBenefitsCouponService rightsTransitBenefitsCouponService;
    private final CouponComponent couponComponent;
    private final IRightsTransitGuideService rightsTransitGuideService;

    public TransitBenefitsAllResponseVO all() {
        TransitBenefitsAllResponseVO responseVO = new TransitBenefitsAllResponseVO();
        ArrayList<TransitBenefitsDetailResponseVO> transitBenefitsDetailResponseVOList = new ArrayList<TransitBenefitsDetailResponseVO>();
        List rightsTypeList = Arrays.stream(TransitBenefitsRightsTypeEnum.values()).map(TransitBenefitsRightsTypeEnum::getType).collect(Collectors.toList());
        List rightsTransitBenefitsPOS = this.rightsTransitBenefitsService.detailByRightsTypeList(rightsTypeList);
        Map<Integer, TransitBenefitsDetailResponseVO> benefitsDetailResponseVOMap = rightsTransitBenefitsPOS.stream().collect(Collectors.toMap(RightsTransitBenefitsPO::getRightsType, rightsTransitBenefitsPO -> ConvertUtil.po2vo((RightsTransitBenefitsPO)rightsTransitBenefitsPO)));
        for (TransitBenefitsRightsTypeEnum value : TransitBenefitsRightsTypeEnum.values()) {
            if (benefitsDetailResponseVOMap.containsKey(value.getType())) {
                TransitBenefitsDetailResponseVO domesticArrival = benefitsDetailResponseVOMap.get(value.getType());
                domesticArrival.setCouponDefinitionVOList(this.getCouponDefinitionVOList(domesticArrival));
                transitBenefitsDetailResponseVOList.add(domesticArrival);
                continue;
            }
            TransitBenefitsDetailResponseVO transitBenefitsDetailResponseVO = new TransitBenefitsDetailResponseVO();
            transitBenefitsDetailResponseVO.setType(TransitBenefitsRightsTypeEnum.TYPE_COUPON);
            transitBenefitsDetailResponseVO.setRightsName(value.getDesc());
            transitBenefitsDetailResponseVO.setRightsType(value.getType());
            transitBenefitsDetailResponseVO.setCouponDefinitionVOList(this.getCouponDefinitionVOList(transitBenefitsDetailResponseVO));
            transitBenefitsDetailResponseVOList.add(transitBenefitsDetailResponseVO);
        }
        responseVO.setTransitBenefitsDetailResponseVOList(transitBenefitsDetailResponseVOList);
        return responseVO;
    }

    public TransitBenefitsDetailResponseVO detailByRightsType(Integer rightsType) {
        RightsTransitBenefitsPO rightsTransitBenefitsPO = this.rightsTransitBenefitsService.detailByRightsType(rightsType);
        TransitBenefitsDetailResponseVO responseVO = ConvertUtil.po2vo((RightsTransitBenefitsPO)rightsTransitBenefitsPO);
        responseVO.setCouponDefinitionVOList(this.getCouponDefinitionVOList(responseVO));
        return responseVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<TransitBenefitsAddOrUpdateResponseVO> addOrUpdate(TransitBenefitsAddOrUpdateRequestVO requestVO) {
        if (!requestVO.getStatus().booleanValue()) {
            return this.deleteTransitBenefits(requestVO);
        }
        RightsTransitBenefitsPO rightsTransitBenefitsPO = this.rightsTransitBenefitsService.detailByRightsType(requestVO.getRightsType());
        if (rightsTransitBenefitsPO == null) {
            return this.addTransitBenefits(requestVO);
        }
        return this.updateTransitBenefits(requestVO, rightsTransitBenefitsPO);
    }

    @NotNull
    private ResponseData<TransitBenefitsAddOrUpdateResponseVO> deleteTransitBenefits(TransitBenefitsAddOrUpdateRequestVO requestVO) {
        boolean deleted = this.rightsTransitBenefitsService.deleteByRightsType(requestVO.getRightsType(), (OptUserVO)requestVO);
        TransitBenefitsAddOrUpdateResponseVO responseVO = new TransitBenefitsAddOrUpdateResponseVO();
        responseVO.setOptStatus(deleted);
        return ResponseUtil.success((Object)responseVO);
    }

    public TransitGuideVO queryTransitGuide() {
        RightsTransitGuidePO transitGuidePO = this.rightsTransitGuideService.selectOne();
        return ConvertUtil.po2vo((RightsTransitGuidePO)transitGuidePO);
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<OptStatusVO> updateTransitGuide(TransitGuideUpdateRequestVO requestVO) {
        RightsTransitGuidePO transitGuidePO = this.rightsTransitGuideService.selectOne();
        if (transitGuidePO == null) {
            return this.addTransitGuide(requestVO);
        }
        return this.updateTransitGuide(requestVO, transitGuidePO);
    }

    @NotNull
    private ResponseData<OptStatusVO> addTransitGuide(TransitGuideUpdateRequestVO requestVO) {
        RightsTransitGuidePO rightsTransitGuidePOAdd = new RightsTransitGuidePO();
        rightsTransitGuidePOAdd.setRightsTransitGuideCode(UID.getUid());
        rightsTransitGuidePOAdd.setGuideContent(requestVO.getGuideContent());
        rightsTransitGuidePOAdd.setCreateUserCode(requestVO.getOptUserCode());
        rightsTransitGuidePOAdd.setCreateUserName(requestVO.getOptUserName());
        boolean save = this.rightsTransitGuideService.save((Object)rightsTransitGuidePOAdd);
        OptStatusVO optStatusVO = new OptStatusVO();
        optStatusVO.setOptStatus(save);
        return ResponseUtil.success((Object)optStatusVO);
    }

    @NotNull
    private ResponseData<OptStatusVO> updateTransitGuide(TransitGuideUpdateRequestVO requestVO, RightsTransitGuidePO transitGuidePO) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(RightsTransitGuidePO::getGuideContent, (Object)requestVO.getGuideContent())).set(RightsTransitGuidePO::getModifiedUserCode, (Object)requestVO.getOptUserCode())).set(RightsTransitGuidePO::getModifiedUserName, (Object)requestVO.getOptUserName())).eq(RightsTransitGuidePO::getRightsTransitGuideCode, (Object)transitGuidePO.getRightsTransitGuideCode());
        boolean update = this.rightsTransitGuideService.update((Wrapper)updateWrapper);
        OptStatusVO optStatusVO = new OptStatusVO();
        optStatusVO.setOptStatus(update);
        return ResponseUtil.success((Object)optStatusVO);
    }

    private List<CouponDefinitionVO> getCouponDefinitionVOList(TransitBenefitsDetailResponseVO responseVO) {
        if (StringUtils.isBlank((CharSequence)responseVO.getRightsTransitBenefitsCode())) {
            return new ArrayList<CouponDefinitionVO>();
        }
        List rightsTransitBenefitsCouponPOS = this.rightsTransitBenefitsCouponService.listByRightsTransitBenefitsCode(responseVO.getRightsTransitBenefitsCode());
        if (CollectionUtils.isEmpty((Collection)rightsTransitBenefitsCouponPOS)) {
            return new ArrayList<CouponDefinitionVO>();
        }
        List couponDefinitionCodeList = rightsTransitBenefitsCouponPOS.stream().map(RightsTransitBenefitsCouponPO::getCouponDefinitionCode).collect(Collectors.toList());
        ResponseData responseData = this.couponComponent.list(couponDefinitionCodeList);
        if (ResponseUtil.isFail((ResponseData)responseData)) {
            throw new BizException("\u672a\u83b7\u53d6\u5230\u5238\u5b9a\u4e49\u76f8\u5173\u4fe1\u606f");
        }
        return ((PageInfo)responseData.getData()).getList();
    }

    private ResponseData<TransitBenefitsAddOrUpdateResponseVO> addTransitBenefits(TransitBenefitsAddOrUpdateRequestVO requestVO) {
        RightsTransitBenefitsPO rightsTransitBenefitsPO = new RightsTransitBenefitsPO();
        rightsTransitBenefitsPO.setRightsTransitBenefitsCode(UID.getUid());
        rightsTransitBenefitsPO.setRightsType(requestVO.getRightsType());
        rightsTransitBenefitsPO.setRightsName(TransitBenefitsRightsTypeEnum.typeOf((Integer)requestVO.getRightsType()).getDesc());
        rightsTransitBenefitsPO.setClaimMethod(requestVO.getClaimMethod());
        rightsTransitBenefitsPO.setType(requestVO.getType());
        rightsTransitBenefitsPO.setLinkUrl(requestVO.getLinkUrl());
        rightsTransitBenefitsPO.setStatus(requestVO.getStatus());
        rightsTransitBenefitsPO.setLimitType(requestVO.getLimitType());
        rightsTransitBenefitsPO.setLimitCount(requestVO.getLimitCount());
        rightsTransitBenefitsPO.setRemark(requestVO.getRemark());
        rightsTransitBenefitsPO.setCreateUserName(requestVO.getOptUserName());
        rightsTransitBenefitsPO.setCreateUserCode(requestVO.getOptUserCode());
        boolean save = this.rightsTransitBenefitsService.save((Object)rightsTransitBenefitsPO);
        if (save) {
            List benefitsCouponPOList = requestVO.getCouponDefinitionCodeList().stream().map(couponDefinitionCode -> {
                RightsTransitBenefitsCouponPO rightsTransitBenefitsCouponPO = new RightsTransitBenefitsCouponPO();
                rightsTransitBenefitsCouponPO.setRightsTransitBenefitsCode(rightsTransitBenefitsPO.getRightsTransitBenefitsCode());
                rightsTransitBenefitsCouponPO.setCouponDefinitionCode(couponDefinitionCode);
                rightsTransitBenefitsCouponPO.setRightsTransitBenefitsCoupon(UID.getUid());
                rightsTransitBenefitsCouponPO.setCreateUserCode(requestVO.getOptUserCode());
                rightsTransitBenefitsCouponPO.setCreateUserName(requestVO.getOptUserName());
                return rightsTransitBenefitsCouponPO;
            }).collect(Collectors.toList());
            this.rightsTransitBenefitsCouponService.saveBatch(benefitsCouponPOList);
        }
        TransitBenefitsAddOrUpdateResponseVO responseVO = new TransitBenefitsAddOrUpdateResponseVO();
        responseVO.setOptStatus(save);
        return ResponseUtil.success((Object)responseVO);
    }

    private ResponseData<TransitBenefitsAddOrUpdateResponseVO> updateTransitBenefits(TransitBenefitsAddOrUpdateRequestVO requestVO, RightsTransitBenefitsPO transitBenefitsPO) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(RightsTransitBenefitsPO::getClaimMethod, (Object)requestVO.getClaimMethod())).set(RightsTransitBenefitsPO::getType, (Object)requestVO.getType())).set(RightsTransitBenefitsPO::getLinkUrl, (Object)requestVO.getLinkUrl())).set(RightsTransitBenefitsPO::getStatus, (Object)requestVO.getStatus())).set(RightsTransitBenefitsPO::getLimitType, (Object)requestVO.getLimitType())).set(RightsTransitBenefitsPO::getLimitCount, (Object)requestVO.getLimitCount())).set(RightsTransitBenefitsPO::getRemark, (Object)requestVO.getRemark())).set(RightsTransitBenefitsPO::getModifiedUserCode, (Object)requestVO.getOptUserCode())).set(RightsTransitBenefitsPO::getModifiedUserName, (Object)requestVO.getOptUserName())).eq(RightsTransitBenefitsPO::getRightsTransitBenefitsCode, (Object)transitBenefitsPO.getRightsTransitBenefitsCode());
        boolean update = this.rightsTransitBenefitsService.update((Wrapper)updateWrapper);
        if (update) {
            List rightsTransitBenefitsCouponPOS = this.rightsTransitBenefitsCouponService.listByRightsTransitBenefitsCode(transitBenefitsPO.getRightsTransitBenefitsCode());
            if (CollectionUtils.isNotEmpty((Collection)rightsTransitBenefitsCouponPOS)) {
                this.rightsTransitBenefitsCouponService.removeByIds((Collection)rightsTransitBenefitsCouponPOS.stream().map(RightsTransitBenefitsCouponPO::getId).collect(Collectors.toList()));
            }
            List benefitsCouponPOList = requestVO.getCouponDefinitionCodeList().stream().map(couponDefinitionCode -> {
                RightsTransitBenefitsCouponPO rightsTransitBenefitsCouponPO = new RightsTransitBenefitsCouponPO();
                rightsTransitBenefitsCouponPO.setRightsTransitBenefitsCode(transitBenefitsPO.getRightsTransitBenefitsCode());
                rightsTransitBenefitsCouponPO.setCouponDefinitionCode(couponDefinitionCode);
                rightsTransitBenefitsCouponPO.setRightsTransitBenefitsCoupon(UID.getUid());
                rightsTransitBenefitsCouponPO.setCreateUserCode(requestVO.getOptUserCode());
                rightsTransitBenefitsCouponPO.setCreateUserName(requestVO.getOptUserName());
                return rightsTransitBenefitsCouponPO;
            }).collect(Collectors.toList());
            this.rightsTransitBenefitsCouponService.saveBatch(benefitsCouponPOList);
        }
        TransitBenefitsAddOrUpdateResponseVO responseVO = new TransitBenefitsAddOrUpdateResponseVO();
        responseVO.setOptStatus(update);
        return ResponseUtil.success((Object)responseVO);
    }

    public TransitBenefitsServiceImpl(IRightsTransitBenefitsService rightsTransitBenefitsService, IRightsTransitBenefitsCouponService rightsTransitBenefitsCouponService, CouponComponent couponComponent, IRightsTransitGuideService rightsTransitGuideService) {
        this.rightsTransitBenefitsService = rightsTransitBenefitsService;
        this.rightsTransitBenefitsCouponService = rightsTransitBenefitsCouponService;
        this.couponComponent = couponComponent;
        this.rightsTransitGuideService = rightsTransitGuideService;
    }
}

