/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.service.component;

import com.bizvane.payment.feign.api.ApiWechatPayFeign;
import com.bizvane.payment.feign.api.ApiWechatRefundFeign;
import com.bizvane.payment.feign.contants.PaymentChannelTypeEnum;
import com.bizvane.payment.feign.vo.req.PrepareOrderReqVO;
import com.bizvane.payment.feign.vo.req.RefundOrderReqVO;
import com.bizvane.payment.feign.vo.resp.PrepayOrderRespVO;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PaymentComponent {
    @Autowired
    private ApiWechatRefundFeign wechatRefundFeign;
    @Autowired
    private ApiWechatPayFeign wechatPayFeign;
    @Value(value="${wechat.merchantId}")
    private String wechatMerchantId;

    public ResponseData<PrepayOrderRespVO> prepareOrder(PrepareOrderReqVO reqVO) {
        reqVO.setPaymentMerchantConfigCode(this.wechatMerchantId);
        reqVO.setChannelType(PaymentChannelTypeEnum.HOTEL_ORDER.getCode());
        return this.wechatPayFeign.prepareOrder(reqVO);
    }

    public ResponseData<String> refundOrder(RefundOrderReqVO reqVO) {
        reqVO.setPaymentMerchantConfigCode(this.wechatMerchantId);
        reqVO.setChannelType(PaymentChannelTypeEnum.HOTEL_ORDER.getCode());
        return this.wechatRefundFeign.refundOrder(reqVO);
    }

    public ResponseData<String> refund(RefundOrderReqVO refundOrderReqVO) {
        refundOrderReqVO.setPaymentMerchantConfigCode(this.wechatMerchantId);
        return this.wechatRefundFeign.refundOrder(refundOrderReqVO);
    }
}

