/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.service.component;

import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import cn.hutool.core.date.LocalDateTimeUtil;
import com.alibaba.fastjson.JSON;
import com.bizvane.basic.feign.model.vo.TBasicMerchantVo;
import com.bizvane.basic.feign.model.vo.TBasicOrgVo;
import com.bizvane.members.feign.model.bo.OrderBO;
import com.bizvane.members.feign.model.bo.OrderDetailBO;
import com.bizvane.members.feign.service.OrderFeign;
import com.bizvane.rights.api.service.component.MerchantComponent;
import com.bizvane.rights.api.service.component.OrgComponent;
import com.bizvane.rights.domain.model.entity.RightsHotelOrderDetailPO;
import com.bizvane.rights.domain.model.entity.RightsHotelOrderPO;
import com.bizvane.rights.domain.model.entity.RightsHotelPO;
import com.bizvane.rights.domain.model.entity.RightsParkingOrderPO;
import com.bizvane.rights.domain.model.entity.StewardOrderServicePO;
import com.bizvane.rights.domain.service.IRightsHotelOrderDetailService;
import com.bizvane.rights.domain.service.IRightsHotelOrderService;
import com.bizvane.rights.domain.service.IRightsHotelService;
import com.bizvane.rights.domain.service.IRightsParkingOrderService;
import com.bizvane.rights.domain.service.IStewardOrderServiceService;
import com.bizvane.rights.domain.service.impl.StewardOrderServiceImpl;
import com.bizvane.rights.domain.util.LocalDateUtils;
import com.bizvane.rights.domain.util.OrderStatusUtil;
import com.bizvane.rights.domain.util.ResponseUtil;
import com.bizvane.rights.enums.HotelOrderPayTypeEnum;
import com.bizvane.rights.enums.HotelOrderReservationTypeEnum;
import com.bizvane.rights.mq.HotelOrderCloseMq;
import com.bizvane.rights.mq.HotelOrderMq;
import com.bizvane.rights.mq.ParkingOrderMq;
import com.bizvane.rights.mq.StewardOrderMq;
import com.bizvane.rights.vo.steward.StewardOrderReqRespVO;
import com.bizvane.utils.enumutils.OrderTypeEnum;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class OrderComponent {
    private static final Logger log = LoggerFactory.getLogger(OrderComponent.class);
    private final OrderFeign orderFeign;
    private final IRightsHotelOrderService rightsHotelOrderService;
    private final IRightsHotelOrderDetailService rightsHotelOrderDetailService;
    private final OrgComponent orgComponent;
    private final IRightsHotelService rightsHotelService;
    private final MerchantComponent merchantComponent;
    private final RocketMQTemplate rocketMQTemplate;
    private final IRightsParkingOrderService rightsParkingOrderService;
    private final IStewardOrderServiceService iStewardOrderServiceService;
    private final StewardOrderServiceImpl stewardOrderService;

    @Async(value="customThreadPool")
    public void syncHotelOrderAsync(String rightsHotelOrderCode) {
        HotelOrderMq hotelOrderMq = HotelOrderMq.builder().rightsHotelOrderCode(rightsHotelOrderCode).build();
        log.info("\u9152\u5e97\u8ba2\u5355\u540c\u6b65:{}", (Object)JacksonUtil.bean2Json((Object)hotelOrderMq));
        try {
            this.rocketMQTemplate.send(Destination.builder().topic("SYNC_ORDER_AND_SERVICE").tag("ORDER_HOTEL").build(), (Object)JSON.toJSONString((Object)hotelOrderMq));
        }
        catch (Exception e) {
            log.error("\u9152\u5e97\u8ba2\u5355\u540c\u6b65\u5f02\u5e38:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public ResponseData<Boolean> syncHotelOrderSync(String rightsHotelOrderCode) {
        RightsHotelOrderPO rightsHotelOrderPO = this.rightsHotelOrderService.detailByCode(rightsHotelOrderCode);
        if (rightsHotelOrderPO == null) {
            return ResponseUtil.of((SysResponseEnum)SysResponseEnum.RIGHTS_HOTEL_ORDER_NOT_EXISTS);
        }
        RightsHotelPO rightsHotelPO = this.rightsHotelService.detailByCode(rightsHotelOrderPO.getRightsHotelCode());
        ResponseData orgVoResponseData = this.orgComponent.detail(rightsHotelPO.getOrgCode());
        if (ResponseUtil.isFail((ResponseData)orgVoResponseData) || orgVoResponseData.getData() == null || StringUtils.isBlank((CharSequence)((TBasicOrgVo)orgVoResponseData.getData()).getMerchantCode())) {
            return ResponseUtil.fail((String)"\u67e5\u8be2\u7ec4\u7ec7\u5173\u8054\u5546\u6237\u5931\u8d25!");
        }
        ResponseData tBasicMerchantVoResponseData = this.merchantComponent.queryMerchant(((TBasicOrgVo)orgVoResponseData.getData()).getMerchantCode());
        if (ResponseUtil.isFail((ResponseData)tBasicMerchantVoResponseData)) {
            return ResponseUtil.copy((ResponseData)tBasicMerchantVoResponseData);
        }
        TBasicMerchantVo merchantVo = (TBasicMerchantVo)tBasicMerchantVoResponseData.getData();
        List rightsHotelOrderDetailPOS = this.rightsHotelOrderDetailService.listByRightsHotelOrderCode(rightsHotelOrderCode);
        BigDecimal originalPriceTotal = BigDecimal.ZERO;
        BigDecimal discountPrice = ((RightsHotelOrderDetailPO)rightsHotelOrderDetailPOS.get(0)).getActualPrice();
        for (RightsHotelOrderDetailPO rightsHotelOrderDetailPO : rightsHotelOrderDetailPOS) {
            originalPriceTotal = originalPriceTotal.add(rightsHotelOrderDetailPO.getActualPrice().multiply(new BigDecimal(rightsHotelOrderDetailPO.getQuantity())));
        }
        OrderBO orderBO = new OrderBO();
        orderBO.setChannelCode("10");
        orderBO.setSourceCode("10");
        orderBO.setMbrMembersCode(rightsHotelOrderPO.getMemberCode());
        orderBO.setOrderNo(rightsHotelOrderPO.getOrderNo());
        orderBO.setOrderFlag(Integer.valueOf(1));
        orderBO.setOrderType(Integer.valueOf(3));
        orderBO.setOriginalOrderNo(rightsHotelOrderPO.getOrderNo());
        orderBO.setOrderStatus(OrderStatusUtil.convertHotelOrderStatus((Integer)rightsHotelOrderPO.getOrderStatus()));
        orderBO.setTradeAmount(originalPriceTotal);
        orderBO.setPlaceOrderTime(rightsHotelOrderPO.getCreateDate());
        HotelOrderPayTypeEnum hotelOrderPayTypeEnum = HotelOrderPayTypeEnum.fromType((Integer)rightsHotelOrderPO.getPayType());
        if (hotelOrderPayTypeEnum == HotelOrderPayTypeEnum.WECHAT_PAY) {
            orderBO.setPayTime(rightsHotelOrderPO.getPayTime());
        } else if (hotelOrderPayTypeEnum == HotelOrderPayTypeEnum.CHECK_IN_PAY) {
            orderBO.setPayTime(rightsHotelOrderPO.getCheckInTime());
        }
        orderBO.setPayMoney(rightsHotelOrderPO.getPayableAmount());
        orderBO.setAirportNo(merchantVo.getAirportCode());
        orderBO.setIndustryNo(merchantVo.getBusinessCode());
        orderBO.setMerchantNo(merchantVo.getMerchantCode());
        orderBO.setUserCode(merchantVo.getMerchantCode());
        orderBO.setUserName(merchantVo.getMerchantName());
        ArrayList<OrderDetailBO> orderDetailBOList = new ArrayList<OrderDetailBO>();
        OrderDetailBO orderDetailBO = new OrderDetailBO();
        orderDetailBO.setImageUrl(((RightsHotelOrderDetailPO)rightsHotelOrderDetailPOS.get(0)).getRoomMainImage());
        orderDetailBO.setTradeAmountDetail(discountPrice);
        orderDetailBO.setProductName(((RightsHotelOrderDetailPO)rightsHotelOrderDetailPOS.get(0)).getRoomTypeName());
        orderDetailBO.setProductNo(((RightsHotelOrderDetailPO)rightsHotelOrderDetailPOS.get(0)).getRoomTypeName());
        orderDetailBO.setTagPrice(((RightsHotelOrderDetailPO)rightsHotelOrderDetailPOS.get(0)).getOriginalPrice());
        orderDetailBO.setQuantityDecimal(BigDecimal.valueOf(((RightsHotelOrderDetailPO)rightsHotelOrderDetailPOS.get(0)).getQuantity().intValue()));
        orderDetailBO.setDiscountPrice(discountPrice);
        orderDetailBO.setTradeDetailTotalAmount(originalPriceTotal);
        String specification = LocalDateTimeUtil.format((LocalDateTime)rightsHotelOrderPO.getExpectedArrivalTime(), (String)"yyyy-MM-dd") + " - " + LocalDateTimeUtil.format((LocalDateTime)rightsHotelOrderPO.getExpectedCheckOutTime(), (String)"yyyy-MM-dd") + "," + LocalDateUtils.datesUntil((LocalDate)rightsHotelOrderPO.getExpectedArrivalTime().toLocalDate(), (LocalDate)rightsHotelOrderPO.getExpectedCheckOutTime().toLocalDate()).size() + "\u665a";
        orderDetailBO.setSpecification(specification);
        orderDetailBOList.add(orderDetailBO);
        orderBO.setOrderDetailList(orderDetailBOList);
        HotelOrderReservationTypeEnum hotelOrderReservationTypeEnum = HotelOrderReservationTypeEnum.fromType((Integer)rightsHotelOrderPO.getReservationType());
        if (hotelOrderReservationTypeEnum == HotelOrderReservationTypeEnum.EMPLOYEE_RESERVATION) {
            orderBO.setExcludeConsumerLabel(Boolean.TRUE);
        }
        ResponseData orderAddResponseData = this.orderFeign.add(orderBO);
        log.info("orderFeign.add.{}", (Object)JacksonUtil.bean2Json((Object)orderAddResponseData));
        return orderAddResponseData;
    }

    public void syncParkingOrderAsync(String parkingRecordNo) {
        ParkingOrderMq parkingOrderMq = ParkingOrderMq.builder().parkingRecordNo(parkingRecordNo).build();
        log.info("\u505c\u8f66\u8ba2\u5355\u540c\u6b65:{}", (Object)JacksonUtil.bean2Json((Object)parkingOrderMq));
        try {
            this.rocketMQTemplate.send(Destination.builder().topic("SYNC_ORDER_AND_SERVICE").tag("ORDER_PARKING").build(), (Object)JSON.toJSONString((Object)parkingOrderMq));
        }
        catch (Exception e) {
            log.error("\u505c\u8f66\u8ba2\u5355\u540c\u6b65\u5f02\u5e38:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public ResponseData<Boolean> syncParkingOrderSync(String parkingRecordNo) {
        RightsParkingOrderPO rightsParkingOrderPO = this.rightsParkingOrderService.detailByParkingRecordNo(parkingRecordNo);
        if (rightsParkingOrderPO == null) {
            return ResponseUtil.fail((String)"\u505c\u8f66\u8ba2\u5355\u4e0d\u5b58\u5728!");
        }
        OrderBO orderBO = new OrderBO();
        orderBO.setChannelCode(rightsParkingOrderPO.getChannelCode().toString());
        orderBO.setSourceCode(rightsParkingOrderPO.getSourceCode().toString());
        orderBO.setMbrMembersCode(rightsParkingOrderPO.getMbrMembersCode());
        orderBO.setOrderNo(rightsParkingOrderPO.getOrderNo());
        orderBO.setOrderFlag(Integer.valueOf(1));
        orderBO.setOrderType(Integer.valueOf(2));
        orderBO.setOriginalOrderNo(rightsParkingOrderPO.getParkingRecordNo());
        Integer orderStatus = OrderStatusUtil.convertParkingOrderStatus((RightsParkingOrderPO)rightsParkingOrderPO);
        if (orderStatus == null) {
            return ResponseUtil.fail((String)"\u505c\u8f66\u8ba2\u5355\u672a\u652f\u4ed8!");
        }
        orderBO.setOrderStatus(orderStatus);
        orderBO.setTradeAmount(rightsParkingOrderPO.getPaidInAmount());
        orderBO.setPlaceOrderTime(rightsParkingOrderPO.getEntranceTime());
        orderBO.setPayTime(rightsParkingOrderPO.getPaymentEndTime());
        orderBO.setPayMoney(rightsParkingOrderPO.getPaidInAmount());
        ResponseData tBasicMerchantVoResponseData = this.merchantComponent.queryMerchant(rightsParkingOrderPO.getMerchantNo());
        if (ResponseUtil.isFail((ResponseData)tBasicMerchantVoResponseData)) {
            return ResponseUtil.copy((ResponseData)tBasicMerchantVoResponseData);
        }
        TBasicMerchantVo merchantVo = (TBasicMerchantVo)tBasicMerchantVoResponseData.getData();
        orderBO.setAirportNo(merchantVo.getAirportCode());
        orderBO.setIndustryNo(merchantVo.getBusinessCode());
        orderBO.setMerchantNo(merchantVo.getMerchantCode());
        orderBO.setUserCode(merchantVo.getMerchantCode());
        orderBO.setUserName(merchantVo.getMerchantName());
        ArrayList<OrderDetailBO> orderDetailBOList = new ArrayList<OrderDetailBO>();
        OrderDetailBO orderDetailBO = new OrderDetailBO();
        orderDetailBO.setImageUrl("http://airport-uat-1329502467.cos.ap-shanghai.myqcloud.com/image/20241210/JLsApO20241210-201553.jpeg");
        orderDetailBO.setTradeAmountDetail(rightsParkingOrderPO.getPaidInAmount());
        orderDetailBO.setProductName(rightsParkingOrderPO.getParkName());
        orderDetailBO.setProductNo(rightsParkingOrderPO.getParkName());
        orderDetailBO.setTagPrice(rightsParkingOrderPO.getPaidInAmount());
        orderDetailBO.setQuantityDecimal(BigDecimal.ONE);
        orderDetailBO.setDiscountPrice(rightsParkingOrderPO.getPaidInAmount());
        orderDetailBO.setTradeDetailTotalAmount(rightsParkingOrderPO.getPaidInAmount());
        String specification = LocalDateTimeUtil.format((LocalDateTime)rightsParkingOrderPO.getEntranceTime(), (String)"yyyy-MM-dd HH:mm:ss") + " - " + LocalDateTimeUtil.format((LocalDateTime)rightsParkingOrderPO.getExitTime(), (String)"yyyy-MM-dd HH:mm:ss");
        orderDetailBO.setSpecification(specification);
        orderDetailBOList.add(orderDetailBO);
        orderBO.setOrderDetailList(orderDetailBOList);
        ResponseData orderAddResponseData = this.orderFeign.add(orderBO);
        log.info("orderFeign.add.{}", (Object)JacksonUtil.bean2Json((Object)orderAddResponseData));
        return orderAddResponseData;
    }

    public void hotelOrderPendingPayment(RightsHotelOrderPO rightsHotelOrderPO) {
        HotelOrderCloseMq hotelOrderCloseMq = HotelOrderCloseMq.builder().rightsHotelOrderCode(rightsHotelOrderPO.getRightsHotelOrderCode()).build();
        try {
            long epochMilli = LocalDateTimeUtil.toEpochMilli((TemporalAccessor)rightsHotelOrderPO.getCreateDate().plusMinutes(15L));
            log.info("\u9152\u5e97\u8ba2\u5355\u5173\u95edmq:{},\u89e6\u53d1\u65f6\u95f4:{}", (Object)JacksonUtil.bean2Json((Object)hotelOrderCloseMq), (Object)epochMilli);
            this.rocketMQTemplate.send(Destination.builder().topic("SYNC_ORDER_AND_SERVICE").tag("ORDER_HOTEL_PAYMENT_TIMEOUT").timeStamp(Long.valueOf(epochMilli)).build(), (Object)JSON.toJSONString((Object)hotelOrderCloseMq));
        }
        catch (Exception e) {
            log.error("\u9152\u5e97\u8ba2\u5355\u540c\u6b65\u5f02\u5e38:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    @Async(value="customThreadPool")
    public void syncStewardOrder(String stewardOrderCode) {
        StewardOrderMq.builder().stewardOrderCode(stewardOrderCode).build();
        try {
            this.syncStewardOrders(stewardOrderCode);
        }
        catch (Exception e) {
            log.error("\u673a\u573a\u7ba1\u5bb6\u8ba2\u5355\u540c\u6b65\u5f02\u5e38:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private void syncStewardOrders(String stewardOrderCode) {
        StewardOrderReqRespVO stewardOrder = this.stewardOrderService.detailByCode(stewardOrderCode);
        if (null == stewardOrder) {
            ResponseUtil.of((SysResponseEnum)SysResponseEnum.RIGHTS_STEWARD_ORDER_NOT_EXISTS);
        }
        StewardOrderServicePO stewardOrderServicePO = this.iStewardOrderServiceService.selectByStewardOrderCode(stewardOrder.getStewardOrderCode());
        List stewardOrderServiceList = this.iStewardOrderServiceService.selectOrderServiceByOrderCode(stewardOrderCode);
        OrderBO orderBO = new OrderBO();
        orderBO.setChannelCode("10");
        orderBO.setSourceCode("10");
        orderBO.setMbrMembersCode(stewardOrder.getMbrMembersCode());
        orderBO.setOrderNo(stewardOrder.getOrderNo());
        orderBO.setOrderFlag(Integer.valueOf(1));
        orderBO.setOrderType(OrderTypeEnum.AIRPORT_GUARD.getType());
        orderBO.setOriginalOrderNo(stewardOrder.getOrderNo());
        orderBO.setOrderStatus(OrderStatusUtil.convertStewardOrderStatus((Integer)stewardOrder.getStatus()));
        orderBO.setTradeAmount(stewardOrder.getReallyPrice());
        orderBO.setPlaceOrderTime(stewardOrder.getOrderTime());
        orderBO.setPayTime(stewardOrder.getPayDate());
        orderBO.setPayMoney(stewardOrder.getReallyPrice());
        orderBO.setAirportNo(stewardOrderServicePO.getAirportCode());
        orderBO.setUserCode(stewardOrder.getMbrMembersCode());
        orderBO.setUserName(stewardOrder.getMbrName());
        ArrayList orderDetailList = new ArrayList();
        stewardOrderServiceList.forEach(item -> {
            OrderDetailBO orderDetailBO = new OrderDetailBO();
            orderDetailBO.setImageUrl(item.getMainImageUrl());
            orderDetailBO.setTradeAmountDetail(item.getPreferentialPrice());
            orderDetailBO.setProductName(item.getName());
            orderDetailBO.setProductNo(item.getServiceNo());
            orderDetailBO.setTagPrice(item.getOriginalPrice());
            orderDetailBO.setQuantityDecimal(BigDecimal.valueOf(1L));
            orderDetailBO.setDiscountPrice(item.getPreferentialPrice());
            orderDetailBO.setTradeDetailTotalAmount(item.getPreferentialPrice());
        });
        orderBO.setOrderDetailList(orderDetailList);
        ResponseData orderAddResponseData = this.orderFeign.add(orderBO);
        log.info("orderFeign.add.{}", (Object)JacksonUtil.bean2Json((Object)orderAddResponseData));
    }

    public OrderComponent(OrderFeign orderFeign, IRightsHotelOrderService rightsHotelOrderService, IRightsHotelOrderDetailService rightsHotelOrderDetailService, OrgComponent orgComponent, IRightsHotelService rightsHotelService, MerchantComponent merchantComponent, RocketMQTemplate rocketMQTemplate, IRightsParkingOrderService rightsParkingOrderService, IStewardOrderServiceService iStewardOrderServiceService, StewardOrderServiceImpl stewardOrderService) {
        this.orderFeign = orderFeign;
        this.rightsHotelOrderService = rightsHotelOrderService;
        this.rightsHotelOrderDetailService = rightsHotelOrderDetailService;
        this.orgComponent = orgComponent;
        this.rightsHotelService = rightsHotelService;
        this.merchantComponent = merchantComponent;
        this.rocketMQTemplate = rocketMQTemplate;
        this.rightsParkingOrderService = rightsParkingOrderService;
        this.iStewardOrderServiceService = iStewardOrderServiceService;
        this.stewardOrderService = stewardOrderService;
    }
}

