/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.controller;

import com.bizvane.rights.api.service.TransitBenefitsService;
import com.bizvane.rights.domain.util.AssertUtil;
import com.bizvane.rights.domain.util.ResponseUtil;
import com.bizvane.rights.enums.TransitBenefitsClaimMethodEnum;
import com.bizvane.rights.feign.TransitBenefitsFeign;
import com.bizvane.rights.vo.OptStatusVO;
import com.bizvane.rights.vo.OptUserVO;
import com.bizvane.rights.vo.transit.benefits.TransitBenefitsAddOrUpdateRequestVO;
import com.bizvane.rights.vo.transit.benefits.TransitBenefitsAddOrUpdateResponseVO;
import com.bizvane.rights.vo.transit.benefits.TransitBenefitsAllResponseVO;
import com.bizvane.rights.vo.transit.benefits.TransitBenefitsDetailResponseVO;
import com.bizvane.rights.vo.transit.guide.TransitGuideUpdateRequestVO;
import com.bizvane.rights.vo.transit.guide.TransitGuideVO;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/transitBenefits"})
public class TransitBenefitsController
implements TransitBenefitsFeign {
    private final TransitBenefitsService transitBenefitsService;

    public ResponseData<TransitBenefitsAllResponseVO> all() {
        TransitBenefitsAllResponseVO responseVO = this.transitBenefitsService.all();
        return ResponseUtil.success((Object)responseVO);
    }

    public ResponseData<TransitBenefitsDetailResponseVO> detailByRightsType(@RequestParam(value="rightsType") Integer rightsType) {
        TransitBenefitsDetailResponseVO responseVO = this.transitBenefitsService.detailByRightsType(rightsType);
        return ResponseUtil.success((Object)responseVO);
    }

    public ResponseData<TransitBenefitsAddOrUpdateResponseVO> addOrUpdate(@RequestBody TransitBenefitsAddOrUpdateRequestVO requestVO) {
        AssertUtil.optUserNotNull((OptUserVO)requestVO);
        AssertUtil.notNull((Object)requestVO.getRightsType(), (String)"\u6743\u76ca\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((Object)requestVO.getClaimMethod(), (String)"\u6743\u76ca\u9886\u53d6\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.judge((Boolean)Arrays.asList(TransitBenefitsClaimMethodEnum.LINK_JUMP.getType(), TransitBenefitsClaimMethodEnum.RIGHTS_RECEIVE.getType()).contains(requestVO.getClaimMethod()), (String)"\u6743\u76ca\u9886\u53d6\u65b9\u5f0f\u4e0d\u6b63\u786e");
        AssertUtil.notNull((Object)requestVO.getStatus(), (String)"\u6743\u76ca\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        if (requestVO.getStatus().booleanValue()) {
            if (TransitBenefitsClaimMethodEnum.RIGHTS_RECEIVE.getType().compareTo(requestVO.getClaimMethod()) == 0) {
                AssertUtil.notEmpty((Collection)requestVO.getCouponDefinitionCodeList(), (String)"\u6743\u76ca\u9886\u53d6\u65b9\u5f0f\u4e3a\u6743\u76ca\u9886\u53d6\u65f6\uff0c\u6743\u76ca\u5b9a\u4e49codeList\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtil.notNull((Object)requestVO.getType(), (String)"\u6743\u76ca\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtil.notNull((Object)requestVO.getLimitType(), (String)"\u6743\u76ca\u9886\u53d6\u65b9\u5f0f\u4e3a\u6743\u76ca\u9886\u53d6\u65f6\uff0c\u83b7\u53d6\u89c4\u5219\u9650\u5236\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtil.notNull((Object)requestVO.getLimitCount(), (String)"\u6743\u76ca\u9886\u53d6\u65b9\u5f0f\u4e3a\u6743\u76ca\u9886\u53d6\u65f6\uff0c\u83b7\u53d6\u89c4\u5219\u9650\u5236\u6b21\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (TransitBenefitsClaimMethodEnum.LINK_JUMP.getType().compareTo(requestVO.getClaimMethod()) == 0) {
                AssertUtil.notNull((String)requestVO.getLinkUrl(), (String)"\u6743\u76ca\u9886\u53d6\u65b9\u5f0f\u4e3a\u94fe\u63a5\u8df3\u8f6c\u65f6\uff0c\u94fe\u63a5\u8df3\u8f6c\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        return this.transitBenefitsService.addOrUpdate(requestVO);
    }

    public ResponseData<TransitGuideVO> queryTransitGuide() {
        TransitGuideVO responseVO = this.transitBenefitsService.queryTransitGuide();
        return ResponseUtil.success((Object)responseVO);
    }

    public ResponseData<OptStatusVO> updateTransitGuide(@RequestBody TransitGuideUpdateRequestVO requestVO) {
        AssertUtil.notNull((String)requestVO.getGuideContent(), (String)"\u6307\u5357\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.optUserNotNull((OptUserVO)requestVO);
        return this.transitBenefitsService.updateTransitGuide(requestVO);
    }

    public TransitBenefitsController(TransitBenefitsService transitBenefitsService) {
        this.transitBenefitsService = transitBenefitsService;
    }
}

