/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.config;

import com.alibaba.fastjson.JSON;
import com.bizvane.utils.responseinfo.ResponseData;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class ResponseLogAspect {
    private static final Logger log = LoggerFactory.getLogger(ResponseLogAspect.class);
    private final String ASPECT = "@within(org.springframework.stereotype.Controller) || @within(org.springframework.web.bind.annotation.RestController)";

    @Around(value="@within(org.springframework.stereotype.Controller) || @within(org.springframework.web.bind.annotation.RestController)")
    public Object checkAndExceptionHandle(ProceedingJoinPoint pjp) throws Throwable {
        pjp.getArgs();
        HttpServletRequest request = null;
        try {
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            request = attributes.getRequest();
            log.info("REQUEST START | {} URL : {}, ARGS : {}", new Object[]{request.getMethod(), request.getRequestURI().toString(), this.getArgs(pjp.getArgs())});
        }
        catch (Exception e) {
            log.info("checkAndExceptionHandle exception: {}", (Throwable)e);
        }
        Signature signature = pjp.getSignature();
        Class returnType = ((MethodSignature)signature).getReturnType();
        if (!returnType.isAssignableFrom(ResponseData.class)) {
            return pjp.proceed();
        }
        Object proceed = pjp.proceed();
        log.info("RESPONSE :{}", (Object)JSON.toJSONString((Object)proceed));
        return proceed;
    }

    public Object[] getArgs(Object[] args) {
        Object[] result = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            result[i] = arg instanceof InputStream ? "inputStream" : arg;
        }
        return args;
    }
}

