/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.service.listener;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import com.alibaba.fastjson.JSON;
import com.bizvane.rights.api.service.HotelOrderMobileService;
import com.bizvane.rights.enums.EvaluateLabelTypeEnum;
import com.bizvane.rights.mq.AddEvaluateMq;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RocketMQMessageListener(topic="add_evaluate_topic")
public class HotelOrderEvaluateListener
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(HotelOrderEvaluateListener.class);
    private final HotelOrderMobileService hotelOrderMobileService;

    public void onMessage(ConsumerMessage<String> message) {
        log.info("HotelOrderEvaluateListener.start:{}", message.getMessage());
        AddEvaluateMq addEvaluateMq = (AddEvaluateMq)JSON.parseObject((String)((String)message.getMessage()), AddEvaluateMq.class);
        if (EvaluateLabelTypeEnum.HOTEL_ORDER.getCode().compareTo(addEvaluateMq.getEvaluateType()) == 0) {
            this.updateHotelOrder(addEvaluateMq);
        }
        log.info("HotelOrderEvaluateListener.end");
    }

    private void updateHotelOrder(AddEvaluateMq addEvaluateMq) {
        try {
            ResponseData booleanResponseData = this.hotelOrderMobileService.updateEvaluationStatus(addEvaluateMq);
            log.info("updateHotelOrder:{}", (Object)JacksonUtil.bean2Json((Object)booleanResponseData));
        }
        catch (Exception e) {
            log.error("\u9152\u5e97\u8ba2\u5355\u8bc4\u4ef7\u72b6\u6001\u66f4\u65b0\u5f02\u5e38:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public HotelOrderEvaluateListener(HotelOrderMobileService hotelOrderMobileService) {
        this.hotelOrderMobileService = hotelOrderMobileService;
    }
}

