/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.content.feign.api.FileUploadFeign;
import com.bizvane.content.feign.vo.fileupload.FIleUploadResponseVO;
import com.bizvane.content.feign.vo.fileupload.FileUploadRequestVO;
import com.bizvane.members.feign.model.bo.BasicFlightQueryReq;
import com.bizvane.members.feign.model.vo.BasicFlightQueryRsp;
import com.bizvane.members.feign.service.BasicFlightFeign;
import com.bizvane.members.feign.service.FlightRecordFeign;
import com.bizvane.payment.feign.api.ApiWechatPayFeign;
import com.bizvane.payment.feign.vo.req.PrepareOrderReqVO;
import com.bizvane.payment.feign.vo.resp.PrepayOrderRespVO;
import com.bizvane.rights.domain.model.entity.StewardOrderPO;
import com.bizvane.rights.domain.model.entity.StewardOrderServicePO;
import com.bizvane.rights.domain.model.entity.StewardServiceDescriptionPO;
import com.bizvane.rights.domain.model.entity.StewardServicePO;
import com.bizvane.rights.domain.service.impl.StewardOrderServiceImpl;
import com.bizvane.rights.domain.service.impl.StewardOrderServiceServiceImpl;
import com.bizvane.rights.domain.service.impl.StewardServiceDescriptionServiceImpl;
import com.bizvane.rights.domain.service.impl.StewardServiceServiceImpl;
import com.bizvane.rights.domain.util.ResponseUtil;
import com.bizvane.rights.vo.steward.StewardOrderDetailMobileReqVo;
import com.bizvane.rights.vo.steward.StewardOrderMobileReqVO;
import com.bizvane.rights.vo.steward.StewardOrderMobileRespVO;
import com.bizvane.rights.vo.steward.StewardOrderQueryMobileReqVo;
import com.bizvane.rights.vo.steward.StewardOrderReqRespVO;
import com.bizvane.rights.vo.steward.StewardOrderStatusMobileReqVo;
import com.bizvane.rights.vo.steward.StewardPaymentRespVO;
import com.bizvane.rights.vo.steward.StewardServiceDescriptionMobileRespVo;
import com.bizvane.rights.vo.steward.StewardServiceMobileReqVO;
import com.bizvane.rights.vo.steward.StewardServiceMobileRespVO;
import com.bizvane.rights.vo.steward.StewardServiceReqRespVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class StewardMobileService {
    private final StewardOrderServiceImpl stewardOrderService;
    private final StewardServiceDescriptionServiceImpl stewardServiceDescriptionService;
    private final StewardServiceServiceImpl stewardServiceService;
    private final FlightRecordFeign flightRecordfeign;
    private final FileUploadFeign fileUploadFeign;
    private final BasicFlightFeign basicFlightFeign;
    @Value(value="${wechat.merchantId}")
    private String paymentMerchantId;
    private final StewardOrderServiceServiceImpl stewardOrderServiceRel;
    ApiWechatPayFeign apiWechatPayFeign;

    public ResponseData<StewardPaymentRespVO> payForOrder(StewardOrderMobileReqVO stewardOrderMobileReqVO) {
        String[] serviceCodes;
        StewardOrderPO stewardOrderPO = new StewardOrderPO();
        BasicFlightQueryReq basicFlightQueryReq = new BasicFlightQueryReq();
        basicFlightQueryReq.setFlightIdentity(stewardOrderMobileReqVO.getFlightIdentity());
        basicFlightQueryReq.setFlightDate(stewardOrderMobileReqVO.getFlightScheduledDate());
        ResponseData list = this.basicFlightFeign.list(basicFlightQueryReq);
        BeanUtil.copyProperties((Object)stewardOrderMobileReqVO, (Object)stewardOrderPO, (CopyOptions)CopyOptions.create().ignoreNullValue());
        stewardOrderPO.setStewardOrderCode(IdUtil.fastSimpleUUID());
        stewardOrderPO.setCreateDate(LocalDateTime.now());
        stewardOrderPO.setStatus(Integer.valueOf(0));
        stewardOrderPO.setBasicFlightCode(((BasicFlightQueryRsp)((List)list.getData()).get(0)).getBasicFlightCode());
        Boolean result = this.stewardOrderService.save((Object)stewardOrderPO);
        for (String serviceCode : serviceCodes = stewardOrderMobileReqVO.getStewardServiceCode().split(",")) {
            LambdaQueryWrapper stewardServicePOLambdaQueryWrapper = new LambdaQueryWrapper();
            stewardServicePOLambdaQueryWrapper.eq(StewardServicePO::getStewardServiceCode, (Object)serviceCode);
            StewardServicePO servicePO = (StewardServicePO)this.stewardServiceService.getOne((Wrapper)stewardServicePOLambdaQueryWrapper, false);
            if (servicePO == null) {
                return ResponseUtil.fail((String)"\u670d\u52a1\u4e0d\u5b58\u5728");
            }
            StewardOrderServicePO stewardOrderServicePO = new StewardOrderServicePO();
            stewardOrderServicePO.setStewardOrderCode(stewardOrderPO.getStewardOrderCode());
            stewardOrderServicePO.setStewardServiceCode(serviceCode);
            stewardOrderServicePO.setCreateDate(LocalDateTime.now());
            stewardOrderServicePO.setStewardOrderServiceCode(IdUtil.fastSimpleUUID());
            stewardOrderServicePO.setName(servicePO.getName());
            stewardOrderServicePO.setMainImageUrl(servicePO.getMainImageUrl());
            stewardOrderServicePO.setOriginalPrice(servicePO.getOriginalPrice());
            stewardOrderServicePO.setPreferentialPrice(servicePO.getPreferentialPrice());
            stewardOrderServicePO.setContent(servicePO.getContent());
            stewardOrderServicePO.setServiceType(servicePO.getServiceType());
            stewardOrderServicePO.setServiceNo(servicePO.getServiceNo());
            stewardOrderServicePO.setAirportCode(servicePO.getAirportCode());
            stewardOrderServicePO.setValid(Boolean.valueOf(true));
            this.stewardOrderServiceRel.save((Object)stewardOrderServicePO);
        }
        StewardPaymentRespVO stewardPaymentRespVO = new StewardPaymentRespVO();
        PrepareOrderReqVO prepareOrderReqVO = new PrepareOrderReqVO();
        prepareOrderReqVO.setPaymentMerchantConfigCode(this.paymentMerchantId);
        prepareOrderReqVO.setOutTradeNo(stewardOrderMobileReqVO.getStewardOrderCode());
        prepareOrderReqVO.setAmount(stewardOrderMobileReqVO.getReservePrice());
        prepareOrderReqVO.setOpenid(stewardOrderMobileReqVO.getMbrOpenid());
        prepareOrderReqVO.setDescription("\u7ba1\u5bb6\u670d\u52a1\u8ba2\u5355\u652f\u4ed8");
        ResponseData responseData = this.apiWechatPayFeign.prepareOrder(prepareOrderReqVO);
        stewardPaymentRespVO.setStewardOrderCode(stewardOrderPO.getStewardOrderCode());
        stewardPaymentRespVO.setAppId(((PrepayOrderRespVO)responseData.getData()).getAppId());
        stewardPaymentRespVO.setTimestamp(((PrepayOrderRespVO)responseData.getData()).getTimeStamp());
        stewardPaymentRespVO.setNonceStr(((PrepayOrderRespVO)responseData.getData()).getNonceStr());
        stewardPaymentRespVO.setPackageVal(((PrepayOrderRespVO)responseData.getData()).getPackageVal());
        stewardPaymentRespVO.setSignType(((PrepayOrderRespVO)responseData.getData()).getSignType());
        stewardPaymentRespVO.setPaySign(((PrepayOrderRespVO)responseData.getData()).getPaySign());
        return ResponseUtil.success((Object)stewardPaymentRespVO);
    }

    public ResponseData<StewardOrderMobileRespVO> findOrderDetailByOrderCode(StewardOrderDetailMobileReqVo stewardOrderMobileReqVO) {
        List list = this.stewardOrderServiceRel.list((Wrapper)new LambdaQueryWrapper().eq(StewardOrderServicePO::getStewardOrderCode, (Object)stewardOrderMobileReqVO.getStewardOrderCode()));
        ArrayList services = new ArrayList();
        list.forEach(item -> {
            StewardServiceReqRespVO stewardServiceReqRespVO = new StewardServiceReqRespVO();
            BeanUtil.copyProperties((Object)item, (Object)stewardServiceReqRespVO, (CopyOptions)CopyOptions.create().ignoreNullValue());
            services.add(stewardServiceReqRespVO);
        });
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(StewardOrderPO::getStewardOrderCode, (Object)stewardOrderMobileReqVO.getStewardOrderCode())).eq(StewardOrderPO::getMbrMembersCode, (Object)stewardOrderMobileReqVO.getMbrMembersCode())).last("limit 1");
        StewardOrderPO one = (StewardOrderPO)this.stewardOrderService.getOne((Wrapper)queryWrapper);
        StewardOrderMobileRespVO stewardOrderMobileRespVO = new StewardOrderMobileRespVO();
        BeanUtil.copyProperties((Object)one, (Object)stewardOrderMobileRespVO, (CopyOptions)CopyOptions.create().ignoreNullValue());
        stewardOrderMobileRespVO.setServices(services);
        stewardOrderMobileRespVO.setOrderQRCode(this.generateQRCode(stewardOrderMobileReqVO.getStewardOrderCode()));
        return ResponseUtil.success((Object)stewardOrderMobileRespVO);
    }

    public ResponseData<Boolean> changeStatus(@RequestBody StewardOrderStatusMobileReqVo stewardOrderMobileReqVO) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(StewardOrderPO::getStewardOrderCode, (Object)stewardOrderMobileReqVO.getStewardOrderCode())).eq(StewardOrderPO::getMbrMembersCode, (Object)stewardOrderMobileReqVO.getMbrMembersCode());
        StewardOrderPO one = (StewardOrderPO)this.stewardOrderService.getOne((Wrapper)queryWrapper);
        if (one == null) {
            return ResponseUtil.fail((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        one.setStatus(stewardOrderMobileReqVO.getStatus());
        boolean res = this.stewardOrderService.updateById((Object)one);
        return ResponseUtil.success((Object)res);
    }

    public String generateQRCode(String stewardOrderCode) {
        JSONObject json = new JSONObject();
        json.put("stewardOrderCode", (Object)stewardOrderCode);
        String fileName = "qrcode.png";
        int width = 300;
        int height = 300;
        String charset = "UTF-8";
        HashMap<EncodeHintType, ErrorCorrectionLevel> hints = new HashMap<EncodeHintType, ErrorCorrectionLevel>();
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.L);
        String fileUrl = "";
        try {
            BitMatrix matrix = new QRCodeWriter().encode(json.toJSONString(), BarcodeFormat.QR_CODE, width, height, hints);
            Path outputPath = FileSystems.getDefault().getPath(fileName, new String[0]);
            MatrixToImageWriter.writeToPath((BitMatrix)matrix, (String)"PNG", (Path)outputPath);
            FileUploadRequestVO fileUploadRequestVO = new FileUploadRequestVO();
            byte[] fileContent = Files.readAllBytes(outputPath);
            fileUploadRequestVO.setBytes(fileContent);
            fileUploadRequestVO.setFileName(fileName);
            fileUploadRequestVO.setFileType(Integer.valueOf(1));
            ResponseData responseData = this.fileUploadFeign.simplePost(fileUploadRequestVO);
            fileUrl = ((FIleUploadResponseVO)responseData.getData()).getFileUrl();
        }
        catch (WriterException | IOException e) {
            System.err.println("Error generating QR Code: " + e.getMessage());
        }
        return fileUrl;
    }

    public ResponseData<StewardServiceDescriptionMobileRespVo> findStewardServiceDescription() {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.last("limit 1");
        StewardServiceDescriptionPO one = (StewardServiceDescriptionPO)this.stewardServiceDescriptionService.getOne((Wrapper)wrapper);
        StewardServiceDescriptionMobileRespVo stewardServiceDescriptionMobileRespVo = this.buildStewardServiceDescriptionMobileRespVo(one);
        return ResponseUtil.success((Object)stewardServiceDescriptionMobileRespVo);
    }

    private StewardServiceDescriptionMobileRespVo buildStewardServiceDescriptionMobileRespVo(StewardServiceDescriptionPO po) {
        StewardServiceDescriptionMobileRespVo respVo = new StewardServiceDescriptionMobileRespVo();
        BeanUtil.copyProperties((Object)po, (Object)respVo, (String[])new String[0]);
        return respVo;
    }

    public ResponseData<List<StewardServiceMobileRespVO>> findServiceByFlightIdentityAndDate(StewardServiceMobileReqVO reqVO) {
        BasicFlightQueryReq basicFlightQueryReq = new BasicFlightQueryReq();
        basicFlightQueryReq.setFlightIdentity(reqVO.getFlightIdentity());
        basicFlightQueryReq.setFlightDate(reqVO.getFlightScheduledDate());
        ResponseData list = this.basicFlightFeign.list(basicFlightQueryReq);
        List data = Optional.ofNullable(list.getData()).orElse(Collections.emptyList());
        if (data.isEmpty()) {
            return new ResponseData(Collections.emptyList());
        }
        String iataOriginAirport = ((BasicFlightQueryRsp)data.get(0)).getIataOriginAirport();
        String destinationAirport = ((BasicFlightQueryRsp)data.get(0)).getDestinationAirport();
        String flightDirection = ((BasicFlightQueryRsp)data.get(0)).getFlightDirection();
        String airportCode = null;
        Integer serviceTypeFilter = null;
        switch (flightDirection) {
            case "A": {
                airportCode = destinationAirport;
                serviceTypeFilter = 1;
                break;
            }
            case "D": {
                airportCode = iataOriginAirport;
                serviceTypeFilter = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid flight direction: " + flightDirection);
            }
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(StewardServicePO::getAirportCode, (Object)airportCode)).eq(StewardServicePO::getServiceType, (Object)serviceTypeFilter);
        List stewardServicePOList = this.stewardServiceService.list((Wrapper)wrapper);
        List collect = stewardServicePOList.stream().map(po -> this.buildStewardServiceMobileRespVO(po)).collect(Collectors.toList());
        return new ResponseData(collect);
    }

    private StewardServiceMobileRespVO buildStewardServiceMobileRespVO(StewardServicePO po) {
        StewardServiceMobileRespVO respVo = new StewardServiceMobileRespVO();
        BeanUtil.copyProperties((Object)po, (Object)respVo, (String[])new String[0]);
        return respVo;
    }

    public ResponseData<PageInfo<StewardOrderReqRespVO>> findOrderList(StewardOrderQueryMobileReqVo stewardOrderVO) {
        Page page = new Page((long)stewardOrderVO.getPageNum().intValue(), (long)stewardOrderVO.getPageSize().intValue());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (stewardOrderVO.getStatus() != null) {
            wrapper.eq(StewardOrderPO::getStatus, (Object)stewardOrderVO.getStatus());
        }
        wrapper.eq(StewardOrderPO::getValid, (Object)Boolean.TRUE);
        Page stewardOrderPOPage = (Page)this.stewardOrderService.page((IPage)page, (Wrapper)wrapper);
        List stewardOrderReqRespVOList = stewardOrderPOPage.getRecords().stream().map(po -> {
            StewardOrderReqRespVO stewardOrderReqRespVO = this.buildStewardOrderReqRespVO(po);
            return stewardOrderReqRespVO;
        }).collect(Collectors.toList());
        PageInfo pageInfo = new PageInfo(Long.valueOf(stewardOrderPOPage.getCurrent()).intValue(), Long.valueOf(stewardOrderPOPage.getSize()).intValue(), stewardOrderPOPage.getTotal(), stewardOrderReqRespVOList);
        return ResponseUtil.success((Object)pageInfo);
    }

    private StewardOrderReqRespVO buildStewardOrderReqRespVO(StewardOrderPO po) {
        StewardOrderReqRespVO respVo = new StewardOrderReqRespVO();
        BeanUtil.copyProperties((Object)po, (Object)respVo, (String[])new String[0]);
        return respVo;
    }

    public StewardMobileService(StewardOrderServiceImpl stewardOrderService, StewardServiceDescriptionServiceImpl stewardServiceDescriptionService, StewardServiceServiceImpl stewardServiceService, FlightRecordFeign flightRecordfeign, FileUploadFeign fileUploadFeign, BasicFlightFeign basicFlightFeign, StewardOrderServiceServiceImpl stewardOrderServiceRel) {
        this.stewardOrderService = stewardOrderService;
        this.stewardServiceDescriptionService = stewardServiceDescriptionService;
        this.stewardServiceService = stewardServiceService;
        this.flightRecordfeign = flightRecordfeign;
        this.fileUploadFeign = fileUploadFeign;
        this.basicFlightFeign = basicFlightFeign;
        this.stewardOrderServiceRel = stewardOrderServiceRel;
    }
}

