/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.bizvane.rights.api.service.SpecialPassengerService;
import com.bizvane.rights.api.service.component.ServiceComponent;
import com.bizvane.rights.api.util.UID;
import com.bizvane.rights.domain.model.entity.RightsSpecialPassengerFlightPO;
import com.bizvane.rights.domain.model.entity.RightsSpecialPassengerRecordPO;
import com.bizvane.rights.domain.service.IRightsSpecialPassengerFlightService;
import com.bizvane.rights.domain.service.IRightsSpecialPassengerRecordService;
import com.bizvane.rights.domain.util.ResponseUtil;
import com.bizvane.rights.vo.special.RightsSpecialPassengerFlightDetailVO;
import com.bizvane.rights.vo.special.RightsSpecialPassengerSaveRequestVO;
import com.bizvane.utils.responseinfo.ResponseData;
import java.time.LocalDateTime;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SpecialPassengerServiceImpl
implements SpecialPassengerService {
    private final IRightsSpecialPassengerRecordService rightsSpecialPassengerRecordService;
    private final IRightsSpecialPassengerFlightService rightsSpecialPassengerFlightService;
    private final ServiceComponent serviceComponent;

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<Boolean> addOrUpdate(RightsSpecialPassengerSaveRequestVO requestVO) {
        RightsSpecialPassengerRecordPO specialPassengerRecordPO = this.rightsSpecialPassengerRecordService.detailByAppointmentRecordNo(requestVO.getAppointmentRecordNo());
        if (specialPassengerRecordPO == null) {
            return this.addSpecialPassenger(requestVO);
        }
        return this.updateSpecialPassenger(requestVO, specialPassengerRecordPO);
    }

    @NotNull
    private ResponseData updateSpecialPassenger(RightsSpecialPassengerSaveRequestVO requestVO, RightsSpecialPassengerRecordPO specialPassengerRecordPO) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(RightsSpecialPassengerRecordPO::getMbrMembersCode, (Object)requestVO.getMbrMembersCode())).set(RightsSpecialPassengerRecordPO::getMerchantNo, (Object)requestVO.getMerchantNo())).set(RightsSpecialPassengerRecordPO::getAppointmentRecordNo, (Object)requestVO.getAppointmentRecordNo())).set(RightsSpecialPassengerRecordPO::getServiceTargetType, (Object)requestVO.getServiceTargetType())).set(RightsSpecialPassengerRecordPO::getContactNumber, (Object)requestVO.getContactNumber())).set(RightsSpecialPassengerRecordPO::getContactNumberEncrypt, (Object)requestVO.getContactNumberEncrypt())).set(RightsSpecialPassengerRecordPO::getRequiresWheelchair, (Object)requestVO.getRequiresWheelchair())).set(RightsSpecialPassengerRecordPO::getPassengerInfo, (Object)requestVO.getPassengerInfo())).set(RightsSpecialPassengerRecordPO::getRemarks, (Object)requestVO.getRemarks())).set(RightsSpecialPassengerRecordPO::getAppointmentTime, (Object)requestVO.getAppointmentTime())).set(RightsSpecialPassengerRecordPO::getAppointmentStatus, (Object)requestVO.getAppointmentStatus())).set(RightsSpecialPassengerRecordPO::getModifiedDate, (Object)LocalDateTime.now())).set(RightsSpecialPassengerRecordPO::getModifiedUserCode, (Object)requestVO.getOptUserCode())).set(RightsSpecialPassengerRecordPO::getModifiedUserName, (Object)requestVO.getOptUserName())).eq(RightsSpecialPassengerRecordPO::getRightsSpecialPassengerRecordCode, (Object)specialPassengerRecordPO.getRightsSpecialPassengerRecordCode());
        boolean update = this.rightsSpecialPassengerRecordService.update((Wrapper)updateWrapper);
        if (update) {
            this.updateSpecialPassengerFlightInfo(requestVO, specialPassengerRecordPO);
            this.serviceComponent.syncSpecialPassengerAsync(specialPassengerRecordPO.getRightsSpecialPassengerRecordCode());
        }
        return ResponseUtil.success((Object)update);
    }

    private void updateSpecialPassengerFlightInfo(RightsSpecialPassengerSaveRequestVO requestVO, RightsSpecialPassengerRecordPO specialPassengerRecordPO) {
        RightsSpecialPassengerFlightPO rightsSpecialPassengerFlightPO = this.rightsSpecialPassengerFlightService.queryByRightsSpecialPassengerRecordCode(specialPassengerRecordPO.getRightsSpecialPassengerRecordCode());
        RightsSpecialPassengerFlightDetailVO flightInfo = requestVO.getFlightInfo();
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(RightsSpecialPassengerFlightPO::getEstimatedDepartureTime, (Object)flightInfo.getEstimatedDepartureTime())).set(RightsSpecialPassengerFlightPO::getFlightType, (Object)flightInfo.getFlightType())).set(RightsSpecialPassengerFlightPO::getFlightNumber, (Object)flightInfo.getFlightNumber())).set(RightsSpecialPassengerFlightPO::getAppointmentLocation, (Object)flightInfo.getAppointmentLocation())).set(RightsSpecialPassengerFlightPO::getModifiedDate, (Object)LocalDateTime.now())).set(RightsSpecialPassengerFlightPO::getModifiedUserCode, (Object)requestVO.getOptUserCode())).set(RightsSpecialPassengerFlightPO::getModifiedUserName, (Object)requestVO.getOptUserName())).eq(RightsSpecialPassengerFlightPO::getRightsSpecialPassengerFlightCode, (Object)rightsSpecialPassengerFlightPO.getRightsSpecialPassengerFlightCode());
        this.rightsSpecialPassengerFlightService.update((Wrapper)updateWrapper);
    }

    @NotNull
    private ResponseData addSpecialPassenger(RightsSpecialPassengerSaveRequestVO requestVO) {
        RightsSpecialPassengerRecordPO specialPassengerRecordPOAdd = new RightsSpecialPassengerRecordPO();
        specialPassengerRecordPOAdd.setRightsSpecialPassengerRecordCode(UID.getUid());
        specialPassengerRecordPOAdd.setMbrMembersCode(requestVO.getMbrMembersCode());
        specialPassengerRecordPOAdd.setMerchantNo(requestVO.getMerchantNo());
        specialPassengerRecordPOAdd.setAppointmentRecordNo(requestVO.getAppointmentRecordNo());
        specialPassengerRecordPOAdd.setServiceTargetType(requestVO.getServiceTargetType());
        specialPassengerRecordPOAdd.setContactNumber(requestVO.getContactNumber());
        specialPassengerRecordPOAdd.setContactNumberEncrypt(requestVO.getContactNumberEncrypt());
        specialPassengerRecordPOAdd.setRequiresWheelchair(requestVO.getRequiresWheelchair());
        specialPassengerRecordPOAdd.setPassengerInfo(requestVO.getPassengerInfo());
        specialPassengerRecordPOAdd.setRemarks(requestVO.getRemarks());
        specialPassengerRecordPOAdd.setAppointmentTime(requestVO.getAppointmentTime());
        specialPassengerRecordPOAdd.setAppointmentStatus(requestVO.getAppointmentStatus());
        specialPassengerRecordPOAdd.setCreateUserCode(requestVO.getOptUserCode());
        specialPassengerRecordPOAdd.setCreateUserName(requestVO.getOptUserName());
        boolean save = this.rightsSpecialPassengerRecordService.save((Object)specialPassengerRecordPOAdd);
        RightsSpecialPassengerFlightDetailVO rightsSpecialPassengerFlightDetailVO = requestVO.getFlightInfo();
        RightsSpecialPassengerFlightPO rightsSpecialPassengerFlightPO = new RightsSpecialPassengerFlightPO();
        rightsSpecialPassengerFlightPO.setEstimatedDepartureTime(rightsSpecialPassengerFlightDetailVO.getEstimatedDepartureTime());
        rightsSpecialPassengerFlightPO.setFlightType(rightsSpecialPassengerFlightDetailVO.getFlightType());
        rightsSpecialPassengerFlightPO.setFlightNumber(rightsSpecialPassengerFlightDetailVO.getFlightNumber());
        rightsSpecialPassengerFlightPO.setAppointmentLocation(rightsSpecialPassengerFlightDetailVO.getAppointmentLocation());
        rightsSpecialPassengerFlightPO.setRightsSpecialPassengerRecordCode(specialPassengerRecordPOAdd.getRightsSpecialPassengerRecordCode());
        rightsSpecialPassengerFlightPO.setRightsSpecialPassengerFlightCode(UID.getUid());
        rightsSpecialPassengerFlightPO.setCreateUserCode(requestVO.getOptUserCode());
        rightsSpecialPassengerFlightPO.setCreateUserName(requestVO.getOptUserName());
        this.rightsSpecialPassengerFlightService.save((Object)rightsSpecialPassengerFlightPO);
        if (save) {
            this.serviceComponent.syncSpecialPassengerAsync(specialPassengerRecordPOAdd.getRightsSpecialPassengerRecordCode());
        }
        return ResponseUtil.success((Object)save);
    }

    public SpecialPassengerServiceImpl(IRightsSpecialPassengerRecordService rightsSpecialPassengerRecordService, IRightsSpecialPassengerFlightService rightsSpecialPassengerFlightService, ServiceComponent serviceComponent) {
        this.rightsSpecialPassengerRecordService = rightsSpecialPassengerRecordService;
        this.rightsSpecialPassengerFlightService = rightsSpecialPassengerFlightService;
        this.serviceComponent = serviceComponent;
    }
}

