/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.bizvane.rights.api.service.ServiceRecordService;
import com.bizvane.rights.api.service.component.MessageComponent;
import com.bizvane.rights.api.util.UID;
import com.bizvane.rights.domain.model.entity.RightsServiceRecordPO;
import com.bizvane.rights.domain.service.IRightsServiceRecordService;
import com.bizvane.rights.domain.util.ResponseUtil;
import com.bizvane.rights.vo.service.RightsServiceRecordAddRequestVO;
import com.bizvane.utils.responseinfo.ResponseData;
import java.time.LocalDateTime;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ServiceRecordServiceImpl
implements ServiceRecordService {
    private static final Logger log = LoggerFactory.getLogger(ServiceRecordServiceImpl.class);
    private final IRightsServiceRecordService serviceRecordService;
    private final MessageComponent messageComponent;

    public ResponseData<Boolean> addOrUpdate(RightsServiceRecordAddRequestVO requestVO) {
        RightsServiceRecordPO rightsServiceRecordPO = this.serviceRecordService.detailByServiceTypeAndCode(requestVO.getServiceType(), requestVO.getServiceCode());
        if (rightsServiceRecordPO == null) {
            return this.addServiceRecord(requestVO);
        }
        return this.updateServiceRecord(requestVO, rightsServiceRecordPO);
    }

    @NotNull
    private ResponseData<Boolean> updateServiceRecord(RightsServiceRecordAddRequestVO requestVO, RightsServiceRecordPO rightsServiceRecordPO) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(RightsServiceRecordPO::getMbrMembersCode, (Object)requestVO.getMbrMembersCode())).set(RightsServiceRecordPO::getMerchantNo, (Object)requestVO.getMerchantNo())).set(RightsServiceRecordPO::getServiceType, (Object)requestVO.getServiceType())).set(RightsServiceRecordPO::getServiceCode, (Object)requestVO.getServiceCode())).set(RightsServiceRecordPO::getReservationRecordNo, (Object)requestVO.getReservationRecordNo())).set(RightsServiceRecordPO::getAppointmentStatus, (Object)requestVO.getAppointmentStatus())).set(RightsServiceRecordPO::getAppointmentLocation, (Object)requestVO.getAppointmentLocation())).set(RightsServiceRecordPO::getAppointmentTime, (Object)requestVO.getAppointmentTime())).set(RightsServiceRecordPO::getServiceTargetType, (Object)requestVO.getServiceTargetType())).set(RightsServiceRecordPO::getModifiedUserCode, (Object)requestVO.getOptUserCode())).set(RightsServiceRecordPO::getModifiedUserName, (Object)requestVO.getOptUserName())).eq(RightsServiceRecordPO::getRightsServiceRecordCode, (Object)rightsServiceRecordPO.getRightsServiceRecordCode());
        boolean update = this.serviceRecordService.update((Wrapper)updateWrapper);
        if (update) {
            this.messageComponent.sendMsg(requestVO, Boolean.valueOf(update));
        }
        return ResponseUtil.success((Object)update);
    }

    @NotNull
    private ResponseData<Boolean> addServiceRecord(RightsServiceRecordAddRequestVO requestVO) {
        RightsServiceRecordPO serviceRecordPO = new RightsServiceRecordPO();
        serviceRecordPO.setMbrMembersCode(requestVO.getMbrMembersCode());
        serviceRecordPO.setMerchantNo(requestVO.getMerchantNo());
        serviceRecordPO.setServiceType(requestVO.getServiceType());
        serviceRecordPO.setServiceCode(requestVO.getServiceCode());
        serviceRecordPO.setReservationRecordNo(requestVO.getReservationRecordNo());
        serviceRecordPO.setAppointmentStatus(requestVO.getAppointmentStatus());
        serviceRecordPO.setAppointmentLocation(requestVO.getAppointmentLocation());
        serviceRecordPO.setAppointmentTime(requestVO.getAppointmentTime());
        serviceRecordPO.setServiceTargetType(requestVO.getServiceTargetType());
        serviceRecordPO.setRightsServiceRecordCode(UID.getUid());
        serviceRecordPO.setCreateUserCode(requestVO.getOptUserCode());
        serviceRecordPO.setCreateUserName(requestVO.getOptUserName());
        serviceRecordPO.setCreateDate(LocalDateTime.now());
        boolean save = this.serviceRecordService.save((Object)serviceRecordPO);
        if (save) {
            this.messageComponent.sendMsg(requestVO, Boolean.valueOf(save));
        }
        return ResponseUtil.success((Object)save);
    }

    public ServiceRecordServiceImpl(IRightsServiceRecordService serviceRecordService, MessageComponent messageComponent) {
        this.serviceRecordService = serviceRecordService;
        this.messageComponent = messageComponent;
    }
}

