/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bizvane.rights.api.service.HotelRoomSituationService;
import com.bizvane.rights.api.util.UID;
import com.bizvane.rights.domain.enums.HotelRoomSituationOptionTypeEnum;
import com.bizvane.rights.domain.model.entity.RightsHotelOrderDetailPO;
import com.bizvane.rights.domain.model.entity.RightsHotelRoomSituationLogPO;
import com.bizvane.rights.domain.model.entity.RightsHotelRoomSituationPO;
import com.bizvane.rights.domain.model.entity.RightsHotelRoomTypePO;
import com.bizvane.rights.domain.service.IRightsHotelOrderDetailService;
import com.bizvane.rights.domain.service.IRightsHotelRoomSituationLogService;
import com.bizvane.rights.domain.service.IRightsHotelRoomSituationService;
import com.bizvane.rights.domain.service.IRightsHotelRoomTypeService;
import com.bizvane.rights.domain.util.LocalDateUtils;
import com.bizvane.rights.domain.util.ResponseUtil;
import com.bizvane.rights.domain.util.RightsHotelRoomSituationUtil;
import com.bizvane.rights.vo.OptUserVO;
import com.bizvane.rights.vo.hotel.roomsituation.RightsHotelRoomSituationBatchUpdateRequestVO;
import com.bizvane.rights.vo.hotel.roomsituation.RightsHotelRoomSituationBatchUpdateResponseVO;
import com.bizvane.rights.vo.hotel.roomsituation.RightsHotelRoomSituationDaysConditionRequestVO;
import com.bizvane.rights.vo.hotel.roomsituation.RightsHotelRoomSituationDaysConditionResponseVO;
import com.bizvane.rights.vo.hotel.roomsituation.RightsHotelRoomSituationDaysRequestVO;
import com.bizvane.rights.vo.hotel.roomsituation.table.TableHeaderVO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class HotelRoomSituationServiceImpl
implements HotelRoomSituationService {
    private static final Logger log = LoggerFactory.getLogger(HotelRoomSituationServiceImpl.class);
    private final IRightsHotelRoomTypeService rightsHotelRoomTypeService;
    private final IRightsHotelRoomSituationService rightsHotelRoomSituationService;
    private final IRightsHotelRoomSituationLogService rightsHotelRoomSituationLogService;
    private final IRightsHotelOrderDetailService rightsHotelOrderDetailService;

    public ResponseData<RightsHotelRoomSituationDaysConditionResponseVO> detailRoomSituationByDays(RightsHotelRoomSituationDaysRequestVO requestVO) {
        LocalDate startDate = requestVO.getCurrentDate();
        LocalDate endDate = requestVO.getCurrentDate();
        RightsHotelRoomSituationDaysConditionResponseVO responseVO = new RightsHotelRoomSituationDaysConditionResponseVO();
        LinkedList tableHeader = RightsHotelRoomSituationUtil.getTableHeader((LocalDate)startDate, (LocalDate)endDate);
        responseVO.setColumnList((List)tableHeader);
        String rightsHotelRoomTypeCode = requestVO.getRightsHotelRoomTypeCode();
        RightsHotelRoomTypePO rightsHotelRoomTypePO = this.rightsHotelRoomTypeService.detailByCode(rightsHotelRoomTypeCode);
        if (rightsHotelRoomTypePO == null) {
            return ResponseUtil.of((SysResponseEnum)SysResponseEnum.RIGHTS_HOTEL_ROOM_TYPE_CODE_EXISTS);
        }
        LinkedList dynamicList = this.getDynamicList(startDate, endDate, tableHeader, rightsHotelRoomTypePO);
        responseVO.setList(Arrays.asList(dynamicList));
        return ResponseUtil.success((Object)responseVO);
    }

    public ResponseData batchUpdateRoomSituation(RightsHotelRoomSituationBatchUpdateRequestVO requestVO) {
        List localDates = LocalDateUtils.datesUntilWithEnd((LocalDate)requestVO.getStartDate(), (LocalDate)requestVO.getEndDate());
        List rightsHotelRoomTypePOS = this.rightsHotelRoomTypeService.listByRightsHotelCodeAndRoomTypeCodeList(requestVO.getRightsHotelCode(), requestVO.getRightsHotelRoomTypeCodeList());
        if (CollectionUtils.isEmpty((Collection)rightsHotelRoomTypePOS)) {
            return ResponseUtil.success(null, (String)"\u6ca1\u6709\u6709\u6548\u7684\u623f\u578b");
        }
        ArrayList failList = new ArrayList();
        for (RightsHotelRoomTypePO rightsHotelRoomTypePO : rightsHotelRoomTypePOS) {
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(RightsHotelRoomSituationPO::getRightsHotelRoomTypeCode, new Object[]{rightsHotelRoomTypePO.getRightsHotelRoomTypeCode()})).in(RightsHotelRoomSituationPO::getDayDate, (Collection)localDates);
            List hotelRoomSituationPOList = this.rightsHotelRoomSituationService.list((Wrapper)queryWrapper);
            ArrayList notExistsLocalDates = new ArrayList();
            if (CollectionUtils.isEmpty((Collection)hotelRoomSituationPOList)) {
                notExistsLocalDates.addAll(localDates);
            } else {
                ArrayList localDatesNew = new ArrayList(localDates);
                List existsLocalDates = hotelRoomSituationPOList.stream().map(RightsHotelRoomSituationPO::getDayDate).distinct().collect(Collectors.toList());
                if (localDatesNew.removeAll(existsLocalDates)) {
                    notExistsLocalDates.addAll(localDatesNew);
                }
                List failUpdateList = this.updateBatchRoomSituation(hotelRoomSituationPOList, requestVO);
                failList.addAll(failUpdateList);
            }
            if (!CollectionUtils.isNotEmpty(notExistsLocalDates)) continue;
            this.initBatchRoomSituation(rightsHotelRoomTypePO, notExistsLocalDates, requestVO);
        }
        RightsHotelRoomSituationBatchUpdateResponseVO responseVO = new RightsHotelRoomSituationBatchUpdateResponseVO();
        responseVO.setFailCount(Integer.valueOf(failList.size()));
        return ResponseUtil.success((Object)responseVO);
    }

    public ResponseData<RightsHotelRoomSituationDaysConditionResponseVO> listRoomSituationByDaysCondition(RightsHotelRoomSituationDaysConditionRequestVO requestVO) {
        RightsHotelRoomSituationDaysConditionResponseVO responseVO = new RightsHotelRoomSituationDaysConditionResponseVO();
        LinkedList tableHeader = RightsHotelRoomSituationUtil.getTableHeader((LocalDate)requestVO.getStartDate(), (LocalDate)requestVO.getEndDate());
        responseVO.setColumnList((List)tableHeader);
        List hotelRoomTypePOList = this.rightsHotelRoomTypeService.listByRightsHotelCode(requestVO.getRightsHotelCode());
        if (CollectionUtils.isEmpty((Collection)hotelRoomTypePOList)) {
            return ResponseUtil.success((Object)responseVO);
        }
        LinkedList<LinkedList> list = new LinkedList<LinkedList>();
        for (RightsHotelRoomTypePO rightsHotelRoomTypePO : hotelRoomTypePOList) {
            LinkedList daysDetailResponseVOLinkedList = this.getDynamicList(requestVO.getStartDate(), requestVO.getEndDate(), tableHeader, rightsHotelRoomTypePO);
            list.add(daysDetailResponseVOLinkedList);
        }
        responseVO.setList(list);
        return ResponseUtil.success((Object)responseVO);
    }

    @NotNull
    private LinkedList<JSONObject> getDynamicList(LocalDate startDate, LocalDate endDate, LinkedList<TableHeaderVO> tableHeader, RightsHotelRoomTypePO rightsHotelRoomTypePO) {
        LinkedList<JSONObject> daysDetailResponseVOLinkedList = new LinkedList<JSONObject>();
        JSONObject first = new JSONObject();
        first.put("first", (Object)this.getDefaultJson(rightsHotelRoomTypePO, null, null));
        daysDetailResponseVOLinkedList.add(first);
        JSONObject custom_one = new JSONObject();
        custom_one.put("custom_one", (Object)this.getDefaultJson(rightsHotelRoomTypePO, null, null));
        daysDetailResponseVOLinkedList.add(custom_one);
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RightsHotelRoomSituationPO::getRightsHotelRoomTypeCode, (Object)rightsHotelRoomTypePO.getRightsHotelRoomTypeCode())).between(RightsHotelRoomSituationPO::getDayDate, (Object)startDate, (Object)endDate);
        Map<LocalDate, JSONObject> situationDetailResponseVOMap = this.rightsHotelRoomSituationService.list((Wrapper)queryWrapper).stream().collect(Collectors.toMap(RightsHotelRoomSituationPO::getDayDate, hotelRoomSituationPO -> {
            String dateString = RightsHotelRoomSituationUtil.formatYMD((LocalDate)hotelRoomSituationPO.getDayDate());
            JSONObject jsonObject = this.getDefaultJson(rightsHotelRoomTypePO, dateString, hotelRoomSituationPO);
            return jsonObject;
        }));
        for (int i = 2; i < tableHeader.size(); ++i) {
            TableHeaderVO tableHeaderVO = tableHeader.get(i);
            JSONObject defaultJson = this.getDefaultJson(rightsHotelRoomTypePO, RightsHotelRoomSituationUtil.formatYMD((LocalDate)tableHeaderVO.getLocalDate()), null);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(tableHeaderVO.getKey(), (Object)situationDetailResponseVOMap.getOrDefault(tableHeaderVO.getLocalDate(), defaultJson));
            daysDetailResponseVOLinkedList.add(jsonObject);
        }
        return daysDetailResponseVOLinkedList;
    }

    private JSONObject getDefaultJson(RightsHotelRoomTypePO rightsHotelRoomTypePO, String localDateString, RightsHotelRoomSituationPO hotelRoomSituationPO) {
        JSONObject defaultJson = new JSONObject();
        if (hotelRoomSituationPO == null) {
            defaultJson.put("salesVolume", (Object)0);
            defaultJson.put("availableStock", (Object)0);
            defaultJson.put("totalStock", (Object)0);
        } else {
            defaultJson.put("salesVolume", (Object)hotelRoomSituationPO.getSalesVolume());
            defaultJson.put("availableStock", (Object)hotelRoomSituationPO.getTotalStock());
            defaultJson.put("totalStock", (Object)hotelRoomSituationPO.getTotalStock());
        }
        defaultJson.put("rightsHotelRoomTypeCode", (Object)rightsHotelRoomTypePO.getRightsHotelRoomTypeCode());
        defaultJson.put("localDate", (Object)localDateString);
        defaultJson.put("roomTypeName", (Object)rightsHotelRoomTypePO.getRoomTypeName());
        return defaultJson;
    }

    private void initBatchRoomSituation(RightsHotelRoomTypePO rightsHotelRoomTypePO, List<LocalDate> localDates, RightsHotelRoomSituationBatchUpdateRequestVO requestVO) {
        ArrayList<RightsHotelRoomSituationPO> rightsHotelRoomSituationPOList = new ArrayList<RightsHotelRoomSituationPO>();
        for (LocalDate localDate : localDates) {
            RightsHotelRoomSituationPO rightsHotelRoomSituationPO = new RightsHotelRoomSituationPO();
            rightsHotelRoomSituationPO.setRightsHotelRoomSituationCode(UID.getUid());
            rightsHotelRoomSituationPO.setRightsHotelRoomTypeCode(rightsHotelRoomTypePO.getRightsHotelRoomTypeCode());
            rightsHotelRoomSituationPO.setRightsHotelCode(rightsHotelRoomTypePO.getRightsHotelCode());
            rightsHotelRoomSituationPO.setDayDate(localDate);
            rightsHotelRoomSituationPO.setTotalStock(requestVO.getTotalStock());
            rightsHotelRoomSituationPO.setSalesVolume(Integer.valueOf(0));
            rightsHotelRoomSituationPO.setCreateUserName(requestVO.getOptUserName());
            rightsHotelRoomSituationPO.setCreateUserCode(requestVO.getOptUserCode());
            rightsHotelRoomSituationPOList.add(rightsHotelRoomSituationPO);
        }
        this.rightsHotelRoomSituationService.saveBatch(rightsHotelRoomSituationPOList);
        ArrayList<RightsHotelRoomSituationLogPO> rightsHotelRoomSituationLogPOList = new ArrayList<RightsHotelRoomSituationLogPO>();
        for (RightsHotelRoomSituationPO rightsHotelRoomSituationPO : rightsHotelRoomSituationPOList) {
            String jsonString = JSON.toJSONString((Object)rightsHotelRoomSituationPO);
            RightsHotelRoomSituationLogPO rightsHotelRoomSituationLogPO = new RightsHotelRoomSituationLogPO();
            rightsHotelRoomSituationLogPO.setRightsHotelRoomSituationCode(rightsHotelRoomSituationPO.getRightsHotelRoomSituationCode());
            rightsHotelRoomSituationLogPO.setOldHotelRoomSituation(jsonString);
            rightsHotelRoomSituationLogPO.setDayDate(rightsHotelRoomSituationPO.getDayDate());
            rightsHotelRoomSituationLogPO.setOldTotalStock(Integer.valueOf(0));
            rightsHotelRoomSituationLogPO.setOldSalesVolume(Integer.valueOf(0));
            rightsHotelRoomSituationLogPO.setNewTotalStock(rightsHotelRoomSituationPO.getTotalStock());
            rightsHotelRoomSituationLogPO.setType(HotelRoomSituationOptionTypeEnum.FILED_5.getType());
            rightsHotelRoomSituationLogPO.setCreateUserCode(requestVO.getOptUserName());
            rightsHotelRoomSituationLogPO.setCreateUserName(requestVO.getOptUserName());
            rightsHotelRoomSituationLogPOList.add(rightsHotelRoomSituationLogPO);
        }
        this.rightsHotelRoomSituationLogService.saveBatch(rightsHotelRoomSituationLogPOList);
    }

    private List<RightsHotelRoomSituationPO> updateBatchRoomSituation(List<RightsHotelRoomSituationPO> hotelRoomSituationPOList, RightsHotelRoomSituationBatchUpdateRequestVO requestVO) {
        ArrayList<RightsHotelRoomSituationPO> updateList = new ArrayList<RightsHotelRoomSituationPO>();
        ArrayList<RightsHotelRoomSituationLogPO> rightsHotelRoomSituationLogPOList = new ArrayList<RightsHotelRoomSituationLogPO>();
        for (RightsHotelRoomSituationPO rightsHotelRoomSituationPO : hotelRoomSituationPOList) {
            long updateStock = this.rightsHotelRoomSituationService.updateStock(rightsHotelRoomSituationPO.getRightsHotelRoomSituationCode(), requestVO.getTotalStock(), rightsHotelRoomSituationPO.getVersion(), (OptUserVO)requestVO);
            log.info("rightsHotelRoomSituationCode:{}  day:{}  updateStock:{}", new Object[]{rightsHotelRoomSituationPO.getRightsHotelRoomSituationCode(), rightsHotelRoomSituationPO.getDayDate(), updateStock});
            if (updateStock > 0L) {
                String jsonString = JSON.toJSONString((Object)rightsHotelRoomSituationPO);
                RightsHotelRoomSituationLogPO rightsHotelRoomSituationLogPO = new RightsHotelRoomSituationLogPO();
                rightsHotelRoomSituationLogPO.setRightsHotelRoomSituationCode(rightsHotelRoomSituationPO.getRightsHotelRoomSituationCode());
                rightsHotelRoomSituationLogPO.setOldHotelRoomSituation(jsonString);
                rightsHotelRoomSituationLogPO.setDayDate(rightsHotelRoomSituationPO.getDayDate());
                rightsHotelRoomSituationLogPO.setOldTotalStock(rightsHotelRoomSituationPO.getTotalStock());
                rightsHotelRoomSituationLogPO.setOldSalesVolume(rightsHotelRoomSituationPO.getSalesVolume());
                rightsHotelRoomSituationLogPO.setNewTotalStock(requestVO.getTotalStock());
                rightsHotelRoomSituationLogPO.setType(HotelRoomSituationOptionTypeEnum.FILED_4.getType());
                rightsHotelRoomSituationLogPO.setCreateUserCode(requestVO.getOptUserName());
                rightsHotelRoomSituationLogPO.setCreateUserName(requestVO.getOptUserName());
                rightsHotelRoomSituationLogPOList.add(rightsHotelRoomSituationLogPO);
                continue;
            }
            updateList.add(rightsHotelRoomSituationPO);
        }
        this.rightsHotelRoomSituationLogService.saveBatch(rightsHotelRoomSituationLogPOList);
        return updateList;
    }

    public void addBatchStock(String rightsHotelOrderCode, HotelRoomSituationOptionTypeEnum hotelRoomSituationOptionTypeEnum) {
        List rightsHotelOrderDetailPOS = this.rightsHotelOrderDetailService.listByRightsHotelOrderCode(rightsHotelOrderCode);
        List rightsHotelRoomSituationCodeList = rightsHotelOrderDetailPOS.stream().map(RightsHotelOrderDetailPO::getRightsHotelRoomSituationCode).collect(Collectors.toList());
        this.rightsHotelRoomSituationService.addStockBatch(rightsHotelRoomSituationCodeList, ((RightsHotelOrderDetailPO)rightsHotelOrderDetailPOS.get(0)).getQuantity(), null);
        ArrayList<RightsHotelRoomSituationLogPO> rightsHotelRoomSituationLogPOList = new ArrayList<RightsHotelRoomSituationLogPO>();
        for (RightsHotelOrderDetailPO rightsHotelOrderDetailPO : rightsHotelOrderDetailPOS) {
            RightsHotelRoomSituationPO rightsHotelRoomSituationPO = this.rightsHotelRoomSituationService.detailByCode(rightsHotelOrderDetailPO.getRightsHotelRoomSituationCode());
            RightsHotelRoomSituationLogPO rightsHotelRoomSituationLogPO = new RightsHotelRoomSituationLogPO();
            rightsHotelRoomSituationLogPO.setRightsHotelRoomSituationCode(rightsHotelOrderDetailPO.getRightsHotelRoomSituationCode());
            rightsHotelRoomSituationLogPO.setOldHotelRoomSituation(JSON.toJSONString((Object)rightsHotelRoomSituationPO));
            rightsHotelRoomSituationLogPO.setDayDate(rightsHotelRoomSituationPO.getDayDate());
            rightsHotelRoomSituationLogPO.setOldTotalStock(rightsHotelRoomSituationPO.getTotalStock());
            rightsHotelRoomSituationLogPO.setOldSalesVolume(rightsHotelRoomSituationPO.getSalesVolume());
            rightsHotelRoomSituationLogPO.setNewTotalStock(Integer.valueOf(rightsHotelRoomSituationPO.getTotalStock() + rightsHotelOrderDetailPO.getQuantity()));
            rightsHotelRoomSituationLogPO.setType(hotelRoomSituationOptionTypeEnum.getType());
            rightsHotelRoomSituationLogPOList.add(rightsHotelRoomSituationLogPO);
        }
        this.rightsHotelRoomSituationLogService.saveBatch(rightsHotelRoomSituationLogPOList);
    }

    public HotelRoomSituationServiceImpl(IRightsHotelRoomTypeService rightsHotelRoomTypeService, IRightsHotelRoomSituationService rightsHotelRoomSituationService, IRightsHotelRoomSituationLogService rightsHotelRoomSituationLogService, IRightsHotelOrderDetailService rightsHotelOrderDetailService) {
        this.rightsHotelRoomTypeService = rightsHotelRoomTypeService;
        this.rightsHotelRoomSituationService = rightsHotelRoomSituationService;
        this.rightsHotelRoomSituationLogService = rightsHotelRoomSituationLogService;
        this.rightsHotelOrderDetailService = rightsHotelOrderDetailService;
    }
}

