/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.service.impl;

import com.bizvane.rights.api.service.HotelMobileService;
import com.bizvane.rights.domain.model.bo.RightsHotelRoomTypeStockBO;
import com.bizvane.rights.domain.model.entity.RightsHotelPO;
import com.bizvane.rights.domain.model.entity.RightsHotelRoomTypePO;
import com.bizvane.rights.domain.service.IRightsHotelRoomSituationService;
import com.bizvane.rights.domain.service.IRightsHotelRoomTypeService;
import com.bizvane.rights.domain.service.IRightsHotelService;
import com.bizvane.rights.domain.util.LocalDateUtils;
import com.bizvane.rights.domain.util.ResponseUtil;
import com.bizvane.rights.vo.hotel.order.mobile.RightsHotelDetailRequestVO;
import com.bizvane.rights.vo.hotel.order.mobile.RightsHotelDetailResponseVO;
import com.bizvane.rights.vo.hotel.order.mobile.RightsHotelRoomTypeDetailRequestVO;
import com.bizvane.rights.vo.hotel.order.mobile.RightsHotelRoomTypeDetailResponseVO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class HotelMobileServiceImpl
implements HotelMobileService {
    private static final Logger log = LoggerFactory.getLogger(HotelMobileServiceImpl.class);
    private final IRightsHotelService rightsHotelService;
    private final IRightsHotelRoomTypeService rightsHotelRoomTypeService;
    private final IRightsHotelRoomSituationService rightsHotelRoomSituationService;

    public ResponseData<RightsHotelDetailResponseVO> detail(RightsHotelDetailRequestVO requestVO) {
        RightsHotelPO rightsHotelPO = this.rightsHotelService.detailByCode(requestVO.getRightsHotelCode());
        if (rightsHotelPO == null || !rightsHotelPO.getEnableStatus().booleanValue()) {
            return ResponseUtil.of((SysResponseEnum)SysResponseEnum.RIGHTS_HOTEL_NOT_ENABLE);
        }
        RightsHotelDetailResponseVO responseVO = new RightsHotelDetailResponseVO();
        responseVO.setRightsHotelCode(rightsHotelPO.getRightsHotelCode());
        responseVO.setHotelName(rightsHotelPO.getHotelName());
        responseVO.setHotelCode(rightsHotelPO.getHotelCode());
        responseVO.setHotelPhone(rightsHotelPO.getHotelPhone());
        responseVO.setHotelAddress(rightsHotelPO.getHotelAddress());
        responseVO.setMainImage(rightsHotelPO.getMainImage());
        responseVO.setOtherImage(rightsHotelPO.getOtherImage());
        responseVO.setHotelSummary(rightsHotelPO.getHotelSummary());
        responseVO.setHotelIntroduction(rightsHotelPO.getHotelIntroduction());
        responseVO.setHotelAgreement(rightsHotelPO.getHotelAgreement());
        responseVO.setEnableStatus(rightsHotelPO.getEnableStatus());
        responseVO.setLongitude(rightsHotelPO.getLongitude());
        responseVO.setLatitude(rightsHotelPO.getLatitude());
        responseVO.setRemark(rightsHotelPO.getRemark());
        responseVO.setLatestCancellationTime(rightsHotelPO.getLatestCancellationTime());
        return ResponseUtil.success((Object)responseVO);
    }

    public ResponseData<List<RightsHotelRoomTypeDetailResponseVO>> listRoomType(RightsHotelRoomTypeDetailRequestVO requestVO) {
        List localDates = LocalDateUtils.datesUntil((LocalDate)requestVO.getStartDate(), (LocalDate)requestVO.getEndDate());
        List rightsHotelRoomTypePOS = this.rightsHotelRoomTypeService.listByRightsHotelCode(requestVO.getRightsHotelCode());
        if (CollectionUtils.isEmpty((Collection)rightsHotelRoomTypePOS)) {
            return ResponseUtil.success(new ArrayList());
        }
        List responseVOList = this.getHotelRoomTypeDetailList(localDates, rightsHotelRoomTypePOS);
        return ResponseUtil.success((Object)responseVOList);
    }

    private List<RightsHotelRoomTypeDetailResponseVO> getHotelRoomTypeDetailList(List<LocalDate> localDates, List<RightsHotelRoomTypePO> rightsHotelRoomTypePOS) {
        List rightsHotelRoomTypeCodeList = rightsHotelRoomTypePOS.stream().map(RightsHotelRoomTypePO::getRightsHotelRoomTypeCode).collect(Collectors.toList());
        ArrayList<RightsHotelRoomTypeDetailResponseVO> responseVOList = new ArrayList<RightsHotelRoomTypeDetailResponseVO>();
        Map roomTypeStockBOMap = this.rightsHotelRoomTypeService.listStockByrightsHotelRoomTypeCodeList(rightsHotelRoomTypeCodeList, localDates).stream().filter(rightsHotelRoomTypeStockBO -> StringUtils.isNotBlank((CharSequence)rightsHotelRoomTypeStockBO.getRightsHotelRoomTypeCode())).collect(Collectors.toMap(RightsHotelRoomTypeStockBO::getRightsHotelRoomTypeCode, Function.identity()));
        for (RightsHotelRoomTypePO rightsHotelRoomTypePO : rightsHotelRoomTypePOS) {
            RightsHotelRoomTypeDetailResponseVO responseVO = new RightsHotelRoomTypeDetailResponseVO();
            responseVO.setRightsHotelRoomTypeCode(rightsHotelRoomTypePO.getRightsHotelRoomTypeCode());
            responseVO.setRightsHotelCode(rightsHotelRoomTypePO.getRightsHotelCode());
            responseVO.setRoomTypeName(rightsHotelRoomTypePO.getRoomTypeName());
            responseVO.setRoomTypeCode(rightsHotelRoomTypePO.getRoomTypeCode());
            responseVO.setRoomMainImage(rightsHotelRoomTypePO.getRoomMainImage());
            responseVO.setRoomOtherImage(rightsHotelRoomTypePO.getRoomOtherImage());
            responseVO.setRoomOriginalPrice(rightsHotelRoomTypePO.getRoomOriginalPrice());
            responseVO.setRoomMemberPrice(rightsHotelRoomTypePO.getRoomMemberPrice());
            responseVO.setRoomEmployeePrice(rightsHotelRoomTypePO.getRoomEmployeePrice());
            responseVO.setRoomArea(rightsHotelRoomTypePO.getRoomArea());
            responseVO.setBedType(rightsHotelRoomTypePO.getBedType());
            responseVO.setRoomFacilities(rightsHotelRoomTypePO.getRoomFacilities());
            if (!roomTypeStockBOMap.containsKey(rightsHotelRoomTypePO.getRightsHotelRoomTypeCode())) {
                responseVO.setStock(Integer.valueOf(0));
                responseVOList.add(responseVO);
                continue;
            }
            RightsHotelRoomTypeStockBO rightsHotelRoomTypeStockBO2 = (RightsHotelRoomTypeStockBO)roomTypeStockBOMap.get(rightsHotelRoomTypePO.getRightsHotelRoomTypeCode());
            if (rightsHotelRoomTypeStockBO2.getDayCount().intValue() != localDates.size()) {
                responseVO.setStock(Integer.valueOf(0));
                responseVOList.add(responseVO);
                continue;
            }
            responseVO.setStock(rightsHotelRoomTypeStockBO2.getMinTotalStock());
            responseVOList.add(responseVO);
        }
        responseVOList.sort(Comparator.comparing(RightsHotelRoomTypeDetailResponseVO::getRoomEmployeePrice));
        return responseVOList;
    }

    public ResponseData<RightsHotelDetailResponseVO> detailWithRoomType(RightsHotelRoomTypeDetailRequestVO requestVO) {
        RightsHotelPO rightsHotelPO = this.rightsHotelService.detailByCode(requestVO.getRightsHotelCode());
        if (rightsHotelPO == null || !rightsHotelPO.getEnableStatus().booleanValue()) {
            return ResponseUtil.of((SysResponseEnum)SysResponseEnum.RIGHTS_HOTEL_NOT_ENABLE);
        }
        RightsHotelDetailResponseVO responseVO = new RightsHotelDetailResponseVO();
        responseVO.setRightsHotelCode(rightsHotelPO.getRightsHotelCode());
        responseVO.setHotelName(rightsHotelPO.getHotelName());
        responseVO.setHotelCode(rightsHotelPO.getHotelCode());
        responseVO.setHotelPhone(rightsHotelPO.getHotelPhone());
        responseVO.setHotelAddress(rightsHotelPO.getHotelAddress());
        responseVO.setMainImage(rightsHotelPO.getMainImage());
        responseVO.setOtherImage(rightsHotelPO.getOtherImage());
        responseVO.setHotelSummary(rightsHotelPO.getHotelSummary());
        responseVO.setHotelIntroduction(rightsHotelPO.getHotelIntroduction());
        responseVO.setHotelAgreement(rightsHotelPO.getHotelAgreement());
        responseVO.setEnableStatus(rightsHotelPO.getEnableStatus());
        responseVO.setLongitude(rightsHotelPO.getLongitude());
        responseVO.setLatitude(rightsHotelPO.getLatitude());
        responseVO.setRemark(rightsHotelPO.getRemark());
        responseVO.setLatestCancellationTime(rightsHotelPO.getLatestCancellationTime());
        List localDates = LocalDateUtils.datesUntil((LocalDate)requestVO.getStartDate(), (LocalDate)requestVO.getEndDate());
        List rightsHotelRoomTypePOS = this.rightsHotelRoomTypeService.listByRightsHotelCode(requestVO.getRightsHotelCode());
        if (CollectionUtils.isEmpty((Collection)rightsHotelRoomTypePOS)) {
            return ResponseUtil.success((Object)new RightsHotelDetailResponseVO());
        }
        List responseVOList = this.getHotelRoomTypeDetailList(localDates, rightsHotelRoomTypePOS);
        responseVO.setRightsHotelRoomTypeList(responseVOList);
        return ResponseUtil.success((Object)responseVO);
    }

    public HotelMobileServiceImpl(IRightsHotelService rightsHotelService, IRightsHotelRoomTypeService rightsHotelRoomTypeService, IRightsHotelRoomSituationService rightsHotelRoomSituationService) {
        this.rightsHotelService = rightsHotelService;
        this.rightsHotelRoomTypeService = rightsHotelRoomTypeService;
        this.rightsHotelRoomSituationService = rightsHotelRoomSituationService;
    }
}

