/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.bizvane.rights.api.service.BarrierFreeParkingService;
import com.bizvane.rights.api.service.component.ServiceComponent;
import com.bizvane.rights.api.util.UID;
import com.bizvane.rights.domain.model.entity.RightsBarrierFreeParkingRecordPO;
import com.bizvane.rights.domain.service.IRightsBarrierFreeParkingRecordService;
import com.bizvane.rights.domain.util.ResponseUtil;
import com.bizvane.rights.vo.parking.barrierfree.RightsBarrierFreeParkingSaveRequestVO;
import com.bizvane.utils.responseinfo.ResponseData;
import java.time.LocalDateTime;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
public class BarrierFreeParkingServiceImpl
implements BarrierFreeParkingService {
    private final IRightsBarrierFreeParkingRecordService rightsBarrierFreeParkingRecordService;
    private final ServiceComponent serviceComponent;

    public ResponseData<Boolean> addOrUpdate(RightsBarrierFreeParkingSaveRequestVO requestVO) {
        RightsBarrierFreeParkingRecordPO barrierFreeParkingRecordPO = this.rightsBarrierFreeParkingRecordService.detailByReservationRecordNo(requestVO.getReservationRecordNo());
        if (barrierFreeParkingRecordPO == null) {
            return this.addBarrierFreeParkingRecord(requestVO);
        }
        return this.updateBarrierFreeParkingRecord(requestVO, barrierFreeParkingRecordPO);
    }

    @NotNull
    private ResponseData updateBarrierFreeParkingRecord(RightsBarrierFreeParkingSaveRequestVO requestVO, RightsBarrierFreeParkingRecordPO barrierFreeParkingRecordPO) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(RightsBarrierFreeParkingRecordPO::getMbrMembersCode, (Object)requestVO.getMbrMembersCode())).set(RightsBarrierFreeParkingRecordPO::getMerchantNo, (Object)requestVO.getMerchantNo())).set(RightsBarrierFreeParkingRecordPO::getReservationRecordNo, (Object)requestVO.getReservationRecordNo())).set(RightsBarrierFreeParkingRecordPO::getParkingLot, (Object)requestVO.getParkingLot())).set(RightsBarrierFreeParkingRecordPO::getLicensePlate, (Object)requestVO.getLicensePlate())).set(RightsBarrierFreeParkingRecordPO::getContactNumber, (Object)requestVO.getContactNumber())).set(RightsBarrierFreeParkingRecordPO::getContactNumberEncrypt, (Object)requestVO.getContactNumberEncrypt())).set(RightsBarrierFreeParkingRecordPO::getDisabilityCardNo, (Object)requestVO.getDisabilityCardNo())).set(RightsBarrierFreeParkingRecordPO::getAppointmentTime, (Object)requestVO.getAppointmentTime())).set(RightsBarrierFreeParkingRecordPO::getAppointmentStatus, (Object)requestVO.getAppointmentStatus())).set(RightsBarrierFreeParkingRecordPO::getPassengerInfo, (Object)requestVO.getPassengerInfo())).set(RightsBarrierFreeParkingRecordPO::getRemarks, (Object)requestVO.getRemarks())).set(RightsBarrierFreeParkingRecordPO::getModifiedDate, (Object)LocalDateTime.now())).set(RightsBarrierFreeParkingRecordPO::getModifiedUserCode, (Object)requestVO.getOptUserCode())).set(RightsBarrierFreeParkingRecordPO::getModifiedUserName, (Object)requestVO.getOptUserName())).eq(RightsBarrierFreeParkingRecordPO::getRightsBarrierFreeParkingRecordCode, (Object)barrierFreeParkingRecordPO.getRightsBarrierFreeParkingRecordCode());
        boolean update = this.rightsBarrierFreeParkingRecordService.update((Wrapper)updateWrapper);
        if (update) {
            this.serviceComponent.syncBarrierFreeParkingAsync(barrierFreeParkingRecordPO.getRightsBarrierFreeParkingRecordCode());
        }
        return ResponseUtil.success((Object)update);
    }

    @NotNull
    private ResponseData addBarrierFreeParkingRecord(RightsBarrierFreeParkingSaveRequestVO requestVO) {
        RightsBarrierFreeParkingRecordPO barrierFreeParkingRecordPOAdd = new RightsBarrierFreeParkingRecordPO();
        barrierFreeParkingRecordPOAdd.setRightsBarrierFreeParkingRecordCode(UID.getUid());
        barrierFreeParkingRecordPOAdd.setMbrMembersCode(requestVO.getMbrMembersCode());
        barrierFreeParkingRecordPOAdd.setMerchantNo(requestVO.getMerchantNo());
        barrierFreeParkingRecordPOAdd.setReservationRecordNo(requestVO.getReservationRecordNo());
        barrierFreeParkingRecordPOAdd.setParkingLot(requestVO.getParkingLot());
        barrierFreeParkingRecordPOAdd.setLicensePlate(requestVO.getLicensePlate());
        barrierFreeParkingRecordPOAdd.setContactNumber(requestVO.getContactNumber());
        barrierFreeParkingRecordPOAdd.setContactNumberEncrypt(requestVO.getContactNumberEncrypt());
        barrierFreeParkingRecordPOAdd.setDisabilityCardNo(requestVO.getDisabilityCardNo());
        barrierFreeParkingRecordPOAdd.setAppointmentTime(requestVO.getAppointmentTime());
        barrierFreeParkingRecordPOAdd.setAppointmentStatus(requestVO.getAppointmentStatus());
        barrierFreeParkingRecordPOAdd.setPassengerInfo(requestVO.getPassengerInfo());
        barrierFreeParkingRecordPOAdd.setRemarks(requestVO.getRemarks());
        barrierFreeParkingRecordPOAdd.setCreateUserCode(requestVO.getOptUserCode());
        barrierFreeParkingRecordPOAdd.setCreateUserName(requestVO.getOptUserName());
        boolean save = this.rightsBarrierFreeParkingRecordService.save((Object)barrierFreeParkingRecordPOAdd);
        if (save) {
            this.serviceComponent.syncBarrierFreeParkingAsync(barrierFreeParkingRecordPOAdd.getRightsBarrierFreeParkingRecordCode());
        }
        return ResponseUtil.success((Object)save);
    }

    public BarrierFreeParkingServiceImpl(IRightsBarrierFreeParkingRecordService rightsBarrierFreeParkingRecordService, ServiceComponent serviceComponent) {
        this.rightsBarrierFreeParkingRecordService = rightsBarrierFreeParkingRecordService;
        this.serviceComponent = serviceComponent;
    }
}

