/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.service.component;

import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import com.alibaba.fastjson.JSON;
import com.bizvane.basic.feign.feign.BasicMerchantRpcFeign;
import com.bizvane.basic.feign.feign.BasicOrgRpcFeign;
import com.bizvane.basic.feign.feign.TBaseGoodsSkuFeign;
import com.bizvane.basic.feign.model.req.GoodsReq;
import com.bizvane.basic.feign.model.vo.TBasicMerchantVo;
import com.bizvane.basic.feign.model.vo.TBasicOrgVo;
import com.bizvane.rights.domain.model.entity.RightsHotelPO;
import com.bizvane.rights.domain.model.entity.RightsHotelRoomTypePO;
import com.bizvane.rights.domain.service.IRightsHotelRoomTypeService;
import com.bizvane.rights.domain.service.IRightsHotelService;
import com.bizvane.rights.domain.util.ResponseUtil;
import com.bizvane.rights.mq.HotelProductMq;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ProductComponent {
    private static final Logger log = LoggerFactory.getLogger(ProductComponent.class);
    private final TBaseGoodsSkuFeign baseGoodsSkuFeign;
    private final RocketMQTemplate rocketMQTemplate;
    private final IRightsHotelRoomTypeService rightsHotelRoomTypeService;
    private final IRightsHotelService rightsHotelService;
    private final BasicOrgRpcFeign basicOrgRpcFeign;
    private final BasicMerchantRpcFeign basicMerchantRpcFeign;

    public void syncHotelProductAsync(String roomTypeCode) {
        HotelProductMq hotelProductMq = HotelProductMq.builder().roomTypeCode(roomTypeCode).build();
        log.info("\u9152\u5e97\u623f\u578b\u540c\u6b65\u5546\u54c1:{}", (Object)JacksonUtil.bean2Json((Object)hotelProductMq));
        try {
            this.rocketMQTemplate.send(Destination.builder().topic("SYNC_ORDER_AND_SERVICE").tag("PRODUCT_HOTEL").build(), (Object)JSON.toJSONString((Object)hotelProductMq));
        }
        catch (Exception e) {
            log.error("\u9152\u5e97\u623f\u578b\u540c\u6b65\u5546\u54c1\u5f02\u5e38:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public ResponseData<Boolean> syncHotelProductSync(String roomTypeCode) {
        RightsHotelRoomTypePO rightsHotelRoomTypePO = this.rightsHotelRoomTypeService.detailByCode(roomTypeCode);
        if (rightsHotelRoomTypePO == null) {
            return ResponseUtil.fail((String)"\u9152\u5e97\u623f\u578b\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        RightsHotelPO rightsHotelPO = this.rightsHotelService.detailByCode(rightsHotelRoomTypePO.getRightsHotelCode());
        if (rightsHotelPO == null) {
            return ResponseUtil.fail((String)"\u9152\u5e97\u4e3b\u4f53\u4e0d\u5b58\u5728");
        }
        TBasicOrgVo tBasicOrgVo = new TBasicOrgVo();
        tBasicOrgVo.setOrgCode(rightsHotelPO.getOrgCode());
        ResponseData detail = this.basicOrgRpcFeign.detail(tBasicOrgVo);
        if (ResponseUtil.isFail((ResponseData)detail)) {
            return ResponseUtil.fail((String)"\u83b7\u53d6\u7ec4\u7ec7\u5931\u8d25");
        }
        TBasicOrgVo basicOrgVo = (TBasicOrgVo)detail.getData();
        TBasicMerchantVo tBasicMerchantVo = new TBasicMerchantVo();
        tBasicMerchantVo.setMerchantCode(basicOrgVo.getMerchantCode());
        ResponseData merchantVoResponseData = this.basicMerchantRpcFeign.detail(tBasicMerchantVo);
        if (ResponseUtil.isFail((ResponseData)merchantVoResponseData)) {
            return ResponseUtil.fail((String)"\u83b7\u53d6\u5546\u6237\u5931\u8d25");
        }
        TBasicMerchantVo basicMerchantVo = (TBasicMerchantVo)merchantVoResponseData.getData();
        GoodsReq hotelProduct = new GoodsReq();
        hotelProduct.setGoodsName(rightsHotelRoomTypePO.getRoomTypeName());
        hotelProduct.setGoodsNo(rightsHotelRoomTypePO.getRoomTypeCode());
        hotelProduct.setGoodsStatus(Integer.valueOf(rightsHotelRoomTypePO.getEnableStatus() != false ? 1 : 2));
        hotelProduct.setAirportCode(basicMerchantVo.getAirportCode());
        hotelProduct.setMerchantCode(basicOrgVo.getMerchantCode());
        hotelProduct.setChannelCode("10");
        hotelProduct.setSourceCode("10");
        hotelProduct.setSkuName(rightsHotelRoomTypePO.getRoomTypeName());
        hotelProduct.setSkuNo(rightsHotelRoomTypePO.getRoomTypeCode());
        hotelProduct.setImg(rightsHotelRoomTypePO.getRoomMainImage());
        hotelProduct.setSkuPrice(rightsHotelRoomTypePO.getRoomOriginalPrice());
        hotelProduct.setCreateUserCode(rightsHotelRoomTypePO.getCreateUserCode());
        hotelProduct.setCreateUserName(rightsHotelRoomTypePO.getCreateUserName());
        return this.baseGoodsSkuFeign.save(hotelProduct);
    }

    public ProductComponent(TBaseGoodsSkuFeign baseGoodsSkuFeign, RocketMQTemplate rocketMQTemplate, IRightsHotelRoomTypeService rightsHotelRoomTypeService, IRightsHotelService rightsHotelService, BasicOrgRpcFeign basicOrgRpcFeign, BasicMerchantRpcFeign basicMerchantRpcFeign) {
        this.baseGoodsSkuFeign = baseGoodsSkuFeign;
        this.rocketMQTemplate = rocketMQTemplate;
        this.rightsHotelRoomTypeService = rightsHotelRoomTypeService;
        this.rightsHotelService = rightsHotelService;
        this.basicOrgRpcFeign = basicOrgRpcFeign;
        this.basicMerchantRpcFeign = basicMerchantRpcFeign;
    }
}

