/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.service.component;

import com.bizvane.basic.feign.feign.BasicMerchantRpcFeign;
import com.bizvane.members.feign.service.OrderFeign;
import com.bizvane.rights.api.service.component.MerchantComponent;
import com.bizvane.rights.api.service.component.OrderComponent;
import com.bizvane.rights.api.service.component.OrgComponent;
import com.bizvane.rights.domain.service.IRightsHotelOrderDetailService;
import com.bizvane.rights.domain.service.IRightsHotelOrderService;
import com.bizvane.rights.domain.service.IRightsHotelService;
import com.bizvane.rights.domain.service.IRightsParkingOrderService;
import com.bizvane.rights.mq.HotelOrderMq;
import com.bizvane.rights.mq.ParkingOrderMq;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class OrderTemporaryComponent {
    private static final Logger log = LoggerFactory.getLogger(OrderTemporaryComponent.class);
    private final OrderFeign orderFeign;
    private final IRightsHotelOrderService rightsHotelOrderService;
    private final IRightsHotelOrderDetailService rightsHotelOrderDetailService;
    private final OrgComponent orgComponent;
    private final IRightsHotelService rightsHotelService;
    private final MerchantComponent merchantComponent;
    private final IRightsParkingOrderService rightsParkingOrderService;
    private final OrderComponent orderComponent;
    private final BasicMerchantRpcFeign basicMerchantRpcFeign;

    @Async(value="customThreadPool")
    public void syncHotelOrderAsync(String rightsHotelOrderCode) {
        HotelOrderMq hotelOrderMq = HotelOrderMq.builder().rightsHotelOrderCode(rightsHotelOrderCode).build();
        log.info("\u9152\u5e97\u8ba2\u5355\u540c\u6b65:{}", (Object)JacksonUtil.bean2Json((Object)hotelOrderMq));
        try {
            this.orderComponent.syncHotelOrderSync(rightsHotelOrderCode);
        }
        catch (Exception e) {
            log.error("\u9152\u5e97\u8ba2\u5355\u540c\u6b65\u5f02\u5e38:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    @Async(value="customThreadPool")
    public void syncParkingOrderAsync(String parkingRecordNo) {
        ParkingOrderMq parkingOrderMq = ParkingOrderMq.builder().parkingRecordNo(parkingRecordNo).build();
        log.info("\u505c\u8f66\u8ba2\u5355\u540c\u6b65:{}", (Object)JacksonUtil.bean2Json((Object)parkingOrderMq));
        try {
            this.orderComponent.syncParkingOrderSync(parkingRecordNo);
        }
        catch (Exception e) {
            log.error("\u505c\u8f66\u8ba2\u5355\u540c\u6b65\u5f02\u5e38:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public OrderTemporaryComponent(OrderFeign orderFeign, IRightsHotelOrderService rightsHotelOrderService, IRightsHotelOrderDetailService rightsHotelOrderDetailService, OrgComponent orgComponent, IRightsHotelService rightsHotelService, MerchantComponent merchantComponent, IRightsParkingOrderService rightsParkingOrderService, OrderComponent orderComponent, BasicMerchantRpcFeign basicMerchantRpcFeign) {
        this.orderFeign = orderFeign;
        this.rightsHotelOrderService = rightsHotelOrderService;
        this.rightsHotelOrderDetailService = rightsHotelOrderDetailService;
        this.orgComponent = orgComponent;
        this.rightsHotelService = rightsHotelService;
        this.merchantComponent = merchantComponent;
        this.rightsParkingOrderService = rightsParkingOrderService;
        this.orderComponent = orderComponent;
        this.basicMerchantRpcFeign = basicMerchantRpcFeign;
    }
}

