/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.quicka.utils;

import com.aliyuncs.quicka.utils.IOUtils;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XmlUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getDocument(String payload) throws ParserConfigurationException, SAXException, IOException {
        if (payload == null || payload.length() < 1) {
            return null;
        }
        StringReader sr = new StringReader(payload);
        InputSource source = new InputSource(sr);
        Document doc = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            doc = builder.parse(source);
        }
        finally {
            IOUtils.closeQuietly(source.getByteStream());
        }
        return doc;
    }

    public static Element getRootElementFromString(String payload) throws ParserConfigurationException, SAXException, IOException {
        Document doc = XmlUtils.getDocument(payload);
        if (doc == null) {
            return null;
        }
        return doc.getDocumentElement();
    }

    public static List<Element> getChildElements(Element parent, String tagName) {
        if (null == parent) {
            return null;
        }
        NodeList nodes = parent.getElementsByTagName(tagName);
        ArrayList<Element> elements = new ArrayList<Element>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getParentNode() != parent) continue;
            elements.add((Element)node);
        }
        return elements;
    }

    public static List<Element> getChildElements(Element parent) {
        if (null == parent) {
            return null;
        }
        NodeList nodes = parent.getChildNodes();
        ArrayList<Element> elements = new ArrayList<Element>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            elements.add((Element)node);
        }
        return elements;
    }
}

