/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.quicka.endpoint;

import com.aliyuncs.quicka.endpoint.EndpointResolverBase;
import com.aliyuncs.quicka.endpoint.ResolveEndpointRequest;
import java.util.HashSet;
import java.util.Set;

public class UserCustomizedEndpointResolver
extends EndpointResolverBase {
    private Set<String> validRegionIds = new HashSet<String>();

    public void putEndpointEntry(String regionId, String productCode, String endpoint) {
        this.putEndpointEntry(this.makeEndpointKey(productCode, regionId), endpoint);
        this.validRegionIds.add(regionId);
    }

    @Override
    public String resolve(ResolveEndpointRequest request) {
        return this.fetchEndpointEntry(request);
    }

    @Override
    public String makeEndpointKey(ResolveEndpointRequest request) {
        return this.makeEndpointKey(request.productCode, request.regionId);
    }

    public String makeEndpointKey(String productCode, String regionId) {
        return productCode.toLowerCase() + "." + regionId.toLowerCase();
    }

    @Override
    public boolean isRegionIdValid(ResolveEndpointRequest request) {
        return this.validRegionIds.contains(request.regionId);
    }
}

