/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.quicka.endpoint;

import com.aliyuncs.quicka.endpoint.EndpointResolverBase;
import com.aliyuncs.quicka.endpoint.ResolveEndpointRequest;
import java.util.HashMap;

public class EndpointResolverRules
extends EndpointResolverBase {
    private Boolean validRegionId = false;
    private Boolean validProductId = false;
    private HashMap<String, String> productEndpointMap = null;
    private String productEndpointRegional = null;
    private String productNetwork = "public";
    private String productSuffix = "";

    @Override
    public String resolve(ResolveEndpointRequest request) {
        this.productEndpointMap = request.productEndpointMap;
        this.productEndpointRegional = request.productEndpointRegional;
        this.productNetwork = request.productNetwork;
        this.productSuffix = request.productSuffix;
        if (this.productEndpointMap == null || this.productEndpointRegional == null) {
            return null;
        }
        return this.getEndpoint(request.productCode, request.regionId);
    }

    @Override
    public String makeEndpointKey(ResolveEndpointRequest request) {
        return this.makeEndpointKey(request.productCode, request.regionId);
    }

    public String makeEndpointKey(String productCode, String regionId) {
        return productCode.toLowerCase() + "." + regionId.toLowerCase();
    }

    private String getEndpoint(String productCode, String regionId) {
        if (this.productEndpointRegional != null && this.productEndpointMap != null) {
            if ("".equals(this.productNetwork) || this.productNetwork == null) {
                this.productNetwork = "public";
            }
            if ("public".equals(this.productNetwork) && this.productEndpointMap.containsKey(regionId)) {
                return this.productEndpointMap.get(regionId);
            }
            String endpoint = "";
            if ("regional".equals(this.productEndpointRegional)) {
                endpoint = "<product_id><suffix><network>.<region_id>.aliyuncs.com";
                endpoint = endpoint.replace("<region_id>", regionId.toLowerCase());
            } else {
                endpoint = "<product_id><suffix><network>.aliyuncs.com";
            }
            endpoint = this.productSuffix == null || "".equals(this.productSuffix) ? endpoint.replace("<suffix>", "") : endpoint.replace("<suffix>", "-" + this.productSuffix.toLowerCase());
            endpoint = "public".equals(this.productNetwork) ? endpoint.replace("<network>", "") : endpoint.replace("<network>", "-" + this.productNetwork.toLowerCase());
            endpoint = endpoint.replace("<product_id>", productCode.toLowerCase());
            this.validRegionId = true;
            this.validProductId = true;
            return endpoint;
        }
        return null;
    }

    @Override
    public boolean isProductCodeValid(ResolveEndpointRequest request) {
        return this.validProductId;
    }

    @Override
    public boolean isRegionIdValid(ResolveEndpointRequest request) {
        return this.validRegionId;
    }
}

