/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.quicka.auth;

import com.aliyuncs.quicka.DefaultAcsClient;
import com.aliyuncs.quicka.IAcsClient;
import com.aliyuncs.quicka.auth.AlibabaCloudCredentials;
import com.aliyuncs.quicka.auth.AlibabaCloudCredentialsProvider;
import com.aliyuncs.quicka.auth.BasicSessionCredentials;
import com.aliyuncs.quicka.auth.StaticCredentialsProvider;
import com.aliyuncs.quicka.auth.sts.AssumeRoleRequest;
import com.aliyuncs.quicka.auth.sts.AssumeRoleResponse;
import com.aliyuncs.quicka.exceptions.ClientException;
import com.aliyuncs.quicka.exceptions.ServerException;
import com.aliyuncs.quicka.profile.DefaultProfile;
import com.aliyuncs.quicka.profile.IClientProfile;

public class STSAssumeRoleSessionCredentialsProvider
implements AlibabaCloudCredentialsProvider {
    public static final int DEFAULT_DURATION_SECONDS = 3600;
    private final String roleArn;
    public long assumeRoleRound = 0L;
    private IAcsClient stsClient;
    private String roleSessionName;
    private long roleSessionDurationSeconds;
    private String policy;
    private BasicSessionCredentials credentials = null;

    public STSAssumeRoleSessionCredentialsProvider(AlibabaCloudCredentials longLivedCredentials, String roleArn, IClientProfile clientProfile) {
        this(new StaticCredentialsProvider(longLivedCredentials), roleArn, clientProfile);
    }

    public STSAssumeRoleSessionCredentialsProvider(AlibabaCloudCredentialsProvider longLivedCredentialsProvider, String roleArn, IClientProfile clientProfile) {
        if (roleArn == null) {
            throw new NullPointerException("You must specify a value for roleArn.");
        }
        this.roleArn = roleArn;
        this.roleSessionName = STSAssumeRoleSessionCredentialsProvider.getNewRoleSessionName();
        this.stsClient = new DefaultAcsClient(clientProfile, longLivedCredentialsProvider);
        this.roleSessionDurationSeconds = 3600L;
    }

    public STSAssumeRoleSessionCredentialsProvider(String accessKeyId, String accessKeySecret, String roleSessionName, String roleArn, String regionId) {
        this.roleArn = roleArn;
        this.roleSessionName = roleSessionName;
        DefaultProfile profile = DefaultProfile.getProfile(regionId, accessKeyId, accessKeySecret);
        this.stsClient = new DefaultAcsClient(profile);
        this.roleSessionDurationSeconds = 3600L;
    }

    public STSAssumeRoleSessionCredentialsProvider(String accessKeyId, String accessKeySecret, String roleSessionName, String roleArn, String regionId, String policy) {
        this(accessKeyId, accessKeySecret, roleSessionName, roleArn, regionId);
        this.policy = policy;
    }

    public static String getNewRoleSessionName() {
        return "aliyun-java-sdk-" + System.currentTimeMillis();
    }

    public STSAssumeRoleSessionCredentialsProvider withRoleSessionName(String roleSessionName) {
        this.roleSessionName = roleSessionName;
        return this;
    }

    public STSAssumeRoleSessionCredentialsProvider withRoleSessionDurationSeconds(long roleSessionDurationSeconds) {
        if (roleSessionDurationSeconds < 900L || roleSessionDurationSeconds > 3600L) {
            throw new IllegalArgumentException("Assume Role session duration should be in the range of 15min - 1Hr");
        }
        this.roleSessionDurationSeconds = roleSessionDurationSeconds;
        return this;
    }

    public STSAssumeRoleSessionCredentialsProvider withSTSClient(IAcsClient client) {
        this.stsClient = client;
        return this;
    }

    @Override
    public AlibabaCloudCredentials getCredentials() throws ClientException, ServerException {
        if (this.credentials == null || this.credentials.willSoonExpire()) {
            this.credentials = this.getNewSessionCredentials();
        }
        return this.credentials;
    }

    private BasicSessionCredentials getNewSessionCredentials() throws ClientException, ServerException {
        ++this.assumeRoleRound;
        AssumeRoleRequest assumeRoleRequest = new AssumeRoleRequest();
        assumeRoleRequest.setRoleArn(this.roleArn);
        assumeRoleRequest.setRoleSessionName(this.roleSessionName);
        assumeRoleRequest.setDurationSeconds(this.roleSessionDurationSeconds);
        if (null != this.policy) {
            assumeRoleRequest.setPolicy(this.policy);
        }
        AssumeRoleResponse response = this.stsClient.getAcsResponse(assumeRoleRequest);
        return new BasicSessionCredentials(response.getCredentials().getAccessKeyId(), response.getCredentials().getAccessKeySecret(), response.getCredentials().getSecurityToken(), this.roleSessionDurationSeconds);
    }
}

