/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.quicka.auth;

import com.aliyuncs.quicka.auth.ISignatureComposer;
import com.aliyuncs.quicka.auth.RoaSignatureComposer;
import com.aliyuncs.quicka.auth.Signer;
import com.aliyuncs.quicka.http.FormatType;
import com.aliyuncs.quicka.http.MethodType;
import com.aliyuncs.quicka.utils.ParameterHelper;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class OssSignatureComposer
extends RoaSignatureComposer {
    private static ISignatureComposer composer = null;

    public static ISignatureComposer getComposer() {
        if (null == composer) {
            composer = new OssSignatureComposer();
        }
        return composer;
    }

    @Override
    public Map<String, String> refreshSignParameters(Map<String, String> parameters, Signer signer, String accessKeyId, FormatType format) {
        HashMap<String, String> immutableMap = new HashMap<String, String>(parameters);
        immutableMap.put("Date", ParameterHelper.getRFC2616Date(new Date()));
        return immutableMap;
    }

    private String buildQueryString(String uri, Map<String, String> queries) {
        StringBuilder queryBuilder = new StringBuilder(uri);
        if (0 < queries.size()) {
            queryBuilder.append("?");
        }
        for (Map.Entry<String, String> e : queries.entrySet()) {
            queryBuilder.append(e.getKey());
            if (null != e.getValue()) {
                queryBuilder.append("=").append(e.getValue());
            }
            queryBuilder.append("&");
        }
        String queryString = queryBuilder.toString();
        if (queryString.endsWith("&")) {
            queryString = queryString.substring(0, queryString.length() - 1);
        }
        return queryString;
    }

    @Override
    public String composeStringToSign(MethodType method, String uriPattern, Signer signer, Map<String, String> queries, Map<String, String> headers, Map<String, String> paths) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)method).append("\n");
        if (headers.get("Content-MD5") != null) {
            sb.append(headers.get("Content-MD5"));
        }
        sb.append("\n");
        if (headers.get("Content-Type") != null) {
            sb.append(headers.get("Content-Type"));
        }
        sb.append("\n");
        if (headers.get("Date") != null) {
            sb.append(headers.get("Date"));
        }
        sb.append("\n");
        sb.append(this.buildCanonicalHeaders(headers, "x-oss-"));
        sb.append(this.buildQueryString(uriPattern, queries));
        return sb.toString();
    }
}

