/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.quicka.auth;

import com.aliyuncs.quicka.auth.AlibabaCloudCredentials;
import com.aliyuncs.quicka.auth.AlibabaCloudCredentialsProvider;
import com.aliyuncs.quicka.auth.ECSMetadataServiceCredentialsFetcher;
import com.aliyuncs.quicka.auth.InstanceProfileCredentials;
import com.aliyuncs.quicka.exceptions.ClientException;

public class InstanceProfileCredentialsProvider
implements AlibabaCloudCredentialsProvider {
    private static final int MAX_ECS_METADATA_FETCH_RETRY_TIMES = 3;
    private final String roleName;
    public int ecsMetadataServiceFetchCount = 0;
    private InstanceProfileCredentials credentials = null;
    private ECSMetadataServiceCredentialsFetcher fetcher;

    public InstanceProfileCredentialsProvider(String roleName) {
        if (null == roleName) {
            throw new NullPointerException("You must specifiy a valid role name.");
        }
        this.roleName = roleName;
        this.fetcher = new ECSMetadataServiceCredentialsFetcher();
        this.fetcher.setRoleName(this.roleName);
    }

    public InstanceProfileCredentialsProvider withFetcher(ECSMetadataServiceCredentialsFetcher fetcher) {
        this.fetcher = fetcher;
        this.fetcher.setRoleName(this.roleName);
        return this;
    }

    @Override
    public AlibabaCloudCredentials getCredentials() throws ClientException {
        if (this.credentials == null || this.credentials.isExpired()) {
            ++this.ecsMetadataServiceFetchCount;
            int maxRetryTimes = 3;
            this.credentials = this.fetcher.fetch(maxRetryTimes);
        } else if (this.credentials.willSoonExpire() && this.credentials.shouldRefresh()) {
            try {
                ++this.ecsMetadataServiceFetchCount;
                this.credentials = this.fetcher.fetch();
            }
            catch (ClientException e) {
                this.credentials.setLastFailedRefreshTime();
            }
        }
        return this.credentials;
    }
}

