package com.bizvane.platform.feign.model.req;

import com.bizvane.platform.feign.model.req.base.BasePageReq;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.constraints.NotBlank;
import lombok.Getter;
import lombok.Setter;


@Getter
@Setter
public class TBasicStaffPageReq extends BasePageReq {

    @ApiModelProperty(value = "员工名称")
    private String name;

    @ApiModelProperty(value = "员工编码（支持多个员工编码，用逗号隔开）")
    private String staffNo;

    @ApiModelProperty(value = "手机号")
    private String phone;

    @ApiModelProperty(value = "状态：0=离职；1=在职  2=退休")
    private Integer status;

    @ApiModelProperty(value = "租户ID")
    @NotBlank(message = "租户ID不能为空")
    private String tenantId;

}
