package com.bizvane.platform.feign.feign.basic;

import com.bizvane.platform.feign.model.req.TSysTenantPageReq;
import com.bizvane.platform.feign.model.vo.TSysTenantVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient(value = "${feign.client.basic.name}", path = "${feign.client.basic.path}" + "/tSysTenant")
@Api(value = "租户RPC")
public interface SysTenantRpcFeign {

    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ApiOperation(value = "分页条件查询列表")
    ResponseData<PageInfo<TSysTenantVo>> pageList(@RequestBody TSysTenantPageReq req);

    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(value = "添加租户")
    ResponseData<Boolean> save(@RequestBody TSysTenantVo req);

    @RequestMapping(value = "/modify", method = RequestMethod.POST)
    @ApiOperation(value = "编辑租户")
    ResponseData<Boolean> modify(@RequestBody TSysTenantVo req);

    @RequestMapping(value = "/detail", method = RequestMethod.POST)
    @ApiOperation(value = "详情")
    ResponseData<TSysTenantVo> detail(@RequestBody TSysTenantVo req);


}
