package com.bizvane.payment.feign.vo.req;

import com.bizvane.utils.requestinfo.BasePageReq;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;

@Data
public class IcbcPayFrozenRecordPageReqVO extends BasePageReq implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("工行服务商编号")
    private String icbcSerNo;

    @ApiModelProperty("工行订单号")
    private String icbcOrderNo;

    @ApiModelProperty("记录状态 1冻结 2待分账(已解冻) 3已分账")
    private Integer recordState;

    @ApiModelProperty("工行交易流水号")
    private String icbcTrxSerialNo;

    @ApiModelProperty("工行交易日期开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate startIcbcTrxDate;

    @ApiModelProperty("工行交易日期结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate endIcbcTrxDate;
}
