package com.bizvane.payment.feign.vo.req;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;

@Data
public class BaseMerchantVO {

    @ApiModelProperty("商户支付配置系统编号code")
    @NotEmpty(message = "商户支付配置系统编号code不能为空")
    private String paymentMerchantConfigCode;

    @ApiModelProperty("支付场景类型 PaymentChannelTypeEnum")
    @NotEmpty(message = "支付场景类型不能为空 PaymentChannelTypeEnum")
    private String channelType;
}
