package com.bizvane.payment.feign.contants;

import lombok.Getter;

@Getter
public enum PaymentChannelTypeEnum {

    POINT_MALL("pointMall", "积分商城"),
    HOTEL_ORDER("hotelOrder", "酒店订单"),
    STEWARD_ORDER("stewardOrder", "中台端-机场管家订单"),
    STEWARD_ORDER_MOBILE("stewardOrderMobile", "会员端-机场管家订单"),
    STEWARD_ORDER_ADDITIONAL_MOBILE("stewardOrderAdditionalMobile", "会员端-机场管家订单额外支付");

    final private String code;
    final private String name;

    PaymentChannelTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static PaymentChannelTypeEnum getEnumByCode(String code) {
        for (PaymentChannelTypeEnum e : PaymentChannelTypeEnum.values()) {
            if (e.getCode().equals(code)) {
                return e;
            }
        }
        return null;
    }
}
